// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.gamelift.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Represents an EC2 instance of virtual computing resources that hosts one or more game servers. In GameLift, a fleet can contain zero or more instances.
 *
 * **Related actions**
 *
 * DescribeInstances
 */
public class Instance private constructor(builder: Builder) {
    /**
     * A time stamp indicating when this data object was created. Format is a number expressed in Unix time as milliseconds (for example `"1469498468.057"`).
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * The DNS identifier assigned to the instance that is running the game session. Values have the following format:
     * + TLS-enabled fleets: `<unique identifier>.<region identifier>.amazongamelift.com`.
     * + Non-TLS-enabled fleets: `ec2-<unique identifier>.compute.amazonaws.com`. (See [Amazon EC2 Instance IP Addressing](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-instance-addressing.html#concepts-public-addresses).)
     *
     * When connecting to a game session that is running on a TLS-enabled fleet, you must use the DNS name, not the IP address.
     */
    public val dnsName: kotlin.String? = builder.dnsName
    /**
     * The Amazon Resource Name ([ARN](https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html)) that is assigned to a GameLift fleet resource and uniquely identifies it. ARNs are unique across all Regions. Format is `arn:aws:gamelift:<region>::fleet/fleet-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912`.
     */
    public val fleetArn: kotlin.String? = builder.fleetArn
    /**
     * A unique identifier for the fleet that the instance is in.
     */
    public val fleetId: kotlin.String? = builder.fleetId
    /**
     * A unique identifier for the instance.
     */
    public val instanceId: kotlin.String? = builder.instanceId
    /**
     * IP address that is assigned to the instance.
     */
    public val ipAddress: kotlin.String? = builder.ipAddress
    /**
     * The fleet location of the instance, expressed as an Amazon Web Services Region code, such as `us-west-2`.
     */
    public val location: kotlin.String? = builder.location
    /**
     * Operating system that is running on this instance.
     */
    public val operatingSystem: aws.sdk.kotlin.services.gamelift.model.OperatingSystem? = builder.operatingSystem
    /**
     * Current status of the instance. Possible statuses include the following:
     * + **PENDING** -- The instance is in the process of being created and launching server processes as defined in the fleet's run-time configuration.
     * + **ACTIVE** -- The instance has been successfully created and at least one server process has successfully launched and reported back to GameLift that it is ready to host a game session. The instance is now considered ready to host game sessions.
     * + **TERMINATING** -- The instance is in the process of shutting down. This may happen to reduce capacity during a scaling down event or to recycle resources in the event of a problem.
     */
    public val status: aws.sdk.kotlin.services.gamelift.model.InstanceStatus? = builder.status
    /**
     * Amazon EC2 instance type that defines the computing resources of this instance.
     */
    public val type: aws.sdk.kotlin.services.gamelift.model.Ec2InstanceType? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.gamelift.model.Instance = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Instance(")
        append("creationTime=$creationTime,")
        append("dnsName=$dnsName,")
        append("fleetArn=$fleetArn,")
        append("fleetId=$fleetId,")
        append("instanceId=$instanceId,")
        append("ipAddress=$ipAddress,")
        append("location=$location,")
        append("operatingSystem=$operatingSystem,")
        append("status=$status,")
        append("type=$type)")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationTime?.hashCode() ?: 0
        result = 31 * result + (dnsName?.hashCode() ?: 0)
        result = 31 * result + (fleetArn?.hashCode() ?: 0)
        result = 31 * result + (fleetId?.hashCode() ?: 0)
        result = 31 * result + (instanceId?.hashCode() ?: 0)
        result = 31 * result + (ipAddress?.hashCode() ?: 0)
        result = 31 * result + (location?.hashCode() ?: 0)
        result = 31 * result + (operatingSystem?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Instance

        if (creationTime != other.creationTime) return false
        if (dnsName != other.dnsName) return false
        if (fleetArn != other.fleetArn) return false
        if (fleetId != other.fleetId) return false
        if (instanceId != other.instanceId) return false
        if (ipAddress != other.ipAddress) return false
        if (location != other.location) return false
        if (operatingSystem != other.operatingSystem) return false
        if (status != other.status) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.gamelift.model.Instance = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A time stamp indicating when this data object was created. Format is a number expressed in Unix time as milliseconds (for example `"1469498468.057"`).
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The DNS identifier assigned to the instance that is running the game session. Values have the following format:
         * + TLS-enabled fleets: `<unique identifier>.<region identifier>.amazongamelift.com`.
         * + Non-TLS-enabled fleets: `ec2-<unique identifier>.compute.amazonaws.com`. (See [Amazon EC2 Instance IP Addressing](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-instance-addressing.html#concepts-public-addresses).)
         *
         * When connecting to a game session that is running on a TLS-enabled fleet, you must use the DNS name, not the IP address.
         */
        public var dnsName: kotlin.String? = null
        /**
         * The Amazon Resource Name ([ARN](https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html)) that is assigned to a GameLift fleet resource and uniquely identifies it. ARNs are unique across all Regions. Format is `arn:aws:gamelift:<region>::fleet/fleet-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912`.
         */
        public var fleetArn: kotlin.String? = null
        /**
         * A unique identifier for the fleet that the instance is in.
         */
        public var fleetId: kotlin.String? = null
        /**
         * A unique identifier for the instance.
         */
        public var instanceId: kotlin.String? = null
        /**
         * IP address that is assigned to the instance.
         */
        public var ipAddress: kotlin.String? = null
        /**
         * The fleet location of the instance, expressed as an Amazon Web Services Region code, such as `us-west-2`.
         */
        public var location: kotlin.String? = null
        /**
         * Operating system that is running on this instance.
         */
        public var operatingSystem: aws.sdk.kotlin.services.gamelift.model.OperatingSystem? = null
        /**
         * Current status of the instance. Possible statuses include the following:
         * + **PENDING** -- The instance is in the process of being created and launching server processes as defined in the fleet's run-time configuration.
         * + **ACTIVE** -- The instance has been successfully created and at least one server process has successfully launched and reported back to GameLift that it is ready to host a game session. The instance is now considered ready to host game sessions.
         * + **TERMINATING** -- The instance is in the process of shutting down. This may happen to reduce capacity during a scaling down event or to recycle resources in the event of a problem.
         */
        public var status: aws.sdk.kotlin.services.gamelift.model.InstanceStatus? = null
        /**
         * Amazon EC2 instance type that defines the computing resources of this instance.
         */
        public var type: aws.sdk.kotlin.services.gamelift.model.Ec2InstanceType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.gamelift.model.Instance) : this() {
            this.creationTime = x.creationTime
            this.dnsName = x.dnsName
            this.fleetArn = x.fleetArn
            this.fleetId = x.fleetId
            this.instanceId = x.instanceId
            this.ipAddress = x.ipAddress
            this.location = x.location
            this.operatingSystem = x.operatingSystem
            this.status = x.status
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.gamelift.model.Instance = Instance(this)
    }
}
