// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.gamelift.model



/**
 * **This data type is used with the GameLift FleetIQ and game server groups.**
 *
 * An allowed instance type for a GameServerGroup. All game server groups must have at least two instance types defined for it. GameLift FleetIQ periodically evaluates each defined instance type for viability. It then updates the Auto Scaling group with the list of viable instance types.
 */
public class InstanceDefinition private constructor(builder: Builder) {
    /**
     * An Amazon EC2 instance type designation.
     */
    public val instanceType: aws.sdk.kotlin.services.gamelift.model.GameServerGroupInstanceType? = builder.instanceType
    /**
     * Instance weighting that indicates how much this instance type contributes to the total capacity of a game server group. Instance weights are used by GameLift FleetIQ to calculate the instance type's cost per unit hour and better identify the most cost-effective options. For detailed information on weighting instance capacity, see [Instance Weighting](https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-instance-weighting.html) in the *Amazon Elastic Compute Cloud Auto Scaling User Guide*. Default value is "1".
     */
    public val weightedCapacity: kotlin.String? = builder.weightedCapacity

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.gamelift.model.InstanceDefinition = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InstanceDefinition(")
        append("instanceType=$instanceType,")
        append("weightedCapacity=$weightedCapacity)")
    }

    override fun hashCode(): kotlin.Int {
        var result = instanceType?.hashCode() ?: 0
        result = 31 * result + (weightedCapacity?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InstanceDefinition

        if (instanceType != other.instanceType) return false
        if (weightedCapacity != other.weightedCapacity) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.gamelift.model.InstanceDefinition = Builder(this).apply(block).build()

    public class Builder {
        /**
         * An Amazon EC2 instance type designation.
         */
        public var instanceType: aws.sdk.kotlin.services.gamelift.model.GameServerGroupInstanceType? = null
        /**
         * Instance weighting that indicates how much this instance type contributes to the total capacity of a game server group. Instance weights are used by GameLift FleetIQ to calculate the instance type's cost per unit hour and better identify the most cost-effective options. For detailed information on weighting instance capacity, see [Instance Weighting](https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-instance-weighting.html) in the *Amazon Elastic Compute Cloud Auto Scaling User Guide*. Default value is "1".
         */
        public var weightedCapacity: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.gamelift.model.InstanceDefinition) : this() {
            this.instanceType = x.instanceType
            this.weightedCapacity = x.weightedCapacity
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.gamelift.model.InstanceDefinition = InstanceDefinition(this)
    }
}
