// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.gamelift.model



/**
 * Represents the input for a request operation.
 */
public class ListAliasesRequest private constructor(builder: Builder) {
    /**
     * The maximum number of results to return. Use this parameter with `NextToken` to get results as a set of sequential pages.
     */
    public val limit: kotlin.Int? = builder.limit
    /**
     * A descriptive label that is associated with an alias. Alias names do not need to be unique.
     */
    public val name: kotlin.String? = builder.name
    /**
     * A token that indicates the start of the next sequential page of results. Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * The routing type to filter results on. Use this parameter to retrieve only aliases with a certain routing type. To retrieve all aliases, leave this parameter empty.
     *
     * Possible routing types include the following:
     * + **SIMPLE** -- The alias resolves to one specific fleet. Use this type when routing to active fleets.
     * + **TERMINAL** -- The alias does not resolve to a fleet but instead can be used to display a message to the user. A terminal alias throws a TerminalRoutingStrategyException with the RoutingStrategy message embedded.
     */
    public val routingStrategyType: aws.sdk.kotlin.services.gamelift.model.RoutingStrategyType? = builder.routingStrategyType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.gamelift.model.ListAliasesRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListAliasesRequest(")
        append("limit=$limit,")
        append("name=$name,")
        append("nextToken=$nextToken,")
        append("routingStrategyType=$routingStrategyType)")
    }

    override fun hashCode(): kotlin.Int {
        var result = limit ?: 0
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (routingStrategyType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListAliasesRequest

        if (limit != other.limit) return false
        if (name != other.name) return false
        if (nextToken != other.nextToken) return false
        if (routingStrategyType != other.routingStrategyType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.gamelift.model.ListAliasesRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The maximum number of results to return. Use this parameter with `NextToken` to get results as a set of sequential pages.
         */
        public var limit: kotlin.Int? = null
        /**
         * A descriptive label that is associated with an alias. Alias names do not need to be unique.
         */
        public var name: kotlin.String? = null
        /**
         * A token that indicates the start of the next sequential page of results. Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value.
         */
        public var nextToken: kotlin.String? = null
        /**
         * The routing type to filter results on. Use this parameter to retrieve only aliases with a certain routing type. To retrieve all aliases, leave this parameter empty.
         *
         * Possible routing types include the following:
         * + **SIMPLE** -- The alias resolves to one specific fleet. Use this type when routing to active fleets.
         * + **TERMINAL** -- The alias does not resolve to a fleet but instead can be used to display a message to the user. A terminal alias throws a TerminalRoutingStrategyException with the RoutingStrategy message embedded.
         */
        public var routingStrategyType: aws.sdk.kotlin.services.gamelift.model.RoutingStrategyType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.gamelift.model.ListAliasesRequest) : this() {
            this.limit = x.limit
            this.name = x.name
            this.nextToken = x.nextToken
            this.routingStrategyType = x.routingStrategyType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.gamelift.model.ListAliasesRequest = ListAliasesRequest(this)
    }
}
