// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.gamelift.model



/**
 * Represents the input for a request operation.
 */
public class ListBuildsRequest private constructor(builder: Builder) {
    /**
     * The maximum number of results to return. Use this parameter with `NextToken` to get results as a set of sequential pages.
     */
    public val limit: kotlin.Int? = builder.limit
    /**
     * A token that indicates the start of the next sequential page of results. Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * Build status to filter results by. To retrieve all builds, leave this parameter empty.
     *
     * Possible build statuses include the following:
     * + **INITIALIZED** -- A new build has been defined, but no files have been uploaded. You cannot create fleets for builds that are in this status. When a build is successfully created, the build status is set to this value.
     * + **READY** -- The game build has been successfully uploaded. You can now create new fleets for this build.
     * + **FAILED** -- The game build upload failed. You cannot create new fleets for this build.
     */
    public val status: aws.sdk.kotlin.services.gamelift.model.BuildStatus? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.gamelift.model.ListBuildsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListBuildsRequest(")
        append("limit=$limit,")
        append("nextToken=$nextToken,")
        append("status=$status)")
    }

    override fun hashCode(): kotlin.Int {
        var result = limit ?: 0
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListBuildsRequest

        if (limit != other.limit) return false
        if (nextToken != other.nextToken) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.gamelift.model.ListBuildsRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The maximum number of results to return. Use this parameter with `NextToken` to get results as a set of sequential pages.
         */
        public var limit: kotlin.Int? = null
        /**
         * A token that indicates the start of the next sequential page of results. Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value.
         */
        public var nextToken: kotlin.String? = null
        /**
         * Build status to filter results by. To retrieve all builds, leave this parameter empty.
         *
         * Possible build statuses include the following:
         * + **INITIALIZED** -- A new build has been defined, but no files have been uploaded. You cannot create fleets for builds that are in this status. When a build is successfully created, the build status is set to this value.
         * + **READY** -- The game build has been successfully uploaded. You can now create new fleets for this build.
         * + **FAILED** -- The game build upload failed. You cannot create new fleets for this build.
         */
        public var status: aws.sdk.kotlin.services.gamelift.model.BuildStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.gamelift.model.ListBuildsRequest) : this() {
            this.limit = x.limit
            this.nextToken = x.nextToken
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.gamelift.model.ListBuildsRequest = ListBuildsRequest(this)
    }
}
