// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.gamelift.model



public class ListGameServersRequest private constructor(builder: Builder) {
    /**
     * An identifier for the game server group to retrieve a list of game servers from. Use either the GameServerGroup name or ARN value.
     */
    public val gameServerGroupName: kotlin.String? = builder.gameServerGroupName
    /**
     * The maximum number of results to return. Use this parameter with `NextToken` to get results as a set of sequential pages.
     */
    public val limit: kotlin.Int? = builder.limit
    /**
     * A token that indicates the start of the next sequential page of results. Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * Indicates how to sort the returned data based on game server registration timestamp. Use `ASCENDING` to retrieve oldest game servers first, or use `DESCENDING` to retrieve newest game servers first. If this parameter is left empty, game servers are returned in no particular order.
     */
    public val sortOrder: aws.sdk.kotlin.services.gamelift.model.SortOrder? = builder.sortOrder

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.gamelift.model.ListGameServersRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListGameServersRequest(")
        append("gameServerGroupName=$gameServerGroupName,")
        append("limit=$limit,")
        append("nextToken=$nextToken,")
        append("sortOrder=$sortOrder)")
    }

    override fun hashCode(): kotlin.Int {
        var result = gameServerGroupName?.hashCode() ?: 0
        result = 31 * result + (limit ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (sortOrder?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListGameServersRequest

        if (gameServerGroupName != other.gameServerGroupName) return false
        if (limit != other.limit) return false
        if (nextToken != other.nextToken) return false
        if (sortOrder != other.sortOrder) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.gamelift.model.ListGameServersRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * An identifier for the game server group to retrieve a list of game servers from. Use either the GameServerGroup name or ARN value.
         */
        public var gameServerGroupName: kotlin.String? = null
        /**
         * The maximum number of results to return. Use this parameter with `NextToken` to get results as a set of sequential pages.
         */
        public var limit: kotlin.Int? = null
        /**
         * A token that indicates the start of the next sequential page of results. Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value.
         */
        public var nextToken: kotlin.String? = null
        /**
         * Indicates how to sort the returned data based on game server registration timestamp. Use `ASCENDING` to retrieve oldest game servers first, or use `DESCENDING` to retrieve newest game servers first. If this parameter is left empty, game servers are returned in no particular order.
         */
        public var sortOrder: aws.sdk.kotlin.services.gamelift.model.SortOrder? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.gamelift.model.ListGameServersRequest) : this() {
            this.gameServerGroupName = x.gameServerGroupName
            this.limit = x.limit
            this.nextToken = x.nextToken
            this.sortOrder = x.sortOrder
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.gamelift.model.ListGameServersRequest = ListGameServersRequest(this)
    }
}
