// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.gamelift.model



/**
 * A fleet location and its life-cycle state. A location state object might be used to describe a fleet's remote location or home Region. Life-cycle state tracks the progress of launching the first instance in a new location and preparing it for game hosting, and then removing all instances and deleting the location from the fleet.
 *
 * **Related actions**
 *
 * CreateFleet | CreateFleetLocations | DeleteFleetLocations
 */
public class LocationState private constructor(builder: Builder) {
    /**
     * The fleet location, expressed as an Amazon Web Services Region code such as `us-west-2`.
     */
    public val location: kotlin.String? = builder.location
    /**
     * The life-cycle status of a fleet location.
     */
    public val status: aws.sdk.kotlin.services.gamelift.model.FleetStatus? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.gamelift.model.LocationState = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("LocationState(")
        append("location=$location,")
        append("status=$status)")
    }

    override fun hashCode(): kotlin.Int {
        var result = location?.hashCode() ?: 0
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as LocationState

        if (location != other.location) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.gamelift.model.LocationState = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The fleet location, expressed as an Amazon Web Services Region code such as `us-west-2`.
         */
        public var location: kotlin.String? = null
        /**
         * The life-cycle status of a fleet location.
         */
        public var status: aws.sdk.kotlin.services.gamelift.model.FleetStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.gamelift.model.LocationState) : this() {
            this.location = x.location
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.gamelift.model.LocationState = LocationState(this)
    }
}
