// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.gamelift.model



/**
 * Represents a new player session that is created as a result of a successful FlexMatch match. A successful match automatically creates new player sessions for every player ID in the original matchmaking request.
 *
 * When players connect to the match's game session, they must include both player ID and player session ID in order to claim their assigned player slot.
 */
public class MatchedPlayerSession private constructor(builder: Builder) {
    /**
     * A unique identifier for a player
     */
    public val playerId: kotlin.String? = builder.playerId
    /**
     * A unique identifier for a player session
     */
    public val playerSessionId: kotlin.String? = builder.playerSessionId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.gamelift.model.MatchedPlayerSession = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("MatchedPlayerSession(")
        append("playerId=$playerId,")
        append("playerSessionId=$playerSessionId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = playerId?.hashCode() ?: 0
        result = 31 * result + (playerSessionId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as MatchedPlayerSession

        if (playerId != other.playerId) return false
        if (playerSessionId != other.playerSessionId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.gamelift.model.MatchedPlayerSession = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A unique identifier for a player
         */
        public var playerId: kotlin.String? = null
        /**
         * A unique identifier for a player session
         */
        public var playerSessionId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.gamelift.model.MatchedPlayerSession) : this() {
            this.playerId = x.playerId
            this.playerSessionId = x.playerSessionId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.gamelift.model.MatchedPlayerSession = MatchedPlayerSession(this)
    }
}
