// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.gamelift.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Set of rule statements, used with FlexMatch, that determine how to build your player matches. Each rule set describes a type of group to be created and defines the parameters for acceptable player matches. Rule sets are used in MatchmakingConfiguration objects.
 *
 * A rule set may define the following elements for a match. For detailed information and examples showing how to construct a rule set, see [Build a FlexMatch rule set](https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-rulesets.html).
 * + Teams -- Required. A rule set must define one or multiple teams for the match and set minimum and maximum team sizes. For example, a rule set might describe a 4x4 match that requires all eight slots to be filled.
 * + Player attributes -- Optional. These attributes specify a set of player characteristics to evaluate when looking for a match. Matchmaking requests that use a rule set with player attributes must provide the corresponding attribute values. For example, an attribute might specify a player's skill or level.
 * + Rules -- Optional. Rules define how to evaluate potential players for a match based on player attributes. A rule might specify minimum requirements for individual players, teams, or entire matches. For example, a rule might require each player to meet a certain skill level, each team to have at least one player in a certain role, or the match to have a minimum average skill level. or may describe an entire group--such as all teams must be evenly matched or have at least one player in a certain role.
 * + Expansions -- Optional. Expansions allow you to relax the rules after a period of time when no acceptable matches are found. This feature lets you balance getting players into games in a reasonable amount of time instead of making them wait indefinitely for the best possible match. For example, you might use an expansion to increase the maximum skill variance between players after 30 seconds.
 */
public class MatchmakingRuleSet private constructor(builder: Builder) {
    /**
     * A time stamp indicating when this data object was created. Format is a number expressed in Unix time as milliseconds (for example `"1469498468.057"`).
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * The Amazon Resource Name ([ARN](https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html)) that is assigned to a GameLift matchmaking rule set resource and uniquely identifies it. ARNs are unique across all Regions. Format is `arn:aws:gamelift:<region>::matchmakingruleset/<ruleset name>`. In a GameLift rule set ARN, the resource ID matches the *RuleSetName* value.
     */
    public val ruleSetArn: kotlin.String? = builder.ruleSetArn
    /**
     * A collection of matchmaking rules, formatted as a JSON string. Comments are not allowed in JSON, but most elements support a description field.
     */
    public val ruleSetBody: kotlin.String? = builder.ruleSetBody
    /**
     * A unique identifier for the matchmaking rule set
     */
    public val ruleSetName: kotlin.String? = builder.ruleSetName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.gamelift.model.MatchmakingRuleSet = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("MatchmakingRuleSet(")
        append("creationTime=$creationTime,")
        append("ruleSetArn=$ruleSetArn,")
        append("ruleSetBody=$ruleSetBody,")
        append("ruleSetName=$ruleSetName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationTime?.hashCode() ?: 0
        result = 31 * result + (ruleSetArn?.hashCode() ?: 0)
        result = 31 * result + (ruleSetBody?.hashCode() ?: 0)
        result = 31 * result + (ruleSetName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as MatchmakingRuleSet

        if (creationTime != other.creationTime) return false
        if (ruleSetArn != other.ruleSetArn) return false
        if (ruleSetBody != other.ruleSetBody) return false
        if (ruleSetName != other.ruleSetName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.gamelift.model.MatchmakingRuleSet = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A time stamp indicating when this data object was created. Format is a number expressed in Unix time as milliseconds (for example `"1469498468.057"`).
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Name ([ARN](https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html)) that is assigned to a GameLift matchmaking rule set resource and uniquely identifies it. ARNs are unique across all Regions. Format is `arn:aws:gamelift:<region>::matchmakingruleset/<ruleset name>`. In a GameLift rule set ARN, the resource ID matches the *RuleSetName* value.
         */
        public var ruleSetArn: kotlin.String? = null
        /**
         * A collection of matchmaking rules, formatted as a JSON string. Comments are not allowed in JSON, but most elements support a description field.
         */
        public var ruleSetBody: kotlin.String? = null
        /**
         * A unique identifier for the matchmaking rule set
         */
        public var ruleSetName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.gamelift.model.MatchmakingRuleSet) : this() {
            this.creationTime = x.creationTime
            this.ruleSetArn = x.ruleSetArn
            this.ruleSetBody = x.ruleSetBody
            this.ruleSetName = x.ruleSetName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.gamelift.model.MatchmakingRuleSet = MatchmakingRuleSet(this)
    }
}
