// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.gamelift.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Ticket generated to track the progress of a matchmaking request. Each ticket is uniquely identified by a ticket ID, supplied by the requester, when creating a matchmaking request with StartMatchmaking. Tickets can be retrieved by calling DescribeMatchmaking with the ticket ID.
 */
public class MatchmakingTicket private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name ([ARN](https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html)) associated with the GameLift matchmaking configuration resource that is used with this ticket.
     */
    public val configurationArn: kotlin.String? = builder.configurationArn
    /**
     * Name of the MatchmakingConfiguration that is used with this ticket. Matchmaking configurations determine how players are grouped into a match and how a new game session is created for the match.
     */
    public val configurationName: kotlin.String? = builder.configurationName
    /**
     * Time stamp indicating when this matchmaking request stopped being processed due to success, failure, or cancellation. Format is a number expressed in Unix time as milliseconds (for example `"1469498468.057"`).
     */
    public val endTime: aws.smithy.kotlin.runtime.time.Instant? = builder.endTime
    /**
     * Average amount of time (in seconds) that players are currently waiting for a match. If there is not enough recent data, this property may be empty.
     */
    public val estimatedWaitTime: kotlin.Int? = builder.estimatedWaitTime
    /**
     * Identifier and connection information of the game session created for the match. This information is added to the ticket only after the matchmaking request has been successfully completed. This parameter is not set when FlexMatch is being used without GameLift hosting.
     */
    public val gameSessionConnectionInfo: aws.sdk.kotlin.services.gamelift.model.GameSessionConnectionInfo? = builder.gameSessionConnectionInfo
    /**
     * A set of `Player` objects, each representing a player to find matches for. Players are identified by a unique player ID and may include latency data for use during matchmaking. If the ticket is in status `COMPLETED`, the `Player` objects include the team the players were assigned to in the resulting match.
     */
    public val players: List<Player>? = builder.players
    /**
     * Time stamp indicating when this matchmaking request was received. Format is a number expressed in Unix time as milliseconds (for example `"1469498468.057"`).
     */
    public val startTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startTime
    /**
     * Current status of the matchmaking request.
     * + **QUEUED** -- The matchmaking request has been received and is currently waiting to be processed.
     * + **SEARCHING** -- The matchmaking request is currently being processed.
     * + **REQUIRES_ACCEPTANCE** -- A match has been proposed and the players must accept the match (see AcceptMatch). This status is used only with requests that use a matchmaking configuration with a player acceptance requirement.
     * + **PLACING** -- The FlexMatch engine has matched players and is in the process of placing a new game session for the match.
     * + **COMPLETED** -- Players have been matched and a game session is ready to host the players. A ticket in this state contains the necessary connection information for players.
     * + **FAILED** -- The matchmaking request was not completed.
     * + **CANCELLED** -- The matchmaking request was canceled. This may be the result of a call to StopMatchmaking or a proposed match that one or more players failed to accept.
     * + **TIMED_OUT** -- The matchmaking request was not successful within the duration specified in the matchmaking configuration.
     *
     * Matchmaking requests that fail to successfully complete (statuses FAILED, CANCELLED, TIMED_OUT) can be resubmitted as new requests with new ticket IDs.
     */
    public val status: aws.sdk.kotlin.services.gamelift.model.MatchmakingConfigurationStatus? = builder.status
    /**
     * Additional information about the current status.
     */
    public val statusMessage: kotlin.String? = builder.statusMessage
    /**
     * Code to explain the current status. For example, a status reason may indicate when a ticket has returned to `SEARCHING` status after a proposed match fails to receive player acceptances.
     */
    public val statusReason: kotlin.String? = builder.statusReason
    /**
     * A unique identifier for a matchmaking ticket.
     */
    public val ticketId: kotlin.String? = builder.ticketId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.gamelift.model.MatchmakingTicket = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("MatchmakingTicket(")
        append("configurationArn=$configurationArn,")
        append("configurationName=$configurationName,")
        append("endTime=$endTime,")
        append("estimatedWaitTime=$estimatedWaitTime,")
        append("gameSessionConnectionInfo=$gameSessionConnectionInfo,")
        append("players=$players,")
        append("startTime=$startTime,")
        append("status=$status,")
        append("statusMessage=$statusMessage,")
        append("statusReason=$statusReason,")
        append("ticketId=$ticketId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = configurationArn?.hashCode() ?: 0
        result = 31 * result + (configurationName?.hashCode() ?: 0)
        result = 31 * result + (endTime?.hashCode() ?: 0)
        result = 31 * result + (estimatedWaitTime ?: 0)
        result = 31 * result + (gameSessionConnectionInfo?.hashCode() ?: 0)
        result = 31 * result + (players?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (statusMessage?.hashCode() ?: 0)
        result = 31 * result + (statusReason?.hashCode() ?: 0)
        result = 31 * result + (ticketId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as MatchmakingTicket

        if (configurationArn != other.configurationArn) return false
        if (configurationName != other.configurationName) return false
        if (endTime != other.endTime) return false
        if (estimatedWaitTime != other.estimatedWaitTime) return false
        if (gameSessionConnectionInfo != other.gameSessionConnectionInfo) return false
        if (players != other.players) return false
        if (startTime != other.startTime) return false
        if (status != other.status) return false
        if (statusMessage != other.statusMessage) return false
        if (statusReason != other.statusReason) return false
        if (ticketId != other.ticketId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.gamelift.model.MatchmakingTicket = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name ([ARN](https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html)) associated with the GameLift matchmaking configuration resource that is used with this ticket.
         */
        public var configurationArn: kotlin.String? = null
        /**
         * Name of the MatchmakingConfiguration that is used with this ticket. Matchmaking configurations determine how players are grouped into a match and how a new game session is created for the match.
         */
        public var configurationName: kotlin.String? = null
        /**
         * Time stamp indicating when this matchmaking request stopped being processed due to success, failure, or cancellation. Format is a number expressed in Unix time as milliseconds (for example `"1469498468.057"`).
         */
        public var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Average amount of time (in seconds) that players are currently waiting for a match. If there is not enough recent data, this property may be empty.
         */
        public var estimatedWaitTime: kotlin.Int? = null
        /**
         * Identifier and connection information of the game session created for the match. This information is added to the ticket only after the matchmaking request has been successfully completed. This parameter is not set when FlexMatch is being used without GameLift hosting.
         */
        public var gameSessionConnectionInfo: aws.sdk.kotlin.services.gamelift.model.GameSessionConnectionInfo? = null
        /**
         * A set of `Player` objects, each representing a player to find matches for. Players are identified by a unique player ID and may include latency data for use during matchmaking. If the ticket is in status `COMPLETED`, the `Player` objects include the team the players were assigned to in the resulting match.
         */
        public var players: List<Player>? = null
        /**
         * Time stamp indicating when this matchmaking request was received. Format is a number expressed in Unix time as milliseconds (for example `"1469498468.057"`).
         */
        public var startTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Current status of the matchmaking request.
         * + **QUEUED** -- The matchmaking request has been received and is currently waiting to be processed.
         * + **SEARCHING** -- The matchmaking request is currently being processed.
         * + **REQUIRES_ACCEPTANCE** -- A match has been proposed and the players must accept the match (see AcceptMatch). This status is used only with requests that use a matchmaking configuration with a player acceptance requirement.
         * + **PLACING** -- The FlexMatch engine has matched players and is in the process of placing a new game session for the match.
         * + **COMPLETED** -- Players have been matched and a game session is ready to host the players. A ticket in this state contains the necessary connection information for players.
         * + **FAILED** -- The matchmaking request was not completed.
         * + **CANCELLED** -- The matchmaking request was canceled. This may be the result of a call to StopMatchmaking or a proposed match that one or more players failed to accept.
         * + **TIMED_OUT** -- The matchmaking request was not successful within the duration specified in the matchmaking configuration.
         *
         * Matchmaking requests that fail to successfully complete (statuses FAILED, CANCELLED, TIMED_OUT) can be resubmitted as new requests with new ticket IDs.
         */
        public var status: aws.sdk.kotlin.services.gamelift.model.MatchmakingConfigurationStatus? = null
        /**
         * Additional information about the current status.
         */
        public var statusMessage: kotlin.String? = null
        /**
         * Code to explain the current status. For example, a status reason may indicate when a ticket has returned to `SEARCHING` status after a proposed match fails to receive player acceptances.
         */
        public var statusReason: kotlin.String? = null
        /**
         * A unique identifier for a matchmaking ticket.
         */
        public var ticketId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.gamelift.model.MatchmakingTicket) : this() {
            this.configurationArn = x.configurationArn
            this.configurationName = x.configurationName
            this.endTime = x.endTime
            this.estimatedWaitTime = x.estimatedWaitTime
            this.gameSessionConnectionInfo = x.gameSessionConnectionInfo
            this.players = x.players
            this.startTime = x.startTime
            this.status = x.status
            this.statusMessage = x.statusMessage
            this.statusReason = x.statusReason
            this.ticketId = x.ticketId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.gamelift.model.MatchmakingTicket = MatchmakingTicket(this)

        /**
         * construct an [aws.sdk.kotlin.services.gamelift.model.GameSessionConnectionInfo] inside the given [block]
         */
        public fun gameSessionConnectionInfo(block: aws.sdk.kotlin.services.gamelift.model.GameSessionConnectionInfo.Builder.() -> kotlin.Unit) {
            this.gameSessionConnectionInfo = aws.sdk.kotlin.services.gamelift.model.GameSessionConnectionInfo.invoke(block)
        }
    }
}
