// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.gamelift.model



/**
 * Represents a player in matchmaking. When starting a matchmaking request, a player has a player ID, attributes, and may have latency data. Team information is added after a match has been successfully completed.
 */
public class Player private constructor(builder: Builder) {
    /**
     * A set of values, expressed in milliseconds, that indicates the amount of latency that a player experiences when connected to @aws; Regions. If this property is present, FlexMatch considers placing the match only in Regions for which latency is reported.
     *
     * If a matchmaker has a rule that evaluates player latency, players must report latency in order to be matched. If no latency is reported in this scenario, FlexMatch assumes that no Regions are available to the player and the ticket is not matchable.
     */
    public val latencyInMs: Map<String, Int>? = builder.latencyInMs
    /**
     * A collection of key:value pairs containing player information for use in matchmaking. Player attribute keys must match the *playerAttributes* used in a matchmaking rule set. Example: `"PlayerAttributes": {"skill": {"N": "23"}, "gameMode": {"S": "deathmatch"}}`.
     */
    public val playerAttributes: Map<String, AttributeValue>? = builder.playerAttributes
    /**
     * A unique identifier for a player
     */
    public val playerId: kotlin.String? = builder.playerId
    /**
     * Name of the team that the player is assigned to in a match. Team names are defined in a matchmaking rule set.
     */
    public val team: kotlin.String? = builder.team

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.gamelift.model.Player = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Player(")
        append("latencyInMs=$latencyInMs,")
        append("playerAttributes=$playerAttributes,")
        append("playerId=$playerId,")
        append("team=$team)")
    }

    override fun hashCode(): kotlin.Int {
        var result = latencyInMs?.hashCode() ?: 0
        result = 31 * result + (playerAttributes?.hashCode() ?: 0)
        result = 31 * result + (playerId?.hashCode() ?: 0)
        result = 31 * result + (team?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Player

        if (latencyInMs != other.latencyInMs) return false
        if (playerAttributes != other.playerAttributes) return false
        if (playerId != other.playerId) return false
        if (team != other.team) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.gamelift.model.Player = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A set of values, expressed in milliseconds, that indicates the amount of latency that a player experiences when connected to @aws; Regions. If this property is present, FlexMatch considers placing the match only in Regions for which latency is reported.
         *
         * If a matchmaker has a rule that evaluates player latency, players must report latency in order to be matched. If no latency is reported in this scenario, FlexMatch assumes that no Regions are available to the player and the ticket is not matchable.
         */
        public var latencyInMs: Map<String, Int>? = null
        /**
         * A collection of key:value pairs containing player information for use in matchmaking. Player attribute keys must match the *playerAttributes* used in a matchmaking rule set. Example: `"PlayerAttributes": {"skill": {"N": "23"}, "gameMode": {"S": "deathmatch"}}`.
         */
        public var playerAttributes: Map<String, AttributeValue>? = null
        /**
         * A unique identifier for a player
         */
        public var playerId: kotlin.String? = null
        /**
         * Name of the team that the player is assigned to in a match. Team names are defined in a matchmaking rule set.
         */
        public var team: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.gamelift.model.Player) : this() {
            this.latencyInMs = x.latencyInMs
            this.playerAttributes = x.playerAttributes
            this.playerId = x.playerId
            this.team = x.team
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.gamelift.model.Player = Player(this)
    }
}
