// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.gamelift.model



/**
 * Represents the input for a request operation.
 */
public class PutScalingPolicyRequest private constructor(builder: Builder) {
    /**
     * Comparison operator to use when measuring the metric against the threshold value.
     */
    public val comparisonOperator: aws.sdk.kotlin.services.gamelift.model.ComparisonOperatorType? = builder.comparisonOperator
    /**
     * Length of time (in minutes) the metric must be at or beyond the threshold before a scaling event is triggered.
     */
    public val evaluationPeriods: kotlin.Int? = builder.evaluationPeriods
    /**
     * A unique identifier for the fleet to apply this policy to. You can use either the fleet ID or ARN value. The fleet cannot be in any of the following statuses: ERROR or DELETING.
     */
    public val fleetId: kotlin.String? = builder.fleetId
    /**
     * Name of the Amazon GameLift-defined metric that is used to trigger a scaling adjustment. For detailed descriptions of fleet metrics, see [Monitor Amazon GameLift with Amazon CloudWatch](https://docs.aws.amazon.com/gamelift/latest/developerguide/monitoring-cloudwatch.html).
     * + **ActivatingGameSessions** -- Game sessions in the process of being created.
     * + **ActiveGameSessions** -- Game sessions that are currently running.
     * + **ActiveInstances** -- Fleet instances that are currently running at least one game session.
     * + **AvailableGameSessions** -- Additional game sessions that fleet could host simultaneously, given current capacity.
     * + **AvailablePlayerSessions** -- Empty player slots in currently active game sessions. This includes game sessions that are not currently accepting players. Reserved player slots are not included.
     * + **CurrentPlayerSessions** -- Player slots in active game sessions that are being used by a player or are reserved for a player.
     * + **IdleInstances** -- Active instances that are currently hosting zero game sessions.
     * + **PercentAvailableGameSessions** -- Unused percentage of the total number of game sessions that a fleet could host simultaneously, given current capacity. Use this metric for a target-based scaling policy.
     * + **PercentIdleInstances** -- Percentage of the total number of active instances that are hosting zero game sessions.
     * + **QueueDepth** -- Pending game session placement requests, in any queue, where the current fleet is the top-priority destination.
     * + **WaitTime** -- Current wait time for pending game session placement requests, in any queue, where the current fleet is the top-priority destination.
     */
    public val metricName: aws.sdk.kotlin.services.gamelift.model.MetricName? = builder.metricName
    /**
     * A descriptive label that is associated with a fleet's scaling policy. Policy names do not need to be unique. A fleet can have only one scaling policy with the same name.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The type of scaling policy to create. For a target-based policy, set the parameter *MetricName* to 'PercentAvailableGameSessions' and specify a *TargetConfiguration*. For a rule-based policy set the following parameters: *MetricName*, *ComparisonOperator*, *Threshold*, *EvaluationPeriods*, *ScalingAdjustmentType*, and *ScalingAdjustment*.
     */
    public val policyType: aws.sdk.kotlin.services.gamelift.model.PolicyType? = builder.policyType
    /**
     * Amount of adjustment to make, based on the scaling adjustment type.
     */
    public val scalingAdjustment: kotlin.Int = builder.scalingAdjustment
    /**
     * The type of adjustment to make to a fleet's instance count (see FleetCapacity):
     * + **ChangeInCapacity** -- add (or subtract) the scaling adjustment value from the current instance count. Positive values scale up while negative values scale down.
     * + **ExactCapacity** -- set the instance count to the scaling adjustment value.
     * + **PercentChangeInCapacity** -- increase or reduce the current instance count by the scaling adjustment, read as a percentage. Positive values scale up while negative values scale down; for example, a value of "-10" scales the fleet down by 10%.
     */
    public val scalingAdjustmentType: aws.sdk.kotlin.services.gamelift.model.ScalingAdjustmentType? = builder.scalingAdjustmentType
    /**
     * An object that contains settings for a target-based scaling policy.
     */
    public val targetConfiguration: aws.sdk.kotlin.services.gamelift.model.TargetConfiguration? = builder.targetConfiguration
    /**
     * Metric value used to trigger a scaling event.
     */
    public val threshold: kotlin.Double = builder.threshold

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.gamelift.model.PutScalingPolicyRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PutScalingPolicyRequest(")
        append("comparisonOperator=$comparisonOperator,")
        append("evaluationPeriods=$evaluationPeriods,")
        append("fleetId=$fleetId,")
        append("metricName=$metricName,")
        append("name=$name,")
        append("policyType=$policyType,")
        append("scalingAdjustment=$scalingAdjustment,")
        append("scalingAdjustmentType=$scalingAdjustmentType,")
        append("targetConfiguration=$targetConfiguration,")
        append("threshold=$threshold)")
    }

    override fun hashCode(): kotlin.Int {
        var result = comparisonOperator?.hashCode() ?: 0
        result = 31 * result + (evaluationPeriods ?: 0)
        result = 31 * result + (fleetId?.hashCode() ?: 0)
        result = 31 * result + (metricName?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (policyType?.hashCode() ?: 0)
        result = 31 * result + (scalingAdjustment)
        result = 31 * result + (scalingAdjustmentType?.hashCode() ?: 0)
        result = 31 * result + (targetConfiguration?.hashCode() ?: 0)
        result = 31 * result + (threshold.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PutScalingPolicyRequest

        if (comparisonOperator != other.comparisonOperator) return false
        if (evaluationPeriods != other.evaluationPeriods) return false
        if (fleetId != other.fleetId) return false
        if (metricName != other.metricName) return false
        if (name != other.name) return false
        if (policyType != other.policyType) return false
        if (scalingAdjustment != other.scalingAdjustment) return false
        if (scalingAdjustmentType != other.scalingAdjustmentType) return false
        if (targetConfiguration != other.targetConfiguration) return false
        if (threshold != other.threshold) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.gamelift.model.PutScalingPolicyRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Comparison operator to use when measuring the metric against the threshold value.
         */
        public var comparisonOperator: aws.sdk.kotlin.services.gamelift.model.ComparisonOperatorType? = null
        /**
         * Length of time (in minutes) the metric must be at or beyond the threshold before a scaling event is triggered.
         */
        public var evaluationPeriods: kotlin.Int? = null
        /**
         * A unique identifier for the fleet to apply this policy to. You can use either the fleet ID or ARN value. The fleet cannot be in any of the following statuses: ERROR or DELETING.
         */
        public var fleetId: kotlin.String? = null
        /**
         * Name of the Amazon GameLift-defined metric that is used to trigger a scaling adjustment. For detailed descriptions of fleet metrics, see [Monitor Amazon GameLift with Amazon CloudWatch](https://docs.aws.amazon.com/gamelift/latest/developerguide/monitoring-cloudwatch.html).
         * + **ActivatingGameSessions** -- Game sessions in the process of being created.
         * + **ActiveGameSessions** -- Game sessions that are currently running.
         * + **ActiveInstances** -- Fleet instances that are currently running at least one game session.
         * + **AvailableGameSessions** -- Additional game sessions that fleet could host simultaneously, given current capacity.
         * + **AvailablePlayerSessions** -- Empty player slots in currently active game sessions. This includes game sessions that are not currently accepting players. Reserved player slots are not included.
         * + **CurrentPlayerSessions** -- Player slots in active game sessions that are being used by a player or are reserved for a player.
         * + **IdleInstances** -- Active instances that are currently hosting zero game sessions.
         * + **PercentAvailableGameSessions** -- Unused percentage of the total number of game sessions that a fleet could host simultaneously, given current capacity. Use this metric for a target-based scaling policy.
         * + **PercentIdleInstances** -- Percentage of the total number of active instances that are hosting zero game sessions.
         * + **QueueDepth** -- Pending game session placement requests, in any queue, where the current fleet is the top-priority destination.
         * + **WaitTime** -- Current wait time for pending game session placement requests, in any queue, where the current fleet is the top-priority destination.
         */
        public var metricName: aws.sdk.kotlin.services.gamelift.model.MetricName? = null
        /**
         * A descriptive label that is associated with a fleet's scaling policy. Policy names do not need to be unique. A fleet can have only one scaling policy with the same name.
         */
        public var name: kotlin.String? = null
        /**
         * The type of scaling policy to create. For a target-based policy, set the parameter *MetricName* to 'PercentAvailableGameSessions' and specify a *TargetConfiguration*. For a rule-based policy set the following parameters: *MetricName*, *ComparisonOperator*, *Threshold*, *EvaluationPeriods*, *ScalingAdjustmentType*, and *ScalingAdjustment*.
         */
        public var policyType: aws.sdk.kotlin.services.gamelift.model.PolicyType? = null
        /**
         * Amount of adjustment to make, based on the scaling adjustment type.
         */
        public var scalingAdjustment: kotlin.Int = 0
        /**
         * The type of adjustment to make to a fleet's instance count (see FleetCapacity):
         * + **ChangeInCapacity** -- add (or subtract) the scaling adjustment value from the current instance count. Positive values scale up while negative values scale down.
         * + **ExactCapacity** -- set the instance count to the scaling adjustment value.
         * + **PercentChangeInCapacity** -- increase or reduce the current instance count by the scaling adjustment, read as a percentage. Positive values scale up while negative values scale down; for example, a value of "-10" scales the fleet down by 10%.
         */
        public var scalingAdjustmentType: aws.sdk.kotlin.services.gamelift.model.ScalingAdjustmentType? = null
        /**
         * An object that contains settings for a target-based scaling policy.
         */
        public var targetConfiguration: aws.sdk.kotlin.services.gamelift.model.TargetConfiguration? = null
        /**
         * Metric value used to trigger a scaling event.
         */
        public var threshold: kotlin.Double = 0.0

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.gamelift.model.PutScalingPolicyRequest) : this() {
            this.comparisonOperator = x.comparisonOperator
            this.evaluationPeriods = x.evaluationPeriods
            this.fleetId = x.fleetId
            this.metricName = x.metricName
            this.name = x.name
            this.policyType = x.policyType
            this.scalingAdjustment = x.scalingAdjustment
            this.scalingAdjustmentType = x.scalingAdjustmentType
            this.targetConfiguration = x.targetConfiguration
            this.threshold = x.threshold
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.gamelift.model.PutScalingPolicyRequest = PutScalingPolicyRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.gamelift.model.TargetConfiguration] inside the given [block]
         */
        public fun targetConfiguration(block: aws.sdk.kotlin.services.gamelift.model.TargetConfiguration.Builder.() -> kotlin.Unit) {
            this.targetConfiguration = aws.sdk.kotlin.services.gamelift.model.TargetConfiguration.invoke(block)
        }
    }
}
