// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.gamelift.model



public class RegisterGameServerRequest private constructor(builder: Builder) {
    /**
     * Information that is needed to make inbound client connections to the game server. This might include the IP address and port, DNS name, and other information.
     */
    public val connectionInfo: kotlin.String? = builder.connectionInfo
    /**
     * A set of custom game server properties, formatted as a single string value. This data is passed to a game client or service when it requests information on game servers using ListGameServers or ClaimGameServer.
     */
    public val gameServerData: kotlin.String? = builder.gameServerData
    /**
     * A unique identifier for the game server group where the game server is running. Use either the GameServerGroup name or ARN value.
     */
    public val gameServerGroupName: kotlin.String? = builder.gameServerGroupName
    /**
     * A custom string that uniquely identifies the game server to register. Game server IDs are developer-defined and must be unique across all game server groups in your Amazon Web Services account.
     */
    public val gameServerId: kotlin.String? = builder.gameServerId
    /**
     * The unique identifier for the instance where the game server is running. This ID is available in the instance metadata. EC2 instance IDs use a 17-character format, for example: `i-1234567890abcdef0`.
     */
    public val instanceId: kotlin.String? = builder.instanceId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.gamelift.model.RegisterGameServerRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RegisterGameServerRequest(")
        append("connectionInfo=$connectionInfo,")
        append("gameServerData=$gameServerData,")
        append("gameServerGroupName=$gameServerGroupName,")
        append("gameServerId=$gameServerId,")
        append("instanceId=$instanceId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = connectionInfo?.hashCode() ?: 0
        result = 31 * result + (gameServerData?.hashCode() ?: 0)
        result = 31 * result + (gameServerGroupName?.hashCode() ?: 0)
        result = 31 * result + (gameServerId?.hashCode() ?: 0)
        result = 31 * result + (instanceId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RegisterGameServerRequest

        if (connectionInfo != other.connectionInfo) return false
        if (gameServerData != other.gameServerData) return false
        if (gameServerGroupName != other.gameServerGroupName) return false
        if (gameServerId != other.gameServerId) return false
        if (instanceId != other.instanceId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.gamelift.model.RegisterGameServerRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Information that is needed to make inbound client connections to the game server. This might include the IP address and port, DNS name, and other information.
         */
        public var connectionInfo: kotlin.String? = null
        /**
         * A set of custom game server properties, formatted as a single string value. This data is passed to a game client or service when it requests information on game servers using ListGameServers or ClaimGameServer.
         */
        public var gameServerData: kotlin.String? = null
        /**
         * A unique identifier for the game server group where the game server is running. Use either the GameServerGroup name or ARN value.
         */
        public var gameServerGroupName: kotlin.String? = null
        /**
         * A custom string that uniquely identifies the game server to register. Game server IDs are developer-defined and must be unique across all game server groups in your Amazon Web Services account.
         */
        public var gameServerId: kotlin.String? = null
        /**
         * The unique identifier for the instance where the game server is running. This ID is available in the instance metadata. EC2 instance IDs use a 17-character format, for example: `i-1234567890abcdef0`.
         */
        public var instanceId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.gamelift.model.RegisterGameServerRequest) : this() {
            this.connectionInfo = x.connectionInfo
            this.gameServerData = x.gameServerData
            this.gameServerGroupName = x.gameServerGroupName
            this.gameServerId = x.gameServerId
            this.instanceId = x.instanceId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.gamelift.model.RegisterGameServerRequest = RegisterGameServerRequest(this)
    }
}
