// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.gamelift.model



/**
 * A set of instructions for launching server processes on each instance in a fleet. Server processes run either an executable in a custom game build or a Realtime Servers script. Server process configurations are part of a fleet's RuntimeConfiguration.
 */
public class ServerProcess private constructor(builder: Builder) {
    /**
     * The number of server processes using this configuration that run concurrently on each instance.
     */
    public val concurrentExecutions: kotlin.Int? = builder.concurrentExecutions
    /**
     * The location of a game build executable or the Realtime script file that contains the `Init()` function. Game builds and Realtime scripts are installed on instances at the root:
     * + Windows (custom game builds only): `C:\game`. Example: "`C:\game\MyGame\server.exe`"
     * + Linux: `/local/game`. Examples: "`/local/game/MyGame/server.exe`" or "`/local/game/MyRealtimeScript.js`"
     */
    public val launchPath: kotlin.String? = builder.launchPath
    /**
     * An optional list of parameters to pass to the server executable or Realtime script on launch.
     */
    public val parameters: kotlin.String? = builder.parameters

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.gamelift.model.ServerProcess = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ServerProcess(")
        append("concurrentExecutions=$concurrentExecutions,")
        append("launchPath=$launchPath,")
        append("parameters=$parameters)")
    }

    override fun hashCode(): kotlin.Int {
        var result = concurrentExecutions ?: 0
        result = 31 * result + (launchPath?.hashCode() ?: 0)
        result = 31 * result + (parameters?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ServerProcess

        if (concurrentExecutions != other.concurrentExecutions) return false
        if (launchPath != other.launchPath) return false
        if (parameters != other.parameters) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.gamelift.model.ServerProcess = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The number of server processes using this configuration that run concurrently on each instance.
         */
        public var concurrentExecutions: kotlin.Int? = null
        /**
         * The location of a game build executable or the Realtime script file that contains the `Init()` function. Game builds and Realtime scripts are installed on instances at the root:
         * + Windows (custom game builds only): `C:\game`. Example: "`C:\game\MyGame\server.exe`"
         * + Linux: `/local/game`. Examples: "`/local/game/MyGame/server.exe`" or "`/local/game/MyRealtimeScript.js`"
         */
        public var launchPath: kotlin.String? = null
        /**
         * An optional list of parameters to pass to the server executable or Realtime script on launch.
         */
        public var parameters: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.gamelift.model.ServerProcess) : this() {
            this.concurrentExecutions = x.concurrentExecutions
            this.launchPath = x.launchPath
            this.parameters = x.parameters
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.gamelift.model.ServerProcess = ServerProcess(this)
    }
}
