// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.gamelift.model



/**
 * **This data type is used with the GameLift FleetIQ and game server groups.**
 *
 * Settings for a target-based scaling policy as part of a GameServerGroupAutoScalingPolicy. These settings are used to create a target-based policy that tracks the GameLift FleetIQ metric `"PercentUtilizedGameServers"` and specifies a target value for the metric. As player usage changes, the policy triggers to adjust the game server group capacity so that the metric returns to the target value.
 */
public class TargetTrackingConfiguration private constructor(builder: Builder) {
    /**
     * Desired value to use with a game server group target-based scaling policy.
     */
    public val targetValue: kotlin.Double? = builder.targetValue

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.gamelift.model.TargetTrackingConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TargetTrackingConfiguration(")
        append("targetValue=$targetValue)")
    }

    override fun hashCode(): kotlin.Int {
        var result = targetValue?.hashCode() ?: 0
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TargetTrackingConfiguration

        if (targetValue != other.targetValue) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.gamelift.model.TargetTrackingConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Desired value to use with a game server group target-based scaling policy.
         */
        public var targetValue: kotlin.Double? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.gamelift.model.TargetTrackingConfiguration) : this() {
            this.targetValue = x.targetValue
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.gamelift.model.TargetTrackingConfiguration = TargetTrackingConfiguration(this)
    }
}
