// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.gamelift.model



/**
 * Represents the input for a request operation.
 */
public class UpdateFleetAttributesRequest private constructor(builder: Builder) {
    /**
     * A human-readable description of a fleet.
     */
    public val description: kotlin.String? = builder.description
    /**
     * A unique identifier for the fleet to update attribute metadata for. You can use either the fleet ID or ARN value.
     */
    public val fleetId: kotlin.String? = builder.fleetId
    /**
     * The name of a metric group to add this fleet to. Use a metric group in Amazon CloudWatch to aggregate the metrics from multiple fleets. Provide an existing metric group name, or create a new metric group by providing a new name. A fleet can only be in one metric group at a time.
     */
    public val metricGroups: List<String>? = builder.metricGroups
    /**
     * A descriptive label that is associated with a fleet. Fleet names do not need to be unique.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The game session protection policy to apply to all new instances created in this fleet. Instances that already exist are not affected. You can set protection for individual instances using UpdateGameSession.
     * + **NoProtection** -- The game session can be terminated during a scale-down event.
     * + **FullProtection** -- If the game session is in an `ACTIVE` status, it cannot be terminated during a scale-down event.
     */
    public val newGameSessionProtectionPolicy: aws.sdk.kotlin.services.gamelift.model.ProtectionPolicy? = builder.newGameSessionProtectionPolicy
    /**
     * Policy settings that limit the number of game sessions an individual player can create over a span of time.
     */
    public val resourceCreationLimitPolicy: aws.sdk.kotlin.services.gamelift.model.ResourceCreationLimitPolicy? = builder.resourceCreationLimitPolicy

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.gamelift.model.UpdateFleetAttributesRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateFleetAttributesRequest(")
        append("description=$description,")
        append("fleetId=$fleetId,")
        append("metricGroups=$metricGroups,")
        append("name=$name,")
        append("newGameSessionProtectionPolicy=$newGameSessionProtectionPolicy,")
        append("resourceCreationLimitPolicy=$resourceCreationLimitPolicy)")
    }

    override fun hashCode(): kotlin.Int {
        var result = description?.hashCode() ?: 0
        result = 31 * result + (fleetId?.hashCode() ?: 0)
        result = 31 * result + (metricGroups?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (newGameSessionProtectionPolicy?.hashCode() ?: 0)
        result = 31 * result + (resourceCreationLimitPolicy?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateFleetAttributesRequest

        if (description != other.description) return false
        if (fleetId != other.fleetId) return false
        if (metricGroups != other.metricGroups) return false
        if (name != other.name) return false
        if (newGameSessionProtectionPolicy != other.newGameSessionProtectionPolicy) return false
        if (resourceCreationLimitPolicy != other.resourceCreationLimitPolicy) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.gamelift.model.UpdateFleetAttributesRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A human-readable description of a fleet.
         */
        public var description: kotlin.String? = null
        /**
         * A unique identifier for the fleet to update attribute metadata for. You can use either the fleet ID or ARN value.
         */
        public var fleetId: kotlin.String? = null
        /**
         * The name of a metric group to add this fleet to. Use a metric group in Amazon CloudWatch to aggregate the metrics from multiple fleets. Provide an existing metric group name, or create a new metric group by providing a new name. A fleet can only be in one metric group at a time.
         */
        public var metricGroups: List<String>? = null
        /**
         * A descriptive label that is associated with a fleet. Fleet names do not need to be unique.
         */
        public var name: kotlin.String? = null
        /**
         * The game session protection policy to apply to all new instances created in this fleet. Instances that already exist are not affected. You can set protection for individual instances using UpdateGameSession.
         * + **NoProtection** -- The game session can be terminated during a scale-down event.
         * + **FullProtection** -- If the game session is in an `ACTIVE` status, it cannot be terminated during a scale-down event.
         */
        public var newGameSessionProtectionPolicy: aws.sdk.kotlin.services.gamelift.model.ProtectionPolicy? = null
        /**
         * Policy settings that limit the number of game sessions an individual player can create over a span of time.
         */
        public var resourceCreationLimitPolicy: aws.sdk.kotlin.services.gamelift.model.ResourceCreationLimitPolicy? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.gamelift.model.UpdateFleetAttributesRequest) : this() {
            this.description = x.description
            this.fleetId = x.fleetId
            this.metricGroups = x.metricGroups
            this.name = x.name
            this.newGameSessionProtectionPolicy = x.newGameSessionProtectionPolicy
            this.resourceCreationLimitPolicy = x.resourceCreationLimitPolicy
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.gamelift.model.UpdateFleetAttributesRequest = UpdateFleetAttributesRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.gamelift.model.ResourceCreationLimitPolicy] inside the given [block]
         */
        public fun resourceCreationLimitPolicy(block: aws.sdk.kotlin.services.gamelift.model.ResourceCreationLimitPolicy.Builder.() -> kotlin.Unit) {
            this.resourceCreationLimitPolicy = aws.sdk.kotlin.services.gamelift.model.ResourceCreationLimitPolicy.invoke(block)
        }
    }
}
