// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.gamelift.model



public class UpdateGameServerRequest private constructor(builder: Builder) {
    /**
     * A set of custom game server properties, formatted as a single string value. This data is passed to a game client or service when it requests information on game servers using ListGameServers or ClaimGameServer.
     */
    public val gameServerData: kotlin.String? = builder.gameServerData
    /**
     * A unique identifier for the game server group where the game server is running. Use either the GameServerGroup name or ARN value.
     */
    public val gameServerGroupName: kotlin.String? = builder.gameServerGroupName
    /**
     * A custom string that uniquely identifies the game server to update.
     */
    public val gameServerId: kotlin.String? = builder.gameServerId
    /**
     * Indicates health status of the game server. A request that includes this parameter updates the game server's *LastHealthCheckTime* timestamp.
     */
    public val healthCheck: aws.sdk.kotlin.services.gamelift.model.GameServerHealthCheck? = builder.healthCheck
    /**
     * Indicates whether the game server is available or is currently hosting gameplay.
     */
    public val utilizationStatus: aws.sdk.kotlin.services.gamelift.model.GameServerUtilizationStatus? = builder.utilizationStatus

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.gamelift.model.UpdateGameServerRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateGameServerRequest(")
        append("gameServerData=$gameServerData,")
        append("gameServerGroupName=$gameServerGroupName,")
        append("gameServerId=$gameServerId,")
        append("healthCheck=$healthCheck,")
        append("utilizationStatus=$utilizationStatus)")
    }

    override fun hashCode(): kotlin.Int {
        var result = gameServerData?.hashCode() ?: 0
        result = 31 * result + (gameServerGroupName?.hashCode() ?: 0)
        result = 31 * result + (gameServerId?.hashCode() ?: 0)
        result = 31 * result + (healthCheck?.hashCode() ?: 0)
        result = 31 * result + (utilizationStatus?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateGameServerRequest

        if (gameServerData != other.gameServerData) return false
        if (gameServerGroupName != other.gameServerGroupName) return false
        if (gameServerId != other.gameServerId) return false
        if (healthCheck != other.healthCheck) return false
        if (utilizationStatus != other.utilizationStatus) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.gamelift.model.UpdateGameServerRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A set of custom game server properties, formatted as a single string value. This data is passed to a game client or service when it requests information on game servers using ListGameServers or ClaimGameServer.
         */
        public var gameServerData: kotlin.String? = null
        /**
         * A unique identifier for the game server group where the game server is running. Use either the GameServerGroup name or ARN value.
         */
        public var gameServerGroupName: kotlin.String? = null
        /**
         * A custom string that uniquely identifies the game server to update.
         */
        public var gameServerId: kotlin.String? = null
        /**
         * Indicates health status of the game server. A request that includes this parameter updates the game server's *LastHealthCheckTime* timestamp.
         */
        public var healthCheck: aws.sdk.kotlin.services.gamelift.model.GameServerHealthCheck? = null
        /**
         * Indicates whether the game server is available or is currently hosting gameplay.
         */
        public var utilizationStatus: aws.sdk.kotlin.services.gamelift.model.GameServerUtilizationStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.gamelift.model.UpdateGameServerRequest) : this() {
            this.gameServerData = x.gameServerData
            this.gameServerGroupName = x.gameServerGroupName
            this.gameServerId = x.gameServerId
            this.healthCheck = x.healthCheck
            this.utilizationStatus = x.utilizationStatus
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.gamelift.model.UpdateGameServerRequest = UpdateGameServerRequest(this)
    }
}
