// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.gamelift.model



/**
 * Represents the input for a request operation.
 */
public class UpdateGameSessionRequest private constructor(builder: Builder) {
    /**
     * A unique identifier for the game session to update.
     */
    public val gameSessionId: kotlin.String? = builder.gameSessionId
    /**
     * The maximum number of players that can be connected simultaneously to the game session.
     */
    public val maximumPlayerSessionCount: kotlin.Int? = builder.maximumPlayerSessionCount
    /**
     * A descriptive label that is associated with a game session. Session names do not need to be unique.
     */
    public val name: kotlin.String? = builder.name
    /**
     * A policy that determines whether the game session is accepting new players.
     */
    public val playerSessionCreationPolicy: aws.sdk.kotlin.services.gamelift.model.PlayerSessionCreationPolicy? = builder.playerSessionCreationPolicy
    /**
     * Game session protection policy to apply to this game session only.
     * + **NoProtection** -- The game session can be terminated during a scale-down event.
     * + **FullProtection** -- If the game session is in an `ACTIVE` status, it cannot be terminated during a scale-down event.
     */
    public val protectionPolicy: aws.sdk.kotlin.services.gamelift.model.ProtectionPolicy? = builder.protectionPolicy

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.gamelift.model.UpdateGameSessionRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateGameSessionRequest(")
        append("gameSessionId=$gameSessionId,")
        append("maximumPlayerSessionCount=$maximumPlayerSessionCount,")
        append("name=$name,")
        append("playerSessionCreationPolicy=$playerSessionCreationPolicy,")
        append("protectionPolicy=$protectionPolicy)")
    }

    override fun hashCode(): kotlin.Int {
        var result = gameSessionId?.hashCode() ?: 0
        result = 31 * result + (maximumPlayerSessionCount ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (playerSessionCreationPolicy?.hashCode() ?: 0)
        result = 31 * result + (protectionPolicy?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateGameSessionRequest

        if (gameSessionId != other.gameSessionId) return false
        if (maximumPlayerSessionCount != other.maximumPlayerSessionCount) return false
        if (name != other.name) return false
        if (playerSessionCreationPolicy != other.playerSessionCreationPolicy) return false
        if (protectionPolicy != other.protectionPolicy) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.gamelift.model.UpdateGameSessionRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A unique identifier for the game session to update.
         */
        public var gameSessionId: kotlin.String? = null
        /**
         * The maximum number of players that can be connected simultaneously to the game session.
         */
        public var maximumPlayerSessionCount: kotlin.Int? = null
        /**
         * A descriptive label that is associated with a game session. Session names do not need to be unique.
         */
        public var name: kotlin.String? = null
        /**
         * A policy that determines whether the game session is accepting new players.
         */
        public var playerSessionCreationPolicy: aws.sdk.kotlin.services.gamelift.model.PlayerSessionCreationPolicy? = null
        /**
         * Game session protection policy to apply to this game session only.
         * + **NoProtection** -- The game session can be terminated during a scale-down event.
         * + **FullProtection** -- If the game session is in an `ACTIVE` status, it cannot be terminated during a scale-down event.
         */
        public var protectionPolicy: aws.sdk.kotlin.services.gamelift.model.ProtectionPolicy? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.gamelift.model.UpdateGameSessionRequest) : this() {
            this.gameSessionId = x.gameSessionId
            this.maximumPlayerSessionCount = x.maximumPlayerSessionCount
            this.name = x.name
            this.playerSessionCreationPolicy = x.playerSessionCreationPolicy
            this.protectionPolicy = x.protectionPolicy
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.gamelift.model.UpdateGameSessionRequest = UpdateGameSessionRequest(this)
    }
}
