// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.gamelift.paginators

import aws.sdk.kotlin.services.gamelift.GameLiftClient
import aws.sdk.kotlin.services.gamelift.model.Alias
import aws.sdk.kotlin.services.gamelift.model.Build
import aws.sdk.kotlin.services.gamelift.model.DescribeFleetAttributesRequest
import aws.sdk.kotlin.services.gamelift.model.DescribeFleetAttributesResponse
import aws.sdk.kotlin.services.gamelift.model.DescribeFleetCapacityRequest
import aws.sdk.kotlin.services.gamelift.model.DescribeFleetCapacityResponse
import aws.sdk.kotlin.services.gamelift.model.DescribeFleetEventsRequest
import aws.sdk.kotlin.services.gamelift.model.DescribeFleetEventsResponse
import aws.sdk.kotlin.services.gamelift.model.DescribeFleetLocationAttributesRequest
import aws.sdk.kotlin.services.gamelift.model.DescribeFleetLocationAttributesResponse
import aws.sdk.kotlin.services.gamelift.model.DescribeFleetUtilizationRequest
import aws.sdk.kotlin.services.gamelift.model.DescribeFleetUtilizationResponse
import aws.sdk.kotlin.services.gamelift.model.DescribeGameServerInstancesRequest
import aws.sdk.kotlin.services.gamelift.model.DescribeGameServerInstancesResponse
import aws.sdk.kotlin.services.gamelift.model.DescribeGameSessionDetailsRequest
import aws.sdk.kotlin.services.gamelift.model.DescribeGameSessionDetailsResponse
import aws.sdk.kotlin.services.gamelift.model.DescribeGameSessionQueuesRequest
import aws.sdk.kotlin.services.gamelift.model.DescribeGameSessionQueuesResponse
import aws.sdk.kotlin.services.gamelift.model.DescribeGameSessionsRequest
import aws.sdk.kotlin.services.gamelift.model.DescribeGameSessionsResponse
import aws.sdk.kotlin.services.gamelift.model.DescribeInstancesRequest
import aws.sdk.kotlin.services.gamelift.model.DescribeInstancesResponse
import aws.sdk.kotlin.services.gamelift.model.DescribeMatchmakingConfigurationsRequest
import aws.sdk.kotlin.services.gamelift.model.DescribeMatchmakingConfigurationsResponse
import aws.sdk.kotlin.services.gamelift.model.DescribeMatchmakingRuleSetsRequest
import aws.sdk.kotlin.services.gamelift.model.DescribeMatchmakingRuleSetsResponse
import aws.sdk.kotlin.services.gamelift.model.DescribePlayerSessionsRequest
import aws.sdk.kotlin.services.gamelift.model.DescribePlayerSessionsResponse
import aws.sdk.kotlin.services.gamelift.model.DescribeScalingPoliciesRequest
import aws.sdk.kotlin.services.gamelift.model.DescribeScalingPoliciesResponse
import aws.sdk.kotlin.services.gamelift.model.Event
import aws.sdk.kotlin.services.gamelift.model.FleetAttributes
import aws.sdk.kotlin.services.gamelift.model.FleetCapacity
import aws.sdk.kotlin.services.gamelift.model.FleetUtilization
import aws.sdk.kotlin.services.gamelift.model.GameServer
import aws.sdk.kotlin.services.gamelift.model.GameServerGroup
import aws.sdk.kotlin.services.gamelift.model.GameServerInstance
import aws.sdk.kotlin.services.gamelift.model.GameSession
import aws.sdk.kotlin.services.gamelift.model.GameSessionDetail
import aws.sdk.kotlin.services.gamelift.model.GameSessionQueue
import aws.sdk.kotlin.services.gamelift.model.Instance
import aws.sdk.kotlin.services.gamelift.model.ListAliasesRequest
import aws.sdk.kotlin.services.gamelift.model.ListAliasesResponse
import aws.sdk.kotlin.services.gamelift.model.ListBuildsRequest
import aws.sdk.kotlin.services.gamelift.model.ListBuildsResponse
import aws.sdk.kotlin.services.gamelift.model.ListFleetsRequest
import aws.sdk.kotlin.services.gamelift.model.ListFleetsResponse
import aws.sdk.kotlin.services.gamelift.model.ListGameServerGroupsRequest
import aws.sdk.kotlin.services.gamelift.model.ListGameServerGroupsResponse
import aws.sdk.kotlin.services.gamelift.model.ListGameServersRequest
import aws.sdk.kotlin.services.gamelift.model.ListGameServersResponse
import aws.sdk.kotlin.services.gamelift.model.ListScriptsRequest
import aws.sdk.kotlin.services.gamelift.model.ListScriptsResponse
import aws.sdk.kotlin.services.gamelift.model.MatchmakingConfiguration
import aws.sdk.kotlin.services.gamelift.model.MatchmakingRuleSet
import aws.sdk.kotlin.services.gamelift.model.PlayerSession
import aws.sdk.kotlin.services.gamelift.model.ScalingPolicy
import aws.sdk.kotlin.services.gamelift.model.Script
import aws.sdk.kotlin.services.gamelift.model.SearchGameSessionsRequest
import aws.sdk.kotlin.services.gamelift.model.SearchGameSessionsResponse
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [DescribeFleetAttributesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeFleetAttributesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeFleetAttributesResponse]
 */
public fun GameLiftClient.describeFleetAttributesPaginated(initialRequest: DescribeFleetAttributesRequest): Flow<DescribeFleetAttributesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeFleetAttributesPaginated.describeFleetAttributes(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [DescribeFleetAttributesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeFleetAttributesResponse]
 */
public fun GameLiftClient.describeFleetAttributesPaginated(block: DescribeFleetAttributesRequest.Builder.() -> Unit): Flow<DescribeFleetAttributesResponse> =
    describeFleetAttributesPaginated(DescribeFleetAttributesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeFleetAttributesPaginated]
 * to access the nested member [FleetAttributes]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [FleetAttributes]
 */
@JvmName("describeFleetAttributesResponseFleetAttributes")
public fun Flow<DescribeFleetAttributesResponse>.fleetAttributes(): Flow<FleetAttributes> =
    transform() { response ->
        response.fleetAttributes?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeFleetCapacityResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeFleetCapacityRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeFleetCapacityResponse]
 */
public fun GameLiftClient.describeFleetCapacityPaginated(initialRequest: DescribeFleetCapacityRequest): Flow<DescribeFleetCapacityResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeFleetCapacityPaginated.describeFleetCapacity(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [DescribeFleetCapacityResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeFleetCapacityResponse]
 */
public fun GameLiftClient.describeFleetCapacityPaginated(block: DescribeFleetCapacityRequest.Builder.() -> Unit): Flow<DescribeFleetCapacityResponse> =
    describeFleetCapacityPaginated(DescribeFleetCapacityRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeFleetCapacityPaginated]
 * to access the nested member [FleetCapacity]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [FleetCapacity]
 */
@JvmName("describeFleetCapacityResponseFleetCapacity")
public fun Flow<DescribeFleetCapacityResponse>.fleetCapacity(): Flow<FleetCapacity> =
    transform() { response ->
        response.fleetCapacity?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeFleetEventsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeFleetEventsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeFleetEventsResponse]
 */
public fun GameLiftClient.describeFleetEventsPaginated(initialRequest: DescribeFleetEventsRequest): Flow<DescribeFleetEventsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeFleetEventsPaginated.describeFleetEvents(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [DescribeFleetEventsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeFleetEventsResponse]
 */
public fun GameLiftClient.describeFleetEventsPaginated(block: DescribeFleetEventsRequest.Builder.() -> Unit): Flow<DescribeFleetEventsResponse> =
    describeFleetEventsPaginated(DescribeFleetEventsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeFleetEventsPaginated]
 * to access the nested member [Event]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Event]
 */
@JvmName("describeFleetEventsResponseEvent")
public fun Flow<DescribeFleetEventsResponse>.events(): Flow<Event> =
    transform() { response ->
        response.events?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeFleetLocationAttributesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeFleetLocationAttributesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeFleetLocationAttributesResponse]
 */
public fun GameLiftClient.describeFleetLocationAttributesPaginated(initialRequest: DescribeFleetLocationAttributesRequest): Flow<DescribeFleetLocationAttributesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeFleetLocationAttributesPaginated.describeFleetLocationAttributes(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [DescribeFleetLocationAttributesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeFleetLocationAttributesResponse]
 */
public fun GameLiftClient.describeFleetLocationAttributesPaginated(block: DescribeFleetLocationAttributesRequest.Builder.() -> Unit): Flow<DescribeFleetLocationAttributesResponse> =
    describeFleetLocationAttributesPaginated(DescribeFleetLocationAttributesRequest.Builder().apply(block).build())

/**
 * Paginate over [DescribeFleetUtilizationResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeFleetUtilizationRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeFleetUtilizationResponse]
 */
public fun GameLiftClient.describeFleetUtilizationPaginated(initialRequest: DescribeFleetUtilizationRequest): Flow<DescribeFleetUtilizationResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeFleetUtilizationPaginated.describeFleetUtilization(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [DescribeFleetUtilizationResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeFleetUtilizationResponse]
 */
public fun GameLiftClient.describeFleetUtilizationPaginated(block: DescribeFleetUtilizationRequest.Builder.() -> Unit): Flow<DescribeFleetUtilizationResponse> =
    describeFleetUtilizationPaginated(DescribeFleetUtilizationRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeFleetUtilizationPaginated]
 * to access the nested member [FleetUtilization]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [FleetUtilization]
 */
@JvmName("describeFleetUtilizationResponseFleetUtilization")
public fun Flow<DescribeFleetUtilizationResponse>.fleetUtilization(): Flow<FleetUtilization> =
    transform() { response ->
        response.fleetUtilization?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeGameServerInstancesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeGameServerInstancesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeGameServerInstancesResponse]
 */
public fun GameLiftClient.describeGameServerInstancesPaginated(initialRequest: DescribeGameServerInstancesRequest): Flow<DescribeGameServerInstancesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeGameServerInstancesPaginated.describeGameServerInstances(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [DescribeGameServerInstancesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeGameServerInstancesResponse]
 */
public fun GameLiftClient.describeGameServerInstancesPaginated(block: DescribeGameServerInstancesRequest.Builder.() -> Unit): Flow<DescribeGameServerInstancesResponse> =
    describeGameServerInstancesPaginated(DescribeGameServerInstancesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeGameServerInstancesPaginated]
 * to access the nested member [GameServerInstance]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GameServerInstance]
 */
@JvmName("describeGameServerInstancesResponseGameServerInstance")
public fun Flow<DescribeGameServerInstancesResponse>.gameServerInstances(): Flow<GameServerInstance> =
    transform() { response ->
        response.gameServerInstances?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeGameSessionDetailsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeGameSessionDetailsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeGameSessionDetailsResponse]
 */
public fun GameLiftClient.describeGameSessionDetailsPaginated(initialRequest: DescribeGameSessionDetailsRequest): Flow<DescribeGameSessionDetailsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeGameSessionDetailsPaginated.describeGameSessionDetails(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [DescribeGameSessionDetailsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeGameSessionDetailsResponse]
 */
public fun GameLiftClient.describeGameSessionDetailsPaginated(block: DescribeGameSessionDetailsRequest.Builder.() -> Unit): Flow<DescribeGameSessionDetailsResponse> =
    describeGameSessionDetailsPaginated(DescribeGameSessionDetailsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeGameSessionDetailsPaginated]
 * to access the nested member [GameSessionDetail]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GameSessionDetail]
 */
@JvmName("describeGameSessionDetailsResponseGameSessionDetail")
public fun Flow<DescribeGameSessionDetailsResponse>.gameSessionDetails(): Flow<GameSessionDetail> =
    transform() { response ->
        response.gameSessionDetails?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeGameSessionQueuesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeGameSessionQueuesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeGameSessionQueuesResponse]
 */
public fun GameLiftClient.describeGameSessionQueuesPaginated(initialRequest: DescribeGameSessionQueuesRequest): Flow<DescribeGameSessionQueuesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeGameSessionQueuesPaginated.describeGameSessionQueues(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [DescribeGameSessionQueuesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeGameSessionQueuesResponse]
 */
public fun GameLiftClient.describeGameSessionQueuesPaginated(block: DescribeGameSessionQueuesRequest.Builder.() -> Unit): Flow<DescribeGameSessionQueuesResponse> =
    describeGameSessionQueuesPaginated(DescribeGameSessionQueuesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeGameSessionQueuesPaginated]
 * to access the nested member [GameSessionQueue]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GameSessionQueue]
 */
@JvmName("describeGameSessionQueuesResponseGameSessionQueue")
public fun Flow<DescribeGameSessionQueuesResponse>.gameSessionQueues(): Flow<GameSessionQueue> =
    transform() { response ->
        response.gameSessionQueues?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeGameSessionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeGameSessionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeGameSessionsResponse]
 */
public fun GameLiftClient.describeGameSessionsPaginated(initialRequest: DescribeGameSessionsRequest): Flow<DescribeGameSessionsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeGameSessionsPaginated.describeGameSessions(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [DescribeGameSessionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeGameSessionsResponse]
 */
public fun GameLiftClient.describeGameSessionsPaginated(block: DescribeGameSessionsRequest.Builder.() -> Unit): Flow<DescribeGameSessionsResponse> =
    describeGameSessionsPaginated(DescribeGameSessionsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeGameSessionsPaginated]
 * to access the nested member [GameSession]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GameSession]
 */
@JvmName("describeGameSessionsResponseGameSession")
public fun Flow<DescribeGameSessionsResponse>.gameSessions(): Flow<GameSession> =
    transform() { response ->
        response.gameSessions?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeInstancesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeInstancesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeInstancesResponse]
 */
public fun GameLiftClient.describeInstancesPaginated(initialRequest: DescribeInstancesRequest): Flow<DescribeInstancesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeInstancesPaginated.describeInstances(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [DescribeInstancesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeInstancesResponse]
 */
public fun GameLiftClient.describeInstancesPaginated(block: DescribeInstancesRequest.Builder.() -> Unit): Flow<DescribeInstancesResponse> =
    describeInstancesPaginated(DescribeInstancesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeInstancesPaginated]
 * to access the nested member [Instance]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Instance]
 */
@JvmName("describeInstancesResponseInstance")
public fun Flow<DescribeInstancesResponse>.instances(): Flow<Instance> =
    transform() { response ->
        response.instances?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeMatchmakingConfigurationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeMatchmakingConfigurationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeMatchmakingConfigurationsResponse]
 */
public fun GameLiftClient.describeMatchmakingConfigurationsPaginated(initialRequest: DescribeMatchmakingConfigurationsRequest): Flow<DescribeMatchmakingConfigurationsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeMatchmakingConfigurationsPaginated.describeMatchmakingConfigurations(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [DescribeMatchmakingConfigurationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeMatchmakingConfigurationsResponse]
 */
public fun GameLiftClient.describeMatchmakingConfigurationsPaginated(block: DescribeMatchmakingConfigurationsRequest.Builder.() -> Unit): Flow<DescribeMatchmakingConfigurationsResponse> =
    describeMatchmakingConfigurationsPaginated(DescribeMatchmakingConfigurationsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeMatchmakingConfigurationsPaginated]
 * to access the nested member [MatchmakingConfiguration]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [MatchmakingConfiguration]
 */
@JvmName("describeMatchmakingConfigurationsResponseMatchmakingConfiguration")
public fun Flow<DescribeMatchmakingConfigurationsResponse>.configurations(): Flow<MatchmakingConfiguration> =
    transform() { response ->
        response.configurations?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeMatchmakingRuleSetsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeMatchmakingRuleSetsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeMatchmakingRuleSetsResponse]
 */
public fun GameLiftClient.describeMatchmakingRuleSetsPaginated(initialRequest: DescribeMatchmakingRuleSetsRequest): Flow<DescribeMatchmakingRuleSetsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeMatchmakingRuleSetsPaginated.describeMatchmakingRuleSets(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [DescribeMatchmakingRuleSetsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeMatchmakingRuleSetsResponse]
 */
public fun GameLiftClient.describeMatchmakingRuleSetsPaginated(block: DescribeMatchmakingRuleSetsRequest.Builder.() -> Unit): Flow<DescribeMatchmakingRuleSetsResponse> =
    describeMatchmakingRuleSetsPaginated(DescribeMatchmakingRuleSetsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeMatchmakingRuleSetsPaginated]
 * to access the nested member [MatchmakingRuleSet]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [MatchmakingRuleSet]
 */
@JvmName("describeMatchmakingRuleSetsResponseMatchmakingRuleSet")
public fun Flow<DescribeMatchmakingRuleSetsResponse>.ruleSets(): Flow<MatchmakingRuleSet> =
    transform() { response ->
        response.ruleSets?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribePlayerSessionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribePlayerSessionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribePlayerSessionsResponse]
 */
public fun GameLiftClient.describePlayerSessionsPaginated(initialRequest: DescribePlayerSessionsRequest): Flow<DescribePlayerSessionsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describePlayerSessionsPaginated.describePlayerSessions(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [DescribePlayerSessionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribePlayerSessionsResponse]
 */
public fun GameLiftClient.describePlayerSessionsPaginated(block: DescribePlayerSessionsRequest.Builder.() -> Unit): Flow<DescribePlayerSessionsResponse> =
    describePlayerSessionsPaginated(DescribePlayerSessionsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describePlayerSessionsPaginated]
 * to access the nested member [PlayerSession]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [PlayerSession]
 */
@JvmName("describePlayerSessionsResponsePlayerSession")
public fun Flow<DescribePlayerSessionsResponse>.playerSessions(): Flow<PlayerSession> =
    transform() { response ->
        response.playerSessions?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeScalingPoliciesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeScalingPoliciesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeScalingPoliciesResponse]
 */
public fun GameLiftClient.describeScalingPoliciesPaginated(initialRequest: DescribeScalingPoliciesRequest): Flow<DescribeScalingPoliciesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeScalingPoliciesPaginated.describeScalingPolicies(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [DescribeScalingPoliciesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeScalingPoliciesResponse]
 */
public fun GameLiftClient.describeScalingPoliciesPaginated(block: DescribeScalingPoliciesRequest.Builder.() -> Unit): Flow<DescribeScalingPoliciesResponse> =
    describeScalingPoliciesPaginated(DescribeScalingPoliciesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeScalingPoliciesPaginated]
 * to access the nested member [ScalingPolicy]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ScalingPolicy]
 */
@JvmName("describeScalingPoliciesResponseScalingPolicy")
public fun Flow<DescribeScalingPoliciesResponse>.scalingPolicies(): Flow<ScalingPolicy> =
    transform() { response ->
        response.scalingPolicies?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListAliasesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListAliasesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAliasesResponse]
 */
public fun GameLiftClient.listAliasesPaginated(initialRequest: ListAliasesRequest): Flow<ListAliasesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listAliasesPaginated.listAliases(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListAliasesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAliasesResponse]
 */
public fun GameLiftClient.listAliasesPaginated(block: ListAliasesRequest.Builder.() -> Unit): Flow<ListAliasesResponse> =
    listAliasesPaginated(ListAliasesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listAliasesPaginated]
 * to access the nested member [Alias]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Alias]
 */
@JvmName("listAliasesResponseAlias")
public fun Flow<ListAliasesResponse>.aliases(): Flow<Alias> =
    transform() { response ->
        response.aliases?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListBuildsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListBuildsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListBuildsResponse]
 */
public fun GameLiftClient.listBuildsPaginated(initialRequest: ListBuildsRequest): Flow<ListBuildsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listBuildsPaginated.listBuilds(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListBuildsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListBuildsResponse]
 */
public fun GameLiftClient.listBuildsPaginated(block: ListBuildsRequest.Builder.() -> Unit): Flow<ListBuildsResponse> =
    listBuildsPaginated(ListBuildsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listBuildsPaginated]
 * to access the nested member [Build]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Build]
 */
@JvmName("listBuildsResponseBuild")
public fun Flow<ListBuildsResponse>.builds(): Flow<Build> =
    transform() { response ->
        response.builds?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListFleetsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListFleetsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListFleetsResponse]
 */
public fun GameLiftClient.listFleetsPaginated(initialRequest: ListFleetsRequest): Flow<ListFleetsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listFleetsPaginated.listFleets(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListFleetsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListFleetsResponse]
 */
public fun GameLiftClient.listFleetsPaginated(block: ListFleetsRequest.Builder.() -> Unit): Flow<ListFleetsResponse> =
    listFleetsPaginated(ListFleetsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listFleetsPaginated]
 * to access the nested member [FleetId]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [FleetId]
 */
@JvmName("listFleetsResponseFleetId")
public fun Flow<ListFleetsResponse>.fleetIds(): Flow<String> =
    transform() { response ->
        response.fleetIds?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListGameServerGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListGameServerGroupsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListGameServerGroupsResponse]
 */
public fun GameLiftClient.listGameServerGroupsPaginated(initialRequest: ListGameServerGroupsRequest): Flow<ListGameServerGroupsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listGameServerGroupsPaginated.listGameServerGroups(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListGameServerGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListGameServerGroupsResponse]
 */
public fun GameLiftClient.listGameServerGroupsPaginated(block: ListGameServerGroupsRequest.Builder.() -> Unit): Flow<ListGameServerGroupsResponse> =
    listGameServerGroupsPaginated(ListGameServerGroupsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listGameServerGroupsPaginated]
 * to access the nested member [GameServerGroup]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GameServerGroup]
 */
@JvmName("listGameServerGroupsResponseGameServerGroup")
public fun Flow<ListGameServerGroupsResponse>.gameServerGroups(): Flow<GameServerGroup> =
    transform() { response ->
        response.gameServerGroups?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListGameServersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListGameServersRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListGameServersResponse]
 */
public fun GameLiftClient.listGameServersPaginated(initialRequest: ListGameServersRequest): Flow<ListGameServersResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listGameServersPaginated.listGameServers(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListGameServersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListGameServersResponse]
 */
public fun GameLiftClient.listGameServersPaginated(block: ListGameServersRequest.Builder.() -> Unit): Flow<ListGameServersResponse> =
    listGameServersPaginated(ListGameServersRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listGameServersPaginated]
 * to access the nested member [GameServer]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GameServer]
 */
@JvmName("listGameServersResponseGameServer")
public fun Flow<ListGameServersResponse>.gameServers(): Flow<GameServer> =
    transform() { response ->
        response.gameServers?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListScriptsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListScriptsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListScriptsResponse]
 */
public fun GameLiftClient.listScriptsPaginated(initialRequest: ListScriptsRequest): Flow<ListScriptsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listScriptsPaginated.listScripts(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListScriptsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListScriptsResponse]
 */
public fun GameLiftClient.listScriptsPaginated(block: ListScriptsRequest.Builder.() -> Unit): Flow<ListScriptsResponse> =
    listScriptsPaginated(ListScriptsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listScriptsPaginated]
 * to access the nested member [Script]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Script]
 */
@JvmName("listScriptsResponseScript")
public fun Flow<ListScriptsResponse>.scripts(): Flow<Script> =
    transform() { response ->
        response.scripts?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [SearchGameSessionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [SearchGameSessionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SearchGameSessionsResponse]
 */
public fun GameLiftClient.searchGameSessionsPaginated(initialRequest: SearchGameSessionsRequest): Flow<SearchGameSessionsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@searchGameSessionsPaginated.searchGameSessions(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [SearchGameSessionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SearchGameSessionsResponse]
 */
public fun GameLiftClient.searchGameSessionsPaginated(block: SearchGameSessionsRequest.Builder.() -> Unit): Flow<SearchGameSessionsResponse> =
    searchGameSessionsPaginated(SearchGameSessionsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [searchGameSessionsPaginated]
 * to access the nested member [GameSession]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GameSession]
 */
@JvmName("searchGameSessionsResponseGameSession")
public fun Flow<SearchGameSessionsResponse>.gameSessions(): Flow<GameSession> =
    transform() { response ->
        response.gameSessions?.forEach {
            emit(it)
        }
    }
