// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.gamelift.transform

import aws.sdk.kotlin.services.gamelift.model.CreateBuildRequest
import aws.sdk.kotlin.services.gamelift.model.OperatingSystem
import aws.sdk.kotlin.services.gamelift.model.S3Location
import aws.sdk.kotlin.services.gamelift.model.Tag
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateBuildOperationSerializer: HttpSerialize<CreateBuildRequest> {
    override suspend fun serialize(context: ExecutionContext, input: CreateBuildRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path = "/"
        }

        val payload = serializeCreateBuildOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/x-amz-json-1.1")
        }
        return builder
    }
}

private fun serializeCreateBuildOperationBody(context: ExecutionContext, input: CreateBuildRequest): ByteArray {
    val serializer = JsonSerializer()
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Name"))
    val OPERATINGSYSTEM_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("OperatingSystem"))
    val STORAGELOCATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("StorageLocation"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Tags"))
    val VERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Version"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(NAME_DESCRIPTOR)
        field(OPERATINGSYSTEM_DESCRIPTOR)
        field(STORAGELOCATION_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(VERSION_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.name?.let { field(NAME_DESCRIPTOR, it) }
        input.operatingSystem?.let { field(OPERATINGSYSTEM_DESCRIPTOR, it.value) }
        input.storageLocation?.let { field(STORAGELOCATION_DESCRIPTOR, it, ::serializeS3LocationDocument) }
        if (input.tags != null) {
            listField(TAGS_DESCRIPTOR) {
                for (el0 in input.tags) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeTagDocument))
                }
            }
        }
        input.version?.let { field(VERSION_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
