// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.gamelift.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.gamelift.model.CreatePlayerSessionResponse
import aws.sdk.kotlin.services.gamelift.model.GameLiftException
import aws.sdk.kotlin.services.gamelift.model.PlayerSession
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreatePlayerSessionOperationDeserializer: HttpDeserialize<CreatePlayerSessionResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): CreatePlayerSessionResponse {
        if (!response.status.isSuccess()) {
            throwCreatePlayerSessionError(context, response)
        }
        val builder = CreatePlayerSessionResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreatePlayerSessionOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwCreatePlayerSessionError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw GameLiftException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "GameSessionFullException" -> GameSessionFullExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServiceException" -> InternalServiceExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidGameSessionStatusException" -> InvalidGameSessionStatusExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "TerminalRoutingStrategyException" -> TerminalRoutingStrategyExceptionDeserializer().deserialize(context, wrappedResponse)
        "UnauthorizedException" -> UnauthorizedExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> GameLiftException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreatePlayerSessionOperationBody(builder: CreatePlayerSessionResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val PLAYERSESSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("PlayerSession"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(PLAYERSESSION_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                PLAYERSESSION_DESCRIPTOR.index -> builder.playerSession = deserializePlayerSessionDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
