// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.gamelift.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.gamelift.model.DescribeGameServerGroupResponse
import aws.sdk.kotlin.services.gamelift.model.GameLiftException
import aws.sdk.kotlin.services.gamelift.model.GameServerGroup
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DescribeGameServerGroupOperationDeserializer: HttpDeserialize<DescribeGameServerGroupResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeGameServerGroupResponse {
        if (!response.status.isSuccess()) {
            throwDescribeGameServerGroupError(context, response)
        }
        val builder = DescribeGameServerGroupResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeGameServerGroupOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeGameServerGroupError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw GameLiftException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServiceException" -> InternalServiceExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "UnauthorizedException" -> UnauthorizedExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> GameLiftException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeGameServerGroupOperationBody(builder: DescribeGameServerGroupResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val GAMESERVERGROUP_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("GameServerGroup"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(GAMESERVERGROUP_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                GAMESERVERGROUP_DESCRIPTOR.index -> builder.gameServerGroup = deserializeGameServerGroupDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
