// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.gamelift.transform

import aws.sdk.kotlin.services.gamelift.model.DesiredPlayerSession
import aws.sdk.kotlin.services.gamelift.model.GameProperty
import aws.sdk.kotlin.services.gamelift.model.PlayerLatency
import aws.sdk.kotlin.services.gamelift.model.StartGameSessionPlacementRequest
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class StartGameSessionPlacementOperationSerializer: HttpSerialize<StartGameSessionPlacementRequest> {
    override suspend fun serialize(context: ExecutionContext, input: StartGameSessionPlacementRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path = "/"
        }

        val payload = serializeStartGameSessionPlacementOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/x-amz-json-1.1")
        }
        return builder
    }
}

private fun serializeStartGameSessionPlacementOperationBody(context: ExecutionContext, input: StartGameSessionPlacementRequest): ByteArray {
    val serializer = JsonSerializer()
    val DESIREDPLAYERSESSIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("DesiredPlayerSessions"))
    val GAMEPROPERTIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("GameProperties"))
    val GAMESESSIONDATA_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("GameSessionData"))
    val GAMESESSIONNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("GameSessionName"))
    val GAMESESSIONQUEUENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("GameSessionQueueName"))
    val MAXIMUMPLAYERSESSIONCOUNT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("MaximumPlayerSessionCount"))
    val PLACEMENTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("PlacementId"))
    val PLAYERLATENCIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("PlayerLatencies"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DESIREDPLAYERSESSIONS_DESCRIPTOR)
        field(GAMEPROPERTIES_DESCRIPTOR)
        field(GAMESESSIONDATA_DESCRIPTOR)
        field(GAMESESSIONNAME_DESCRIPTOR)
        field(GAMESESSIONQUEUENAME_DESCRIPTOR)
        field(MAXIMUMPLAYERSESSIONCOUNT_DESCRIPTOR)
        field(PLACEMENTID_DESCRIPTOR)
        field(PLAYERLATENCIES_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        if (input.desiredPlayerSessions != null) {
            listField(DESIREDPLAYERSESSIONS_DESCRIPTOR) {
                for (el0 in input.desiredPlayerSessions) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeDesiredPlayerSessionDocument))
                }
            }
        }
        if (input.gameProperties != null) {
            listField(GAMEPROPERTIES_DESCRIPTOR) {
                for (el0 in input.gameProperties) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeGamePropertyDocument))
                }
            }
        }
        input.gameSessionData?.let { field(GAMESESSIONDATA_DESCRIPTOR, it) }
        input.gameSessionName?.let { field(GAMESESSIONNAME_DESCRIPTOR, it) }
        input.gameSessionQueueName?.let { field(GAMESESSIONQUEUENAME_DESCRIPTOR, it) }
        input.maximumPlayerSessionCount?.let { field(MAXIMUMPLAYERSESSIONCOUNT_DESCRIPTOR, it) }
        input.placementId?.let { field(PLACEMENTID_DESCRIPTOR, it) }
        if (input.playerLatencies != null) {
            listField(PLAYERLATENCIES_DESCRIPTOR) {
                for (el0 in input.playerLatencies) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializePlayerLatencyDocument))
                }
            }
        }
    }
    return serializer.toByteArray()
}
