// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.gamelift.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.gamelift.model.Alias
import aws.sdk.kotlin.services.gamelift.model.GameLiftException
import aws.sdk.kotlin.services.gamelift.model.UpdateAliasResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class UpdateAliasOperationDeserializer: HttpDeserialize<UpdateAliasResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): UpdateAliasResponse {
        if (!response.status.isSuccess()) {
            throwUpdateAliasError(context, response)
        }
        val builder = UpdateAliasResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeUpdateAliasOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwUpdateAliasError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw GameLiftException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServiceException" -> InternalServiceExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "UnauthorizedException" -> UnauthorizedExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> GameLiftException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeUpdateAliasOperationBody(builder: UpdateAliasResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ALIAS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Alias"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ALIAS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ALIAS_DESCRIPTOR.index -> builder.alias = deserializeAliasDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
