// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.gamelift.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Properties describing a custom game build.
 *
 * Related actions
 *
 *
 * CreateBuild |
 * ListBuilds |
 * DescribeBuild |
 * UpdateBuild |
 * DeleteBuild |
 * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets">All APIs by task
 */
class Build private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN) that is assigned to a GameLift build resource and uniquely identifies it. ARNs are unique across all Regions. Format is arn:aws:gamelift:<region>::build/build-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912. In a GameLift build ARN, the resource ID matches the
     * BuildId value.
     */
    val buildArn: kotlin.String? = builder.buildArn
    /**
     * A unique identifier for the build.
     */
    val buildId: kotlin.String? = builder.buildId
    /**
     * A time stamp indicating when this data object was created. Format is a number expressed in Unix time as milliseconds (for example "1469498468.057").
     */
    val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * A descriptive label that is associated with a build. Build names do not need to be unique. It can be set using CreateBuild or UpdateBuild.
     */
    val name: kotlin.String? = builder.name
    /**
     * Operating system that the game server binaries are built to run on. This value
     * determines the type of fleet resources that you can use for this build.
     */
    val operatingSystem: aws.sdk.kotlin.services.gamelift.model.OperatingSystem? = builder.operatingSystem
    /**
     * File size of the uploaded game build, expressed in bytes. When the build status is
     * INITIALIZED, this value is 0.
     */
    val sizeOnDisk: kotlin.Long? = builder.sizeOnDisk
    /**
     * Current status of the build.
     * Possible build statuses include the following:
     *
     *
     *
     * INITIALIZED -- A new build has been defined,
     * but no files have been uploaded. You cannot create fleets for builds that are in
     * this status. When a build is successfully created, the build status is set to
     * this value.
     *
     *
     * READY -- The game build has been successfully
     * uploaded. You can now create new fleets for this build.
     *
     *
     * FAILED -- The game build upload failed. You
     * cannot create new fleets for this build.
     */
    val status: aws.sdk.kotlin.services.gamelift.model.BuildStatus? = builder.status
    /**
     * Version information that is associated with a build or script. Version strings do not need to be unique. This value can be set using CreateBuild or UpdateBuild.
     */
    val version: kotlin.String? = builder.version

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.gamelift.model.Build = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Build(")
        append("buildArn=$buildArn,")
        append("buildId=$buildId,")
        append("creationTime=$creationTime,")
        append("name=$name,")
        append("operatingSystem=$operatingSystem,")
        append("sizeOnDisk=$sizeOnDisk,")
        append("status=$status,")
        append("version=$version)")
    }

    override fun hashCode(): kotlin.Int {
        var result = buildArn?.hashCode() ?: 0
        result = 31 * result + (buildId?.hashCode() ?: 0)
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (operatingSystem?.hashCode() ?: 0)
        result = 31 * result + (sizeOnDisk?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (version?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Build

        if (buildArn != other.buildArn) return false
        if (buildId != other.buildId) return false
        if (creationTime != other.creationTime) return false
        if (name != other.name) return false
        if (operatingSystem != other.operatingSystem) return false
        if (sizeOnDisk != other.sizeOnDisk) return false
        if (status != other.status) return false
        if (version != other.version) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.gamelift.model.Build = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN) that is assigned to a GameLift build resource and uniquely identifies it. ARNs are unique across all Regions. Format is arn:aws:gamelift:<region>::build/build-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912. In a GameLift build ARN, the resource ID matches the
         * BuildId value.
         */
        var buildArn: kotlin.String? = null
        /**
         * A unique identifier for the build.
         */
        var buildId: kotlin.String? = null
        /**
         * A time stamp indicating when this data object was created. Format is a number expressed in Unix time as milliseconds (for example "1469498468.057").
         */
        var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A descriptive label that is associated with a build. Build names do not need to be unique. It can be set using CreateBuild or UpdateBuild.
         */
        var name: kotlin.String? = null
        /**
         * Operating system that the game server binaries are built to run on. This value
         * determines the type of fleet resources that you can use for this build.
         */
        var operatingSystem: aws.sdk.kotlin.services.gamelift.model.OperatingSystem? = null
        /**
         * File size of the uploaded game build, expressed in bytes. When the build status is
         * INITIALIZED, this value is 0.
         */
        var sizeOnDisk: kotlin.Long? = null
        /**
         * Current status of the build.
         * Possible build statuses include the following:
         *
         *
         *
         * INITIALIZED -- A new build has been defined,
         * but no files have been uploaded. You cannot create fleets for builds that are in
         * this status. When a build is successfully created, the build status is set to
         * this value.
         *
         *
         * READY -- The game build has been successfully
         * uploaded. You can now create new fleets for this build.
         *
         *
         * FAILED -- The game build upload failed. You
         * cannot create new fleets for this build.
         */
        var status: aws.sdk.kotlin.services.gamelift.model.BuildStatus? = null
        /**
         * Version information that is associated with a build or script. Version strings do not need to be unique. This value can be set using CreateBuild or UpdateBuild.
         */
        var version: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.gamelift.model.Build) : this() {
            this.buildArn = x.buildArn
            this.buildId = x.buildId
            this.creationTime = x.creationTime
            this.name = x.name
            this.operatingSystem = x.operatingSystem
            this.sizeOnDisk = x.sizeOnDisk
            this.status = x.status
            this.version = x.version
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.gamelift.model.Build = Build(this)
    }
}
