// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.gamelift.model



class ClaimGameServerRequest private constructor(builder: Builder) {
    /**
     * A set of custom game server properties, formatted as a single string value. This data
     * is passed to a game client or service when it requests information on game servers using
     * ListGameServers or ClaimGameServer.
     */
    val gameServerData: kotlin.String? = builder.gameServerData
    /**
     * A unique identifier for the game server group where the game server is running.
     * Use either the GameServerGroup name or ARN value. If you are not specifying a game server to claim, this value identifies
     * where you want GameLift FleetIQ to look for an available game server to claim.
     */
    val gameServerGroupName: kotlin.String? = builder.gameServerGroupName
    /**
     * A custom string that uniquely identifies the game server to claim. If this parameter
     * is left empty, GameLift FleetIQ searches for an available game server in the specified game
     * server group.
     */
    val gameServerId: kotlin.String? = builder.gameServerId

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.gamelift.model.ClaimGameServerRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ClaimGameServerRequest(")
        append("gameServerData=$gameServerData,")
        append("gameServerGroupName=$gameServerGroupName,")
        append("gameServerId=$gameServerId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = gameServerData?.hashCode() ?: 0
        result = 31 * result + (gameServerGroupName?.hashCode() ?: 0)
        result = 31 * result + (gameServerId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ClaimGameServerRequest

        if (gameServerData != other.gameServerData) return false
        if (gameServerGroupName != other.gameServerGroupName) return false
        if (gameServerId != other.gameServerId) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.gamelift.model.ClaimGameServerRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * A set of custom game server properties, formatted as a single string value. This data
         * is passed to a game client or service when it requests information on game servers using
         * ListGameServers or ClaimGameServer.
         */
        var gameServerData: kotlin.String? = null
        /**
         * A unique identifier for the game server group where the game server is running.
         * Use either the GameServerGroup name or ARN value. If you are not specifying a game server to claim, this value identifies
         * where you want GameLift FleetIQ to look for an available game server to claim.
         */
        var gameServerGroupName: kotlin.String? = null
        /**
         * A custom string that uniquely identifies the game server to claim. If this parameter
         * is left empty, GameLift FleetIQ searches for an available game server in the specified game
         * server group.
         */
        var gameServerId: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.gamelift.model.ClaimGameServerRequest) : this() {
            this.gameServerData = x.gameServerData
            this.gameServerGroupName = x.gameServerGroupName
            this.gameServerId = x.gameServerId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.gamelift.model.ClaimGameServerRequest = ClaimGameServerRequest(this)
    }
}
