// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.gamelift.model



/**
 * Represents the input for a request operation.
 */
class CreateBuildRequest private constructor(builder: Builder) {
    /**
     * A descriptive label that is associated with a build. Build names do not need to be unique. You can use UpdateBuild to change this value later.
     */
    val name: kotlin.String? = builder.name
    /**
     * The operating system that the game server binaries are built to run on. This value
     * determines the type of fleet resources that you can use for this build. If your game
     * build contains multiple executables, they all must run on the same operating system. If
     * an operating system is not specified when creating a build, Amazon GameLift uses the
     * default value (WINDOWS_2012). This value cannot be changed later.
     */
    val operatingSystem: aws.sdk.kotlin.services.gamelift.model.OperatingSystem? = builder.operatingSystem
    /**
     * Information indicating where your game build files are stored. Use this parameter only
     * when creating a build with files stored in an Amazon S3 bucket that you own. The storage
     * location must specify an Amazon S3 bucket name and key. The location must also specify a role
     * ARN that you set up to allow Amazon GameLift to access your Amazon S3 bucket. The S3 bucket and your
     * new build must be in the same Region.
     */
    val storageLocation: aws.sdk.kotlin.services.gamelift.model.S3Location? = builder.storageLocation
    /**
     * A list of labels to assign to the new build resource. Tags are developer-defined
     * key-value pairs. Tagging
     * AWS resources are useful for resource management, access management and cost allocation.
     * For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html"> Tagging AWS Resources in the
     * AWS General Reference. Once the resource is created, you can
     * use TagResource, UntagResource, and
     * ListTagsForResource to add, remove, and view tags. The
     * maximum tag limit may be lower than stated. See the AWS General Reference for actual
     * tagging limits.
     */
    val tags: List<Tag>? = builder.tags
    /**
     * Version information that is associated with a build or script. Version strings do not need to be unique. You can use UpdateBuild to change this value later.
     */
    val version: kotlin.String? = builder.version

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.gamelift.model.CreateBuildRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateBuildRequest(")
        append("name=$name,")
        append("operatingSystem=$operatingSystem,")
        append("storageLocation=$storageLocation,")
        append("tags=$tags,")
        append("version=$version)")
    }

    override fun hashCode(): kotlin.Int {
        var result = name?.hashCode() ?: 0
        result = 31 * result + (operatingSystem?.hashCode() ?: 0)
        result = 31 * result + (storageLocation?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (version?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateBuildRequest

        if (name != other.name) return false
        if (operatingSystem != other.operatingSystem) return false
        if (storageLocation != other.storageLocation) return false
        if (tags != other.tags) return false
        if (version != other.version) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.gamelift.model.CreateBuildRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * A descriptive label that is associated with a build. Build names do not need to be unique. You can use UpdateBuild to change this value later.
         */
        var name: kotlin.String? = null
        /**
         * The operating system that the game server binaries are built to run on. This value
         * determines the type of fleet resources that you can use for this build. If your game
         * build contains multiple executables, they all must run on the same operating system. If
         * an operating system is not specified when creating a build, Amazon GameLift uses the
         * default value (WINDOWS_2012). This value cannot be changed later.
         */
        var operatingSystem: aws.sdk.kotlin.services.gamelift.model.OperatingSystem? = null
        /**
         * Information indicating where your game build files are stored. Use this parameter only
         * when creating a build with files stored in an Amazon S3 bucket that you own. The storage
         * location must specify an Amazon S3 bucket name and key. The location must also specify a role
         * ARN that you set up to allow Amazon GameLift to access your Amazon S3 bucket. The S3 bucket and your
         * new build must be in the same Region.
         */
        var storageLocation: aws.sdk.kotlin.services.gamelift.model.S3Location? = null
        /**
         * A list of labels to assign to the new build resource. Tags are developer-defined
         * key-value pairs. Tagging
         * AWS resources are useful for resource management, access management and cost allocation.
         * For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html"> Tagging AWS Resources in the
         * AWS General Reference. Once the resource is created, you can
         * use TagResource, UntagResource, and
         * ListTagsForResource to add, remove, and view tags. The
         * maximum tag limit may be lower than stated. See the AWS General Reference for actual
         * tagging limits.
         */
        var tags: List<Tag>? = null
        /**
         * Version information that is associated with a build or script. Version strings do not need to be unique. You can use UpdateBuild to change this value later.
         */
        var version: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.gamelift.model.CreateBuildRequest) : this() {
            this.name = x.name
            this.operatingSystem = x.operatingSystem
            this.storageLocation = x.storageLocation
            this.tags = x.tags
            this.version = x.version
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.gamelift.model.CreateBuildRequest = CreateBuildRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.gamelift.model.S3Location] inside the given [block]
         */
        fun storageLocation(block: aws.sdk.kotlin.services.gamelift.model.S3Location.Builder.() -> kotlin.Unit) {
            this.storageLocation = aws.sdk.kotlin.services.gamelift.model.S3Location.invoke(block)
        }
    }
}
