// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.gamelift.model



/**
 * Represents the input for a request operation.
 */
class CreateFleetRequest private constructor(builder: Builder) {
    /**
     * The unique identifier for a custom game server build to be deployed on fleet
     * instances. You can use either the build ID or ARN. The build must be uploaded to GameLift
     * and in READY status. This fleet property cannot be changed later.
     */
    val buildId: kotlin.String? = builder.buildId
    /**
     * Prompts GameLift to generate a TLS/SSL certificate for the fleet. TLS certificates are
     * used for encrypting traffic between game clients and the game servers that are running
     * on GameLift. By default, the CertificateConfiguration is set to
     * DISABLED. Learn more at <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-howitworks.html#gamelift-howitworks-security">Securing Client/Server Communication. This property cannot be changed after
     * the fleet is created.
     * Note: This feature requires the AWS Certificate Manager (ACM) service, which is not
     * available in all AWS regions. When working in a region that does not support this
     * feature, a fleet creation request with certificate generation fails with a 4xx
     * error.
     */
    val certificateConfiguration: aws.sdk.kotlin.services.gamelift.model.CertificateConfiguration? = builder.certificateConfiguration
    /**
     * A human-readable description of the fleet.
     */
    val description: kotlin.String? = builder.description
    /**
     * The allowed IP address ranges and port settings that allow inbound traffic to access
     * game sessions on this fleet. If the fleet is hosting a custom game build, this property
     * must be set before players can connect to game sessions. For Realtime Servers fleets, GameLift
     * automatically sets TCP and UDP ranges.
     */
    val ec2InboundPermissions: List<IpPermission>? = builder.ec2InboundPermissions
    /**
     * The GameLift-supported EC2 instance type to use for all fleet instances. Instance
     * type determines the computing resources that will be used to host your game servers,
     * including CPU, memory, storage, and networking capacity. See <a href="http://aws.amazon.com/ec2/instance-types/">Amazon EC2 Instance Types for detailed descriptions
     * of EC2 instance types.
     */
    val ec2InstanceType: aws.sdk.kotlin.services.gamelift.model.Ec2InstanceType? = builder.ec2InstanceType
    /**
     * Indicates whether to use On-Demand or Spot instances for this fleet. By default, this
     * property is set to ON_DEMAND. Learn more about when to use <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-ec2-instances.html#gamelift-ec2-instances-spot"> On-Demand versus Spot Instances. This property cannot be changed after the
     * fleet is created.
     */
    val fleetType: aws.sdk.kotlin.services.gamelift.model.FleetType? = builder.fleetType
    /**
     * A unique identifier for an AWS IAM role that manages access to your AWS services.
     * With an instance role ARN set, any application that runs on an instance in this fleet can assume the role,
     * including install scripts, server processes, and daemons (background processes). Create a role or look up a role's
     * ARN by using the <a href="https://console.aws.amazon.com/iam/">IAM dashboard in the AWS Management Console.
     * Learn more about using on-box credentials for your game servers at
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-resources.html">
     * Access external resources from a game server.  This property cannot be changed after the fleet is created.
     */
    val instanceRoleArn: kotlin.String? = builder.instanceRoleArn
    /**
     * A set of remote locations to deploy additional instances to and manage as part of the
     * fleet. This parameter can only be used when creating fleets in AWS Regions that support
     * multiple locations. You can add any GameLift-supported AWS Region as a remote location,
     * in the form of an AWS Region code such as us-west-2. To create a fleet with
     * instances in the home Region only, omit this parameter.
     */
    val locations: List<LocationConfiguration>? = builder.locations
    /**
     * This parameter is no longer used. To specify where
     * GameLift should store log files once a server process shuts down, use the GameLift server
     * API ProcessReady() and specify one or more directory paths in
     * logParameters. See more information in the <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api-ref.html#gamelift-sdk-server-api-ref-dataypes-process">Server API Reference.
     */
    val logPaths: List<String>? = builder.logPaths
    /**
     * The name of an AWS CloudWatch metric group to add this fleet to. A metric group is
     * used to aggregate the metrics for multiple fleets. You can specify an existing metric
     * group name or set a new name to create a new metric group. A fleet can be included in
     * only one metric group at a time.
     */
    val metricGroups: List<String>? = builder.metricGroups
    /**
     * A descriptive label that is associated with a fleet. Fleet names do not need to be unique.
     */
    val name: kotlin.String? = builder.name
    /**
     * The status of termination protection for active game sessions on the fleet. By
     * default, this property is set to NoProtection. You can also set game
     * session protection for an individual game session by calling UpdateGameSession.
     *
     *
     *
     * NoProtection - Game sessions can be terminated
     * during active gameplay as a result of a scale-down event.
     *
     *
     * FullProtection - Game sessions in
     * ACTIVE status cannot be terminated during a scale-down
     * event.
     */
    val newGameSessionProtectionPolicy: aws.sdk.kotlin.services.gamelift.model.ProtectionPolicy? = builder.newGameSessionProtectionPolicy
    /**
     * Used when peering your GameLift fleet with a VPC, the unique identifier for the AWS
     * account that owns the VPC. You can find your account ID in the AWS Management Console under account
     * settings.
     */
    val peerVpcAwsAccountId: kotlin.String? = builder.peerVpcAwsAccountId
    /**
     * A unique identifier for a VPC with resources to be accessed by your GameLift fleet. The
     * VPC must be in the same Region as your fleet. To look up a VPC ID, use the
     * <a href="https://console.aws.amazon.com/vpc/">VPC Dashboard in the AWS Management Console.
     * Learn more about VPC peering in <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/vpc-peering.html">VPC Peering with GameLift Fleets.
     */
    val peerVpcId: kotlin.String? = builder.peerVpcId
    /**
     * A policy that limits the number of game sessions that an individual player can create
     * on instances in this fleet within a specified span of time.
     */
    val resourceCreationLimitPolicy: aws.sdk.kotlin.services.gamelift.model.ResourceCreationLimitPolicy? = builder.resourceCreationLimitPolicy
    /**
     * Instructions for how to launch and maintain server processes on instances in the
     * fleet. The runtime configuration defines one or more server process configurations, each
     * identifying a build executable or Realtime script file and the number of processes of
     * that type to run concurrently.
     *
     * The RuntimeConfiguration parameter is required unless the fleet is
     * being configured using the older parameters ServerLaunchPath and
     * ServerLaunchParameters, which are still supported for backward
     * compatibility.
     */
    val runtimeConfiguration: aws.sdk.kotlin.services.gamelift.model.RuntimeConfiguration? = builder.runtimeConfiguration
    /**
     * The unique identifier for a Realtime configuration script to be deployed on fleet
     * instances. You can use either the script ID or ARN. Scripts must be uploaded to GameLift
     * prior to creating the fleet. This fleet property cannot be changed later.
     */
    val scriptId: kotlin.String? = builder.scriptId
    /**
     * This parameter is no longer used. Specify server
     * launch parameters using the RuntimeConfiguration parameter. Requests that
     * use this parameter instead continue to be valid.
     */
    val serverLaunchParameters: kotlin.String? = builder.serverLaunchParameters
    /**
     * This parameter is no longer used. Specify a server
     * launch path using the RuntimeConfiguration parameter. Requests that use
     * this parameter instead continue to be valid.
     */
    val serverLaunchPath: kotlin.String? = builder.serverLaunchPath
    /**
     * A list of labels to assign to the new fleet resource. Tags are developer-defined
     * key-value pairs. Tagging AWS resources are useful for resource management, access
     * management and cost allocation. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html"> Tagging AWS Resources in the
     * AWS General Reference. Once the fleet is created, you can use
     * TagResource, UntagResource, and ListTagsForResource to add, remove, and view tags. The maximum tag limit
     * may be lower than stated. See the AWS General Reference for actual
     * tagging limits.
     */
    val tags: List<Tag>? = builder.tags

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.gamelift.model.CreateFleetRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateFleetRequest(")
        append("buildId=$buildId,")
        append("certificateConfiguration=$certificateConfiguration,")
        append("description=$description,")
        append("ec2InboundPermissions=$ec2InboundPermissions,")
        append("ec2InstanceType=$ec2InstanceType,")
        append("fleetType=$fleetType,")
        append("instanceRoleArn=$instanceRoleArn,")
        append("locations=$locations,")
        append("logPaths=$logPaths,")
        append("metricGroups=$metricGroups,")
        append("name=$name,")
        append("newGameSessionProtectionPolicy=$newGameSessionProtectionPolicy,")
        append("peerVpcAwsAccountId=$peerVpcAwsAccountId,")
        append("peerVpcId=$peerVpcId,")
        append("resourceCreationLimitPolicy=$resourceCreationLimitPolicy,")
        append("runtimeConfiguration=$runtimeConfiguration,")
        append("scriptId=$scriptId,")
        append("serverLaunchParameters=$serverLaunchParameters,")
        append("serverLaunchPath=$serverLaunchPath,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = buildId?.hashCode() ?: 0
        result = 31 * result + (certificateConfiguration?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (ec2InboundPermissions?.hashCode() ?: 0)
        result = 31 * result + (ec2InstanceType?.hashCode() ?: 0)
        result = 31 * result + (fleetType?.hashCode() ?: 0)
        result = 31 * result + (instanceRoleArn?.hashCode() ?: 0)
        result = 31 * result + (locations?.hashCode() ?: 0)
        result = 31 * result + (logPaths?.hashCode() ?: 0)
        result = 31 * result + (metricGroups?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (newGameSessionProtectionPolicy?.hashCode() ?: 0)
        result = 31 * result + (peerVpcAwsAccountId?.hashCode() ?: 0)
        result = 31 * result + (peerVpcId?.hashCode() ?: 0)
        result = 31 * result + (resourceCreationLimitPolicy?.hashCode() ?: 0)
        result = 31 * result + (runtimeConfiguration?.hashCode() ?: 0)
        result = 31 * result + (scriptId?.hashCode() ?: 0)
        result = 31 * result + (serverLaunchParameters?.hashCode() ?: 0)
        result = 31 * result + (serverLaunchPath?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateFleetRequest

        if (buildId != other.buildId) return false
        if (certificateConfiguration != other.certificateConfiguration) return false
        if (description != other.description) return false
        if (ec2InboundPermissions != other.ec2InboundPermissions) return false
        if (ec2InstanceType != other.ec2InstanceType) return false
        if (fleetType != other.fleetType) return false
        if (instanceRoleArn != other.instanceRoleArn) return false
        if (locations != other.locations) return false
        if (logPaths != other.logPaths) return false
        if (metricGroups != other.metricGroups) return false
        if (name != other.name) return false
        if (newGameSessionProtectionPolicy != other.newGameSessionProtectionPolicy) return false
        if (peerVpcAwsAccountId != other.peerVpcAwsAccountId) return false
        if (peerVpcId != other.peerVpcId) return false
        if (resourceCreationLimitPolicy != other.resourceCreationLimitPolicy) return false
        if (runtimeConfiguration != other.runtimeConfiguration) return false
        if (scriptId != other.scriptId) return false
        if (serverLaunchParameters != other.serverLaunchParameters) return false
        if (serverLaunchPath != other.serverLaunchPath) return false
        if (tags != other.tags) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.gamelift.model.CreateFleetRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The unique identifier for a custom game server build to be deployed on fleet
         * instances. You can use either the build ID or ARN. The build must be uploaded to GameLift
         * and in READY status. This fleet property cannot be changed later.
         */
        var buildId: kotlin.String? = null
        /**
         * Prompts GameLift to generate a TLS/SSL certificate for the fleet. TLS certificates are
         * used for encrypting traffic between game clients and the game servers that are running
         * on GameLift. By default, the CertificateConfiguration is set to
         * DISABLED. Learn more at <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-howitworks.html#gamelift-howitworks-security">Securing Client/Server Communication. This property cannot be changed after
         * the fleet is created.
         * Note: This feature requires the AWS Certificate Manager (ACM) service, which is not
         * available in all AWS regions. When working in a region that does not support this
         * feature, a fleet creation request with certificate generation fails with a 4xx
         * error.
         */
        var certificateConfiguration: aws.sdk.kotlin.services.gamelift.model.CertificateConfiguration? = null
        /**
         * A human-readable description of the fleet.
         */
        var description: kotlin.String? = null
        /**
         * The allowed IP address ranges and port settings that allow inbound traffic to access
         * game sessions on this fleet. If the fleet is hosting a custom game build, this property
         * must be set before players can connect to game sessions. For Realtime Servers fleets, GameLift
         * automatically sets TCP and UDP ranges.
         */
        var ec2InboundPermissions: List<IpPermission>? = null
        /**
         * The GameLift-supported EC2 instance type to use for all fleet instances. Instance
         * type determines the computing resources that will be used to host your game servers,
         * including CPU, memory, storage, and networking capacity. See <a href="http://aws.amazon.com/ec2/instance-types/">Amazon EC2 Instance Types for detailed descriptions
         * of EC2 instance types.
         */
        var ec2InstanceType: aws.sdk.kotlin.services.gamelift.model.Ec2InstanceType? = null
        /**
         * Indicates whether to use On-Demand or Spot instances for this fleet. By default, this
         * property is set to ON_DEMAND. Learn more about when to use <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-ec2-instances.html#gamelift-ec2-instances-spot"> On-Demand versus Spot Instances. This property cannot be changed after the
         * fleet is created.
         */
        var fleetType: aws.sdk.kotlin.services.gamelift.model.FleetType? = null
        /**
         * A unique identifier for an AWS IAM role that manages access to your AWS services.
         * With an instance role ARN set, any application that runs on an instance in this fleet can assume the role,
         * including install scripts, server processes, and daemons (background processes). Create a role or look up a role's
         * ARN by using the <a href="https://console.aws.amazon.com/iam/">IAM dashboard in the AWS Management Console.
         * Learn more about using on-box credentials for your game servers at
         * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-resources.html">
         * Access external resources from a game server.  This property cannot be changed after the fleet is created.
         */
        var instanceRoleArn: kotlin.String? = null
        /**
         * A set of remote locations to deploy additional instances to and manage as part of the
         * fleet. This parameter can only be used when creating fleets in AWS Regions that support
         * multiple locations. You can add any GameLift-supported AWS Region as a remote location,
         * in the form of an AWS Region code such as us-west-2. To create a fleet with
         * instances in the home Region only, omit this parameter.
         */
        var locations: List<LocationConfiguration>? = null
        /**
         * This parameter is no longer used. To specify where
         * GameLift should store log files once a server process shuts down, use the GameLift server
         * API ProcessReady() and specify one or more directory paths in
         * logParameters. See more information in the <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api-ref.html#gamelift-sdk-server-api-ref-dataypes-process">Server API Reference.
         */
        var logPaths: List<String>? = null
        /**
         * The name of an AWS CloudWatch metric group to add this fleet to. A metric group is
         * used to aggregate the metrics for multiple fleets. You can specify an existing metric
         * group name or set a new name to create a new metric group. A fleet can be included in
         * only one metric group at a time.
         */
        var metricGroups: List<String>? = null
        /**
         * A descriptive label that is associated with a fleet. Fleet names do not need to be unique.
         */
        var name: kotlin.String? = null
        /**
         * The status of termination protection for active game sessions on the fleet. By
         * default, this property is set to NoProtection. You can also set game
         * session protection for an individual game session by calling UpdateGameSession.
         *
         *
         *
         * NoProtection - Game sessions can be terminated
         * during active gameplay as a result of a scale-down event.
         *
         *
         * FullProtection - Game sessions in
         * ACTIVE status cannot be terminated during a scale-down
         * event.
         */
        var newGameSessionProtectionPolicy: aws.sdk.kotlin.services.gamelift.model.ProtectionPolicy? = null
        /**
         * Used when peering your GameLift fleet with a VPC, the unique identifier for the AWS
         * account that owns the VPC. You can find your account ID in the AWS Management Console under account
         * settings.
         */
        var peerVpcAwsAccountId: kotlin.String? = null
        /**
         * A unique identifier for a VPC with resources to be accessed by your GameLift fleet. The
         * VPC must be in the same Region as your fleet. To look up a VPC ID, use the
         * <a href="https://console.aws.amazon.com/vpc/">VPC Dashboard in the AWS Management Console.
         * Learn more about VPC peering in <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/vpc-peering.html">VPC Peering with GameLift Fleets.
         */
        var peerVpcId: kotlin.String? = null
        /**
         * A policy that limits the number of game sessions that an individual player can create
         * on instances in this fleet within a specified span of time.
         */
        var resourceCreationLimitPolicy: aws.sdk.kotlin.services.gamelift.model.ResourceCreationLimitPolicy? = null
        /**
         * Instructions for how to launch and maintain server processes on instances in the
         * fleet. The runtime configuration defines one or more server process configurations, each
         * identifying a build executable or Realtime script file and the number of processes of
         * that type to run concurrently.
         *
         * The RuntimeConfiguration parameter is required unless the fleet is
         * being configured using the older parameters ServerLaunchPath and
         * ServerLaunchParameters, which are still supported for backward
         * compatibility.
         */
        var runtimeConfiguration: aws.sdk.kotlin.services.gamelift.model.RuntimeConfiguration? = null
        /**
         * The unique identifier for a Realtime configuration script to be deployed on fleet
         * instances. You can use either the script ID or ARN. Scripts must be uploaded to GameLift
         * prior to creating the fleet. This fleet property cannot be changed later.
         */
        var scriptId: kotlin.String? = null
        /**
         * This parameter is no longer used. Specify server
         * launch parameters using the RuntimeConfiguration parameter. Requests that
         * use this parameter instead continue to be valid.
         */
        var serverLaunchParameters: kotlin.String? = null
        /**
         * This parameter is no longer used. Specify a server
         * launch path using the RuntimeConfiguration parameter. Requests that use
         * this parameter instead continue to be valid.
         */
        var serverLaunchPath: kotlin.String? = null
        /**
         * A list of labels to assign to the new fleet resource. Tags are developer-defined
         * key-value pairs. Tagging AWS resources are useful for resource management, access
         * management and cost allocation. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html"> Tagging AWS Resources in the
         * AWS General Reference. Once the fleet is created, you can use
         * TagResource, UntagResource, and ListTagsForResource to add, remove, and view tags. The maximum tag limit
         * may be lower than stated. See the AWS General Reference for actual
         * tagging limits.
         */
        var tags: List<Tag>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.gamelift.model.CreateFleetRequest) : this() {
            this.buildId = x.buildId
            this.certificateConfiguration = x.certificateConfiguration
            this.description = x.description
            this.ec2InboundPermissions = x.ec2InboundPermissions
            this.ec2InstanceType = x.ec2InstanceType
            this.fleetType = x.fleetType
            this.instanceRoleArn = x.instanceRoleArn
            this.locations = x.locations
            this.logPaths = x.logPaths
            this.metricGroups = x.metricGroups
            this.name = x.name
            this.newGameSessionProtectionPolicy = x.newGameSessionProtectionPolicy
            this.peerVpcAwsAccountId = x.peerVpcAwsAccountId
            this.peerVpcId = x.peerVpcId
            this.resourceCreationLimitPolicy = x.resourceCreationLimitPolicy
            this.runtimeConfiguration = x.runtimeConfiguration
            this.scriptId = x.scriptId
            this.serverLaunchParameters = x.serverLaunchParameters
            this.serverLaunchPath = x.serverLaunchPath
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.gamelift.model.CreateFleetRequest = CreateFleetRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.gamelift.model.CertificateConfiguration] inside the given [block]
         */
        fun certificateConfiguration(block: aws.sdk.kotlin.services.gamelift.model.CertificateConfiguration.Builder.() -> kotlin.Unit) {
            this.certificateConfiguration = aws.sdk.kotlin.services.gamelift.model.CertificateConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.gamelift.model.ResourceCreationLimitPolicy] inside the given [block]
         */
        fun resourceCreationLimitPolicy(block: aws.sdk.kotlin.services.gamelift.model.ResourceCreationLimitPolicy.Builder.() -> kotlin.Unit) {
            this.resourceCreationLimitPolicy = aws.sdk.kotlin.services.gamelift.model.ResourceCreationLimitPolicy.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.gamelift.model.RuntimeConfiguration] inside the given [block]
         */
        fun runtimeConfiguration(block: aws.sdk.kotlin.services.gamelift.model.RuntimeConfiguration.Builder.() -> kotlin.Unit) {
            this.runtimeConfiguration = aws.sdk.kotlin.services.gamelift.model.RuntimeConfiguration.invoke(block)
        }
    }
}
