// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.gamelift.model



/**
 * Represents the input for a request operation.
 */
class CreateGameSessionRequest private constructor(builder: Builder) {
    /**
     * A unique identifier for the alias associated with the fleet to create a game session in. You can use either the
     * alias ID or ARN value. Each request must reference either a fleet ID or alias ID, but
     * not both.
     */
    val aliasId: kotlin.String? = builder.aliasId
    /**
     * A unique identifier for a player or entity creating the game session. This parameter is required when
     * requesting a new game session on a fleet with a resource creation limit policy. This
     * type of policy limits the number of concurrent active game sessions that one player can
     * create within a certain time span. GameLift uses the CreatorId to evaluate the new
     * request against the policy.
     */
    val creatorId: kotlin.String? = builder.creatorId
    /**
     * A unique identifier for the fleet to create a game session in. You can use either the fleet ID or ARN value. Each
     * request must reference either a fleet ID or alias ID, but not both.
     */
    val fleetId: kotlin.String? = builder.fleetId
    /**
     * A set of custom properties for a game session, formatted as key:value pairs. These properties are passed to a game server process in the
     * GameSession object with a request to start a new game session.
     */
    val gameProperties: List<GameProperty>? = builder.gameProperties
    /**
     * A set of custom game session properties, formatted as a single string value. This data is passed to a game server process in the
     * GameSession object with a request to start a new game session.
     */
    val gameSessionData: kotlin.String? = builder.gameSessionData
    /**
     * This parameter is no longer preferred. Please use
     * IdempotencyToken instead. Custom string that uniquely
     * identifies a request for a new game session. Maximum token length is 48 characters. If
     * provided, this string is included in the new game session's ID.
     */
    val gameSessionId: kotlin.String? = builder.gameSessionId
    /**
     * Custom string that uniquely identifies the new game session request.  This is useful
     * for ensuring that game session requests with the same idempotency token are processed
     * only once. Subsequent requests with the same string return the original
     * GameSession object, with an updated status. Maximum token length is 48
     * characters. If provided, this string is included in the new game session's ID.
     * A game session ARN has the following format:
     * arn:aws:gamelift:<region>::gamesession/<fleet ID>/<custom ID string or idempotency token>. Idempotency tokens remain in use for 30 days after a game session has ended;
     * game session objects are retained for this time period and then deleted.
     */
    val idempotencyToken: kotlin.String? = builder.idempotencyToken
    /**
     * A fleet's remote location to place the new game session in. If this parameter is not
     * set, the new game session is placed in the fleet's home Region. Specify a remote
     * location with an AWS Region code such as us-west-2.
     */
    val location: kotlin.String? = builder.location
    /**
     * The maximum number of players that can be connected simultaneously to the game session.
     */
    val maximumPlayerSessionCount: kotlin.Int? = builder.maximumPlayerSessionCount
    /**
     * A descriptive label that is associated with a game session. Session names do not need to be unique.
     */
    val name: kotlin.String? = builder.name

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.gamelift.model.CreateGameSessionRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateGameSessionRequest(")
        append("aliasId=$aliasId,")
        append("creatorId=$creatorId,")
        append("fleetId=$fleetId,")
        append("gameProperties=$gameProperties,")
        append("gameSessionData=$gameSessionData,")
        append("gameSessionId=$gameSessionId,")
        append("idempotencyToken=$idempotencyToken,")
        append("location=$location,")
        append("maximumPlayerSessionCount=$maximumPlayerSessionCount,")
        append("name=$name)")
    }

    override fun hashCode(): kotlin.Int {
        var result = aliasId?.hashCode() ?: 0
        result = 31 * result + (creatorId?.hashCode() ?: 0)
        result = 31 * result + (fleetId?.hashCode() ?: 0)
        result = 31 * result + (gameProperties?.hashCode() ?: 0)
        result = 31 * result + (gameSessionData?.hashCode() ?: 0)
        result = 31 * result + (gameSessionId?.hashCode() ?: 0)
        result = 31 * result + (idempotencyToken?.hashCode() ?: 0)
        result = 31 * result + (location?.hashCode() ?: 0)
        result = 31 * result + (maximumPlayerSessionCount ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateGameSessionRequest

        if (aliasId != other.aliasId) return false
        if (creatorId != other.creatorId) return false
        if (fleetId != other.fleetId) return false
        if (gameProperties != other.gameProperties) return false
        if (gameSessionData != other.gameSessionData) return false
        if (gameSessionId != other.gameSessionId) return false
        if (idempotencyToken != other.idempotencyToken) return false
        if (location != other.location) return false
        if (maximumPlayerSessionCount != other.maximumPlayerSessionCount) return false
        if (name != other.name) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.gamelift.model.CreateGameSessionRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * A unique identifier for the alias associated with the fleet to create a game session in. You can use either the
         * alias ID or ARN value. Each request must reference either a fleet ID or alias ID, but
         * not both.
         */
        var aliasId: kotlin.String? = null
        /**
         * A unique identifier for a player or entity creating the game session. This parameter is required when
         * requesting a new game session on a fleet with a resource creation limit policy. This
         * type of policy limits the number of concurrent active game sessions that one player can
         * create within a certain time span. GameLift uses the CreatorId to evaluate the new
         * request against the policy.
         */
        var creatorId: kotlin.String? = null
        /**
         * A unique identifier for the fleet to create a game session in. You can use either the fleet ID or ARN value. Each
         * request must reference either a fleet ID or alias ID, but not both.
         */
        var fleetId: kotlin.String? = null
        /**
         * A set of custom properties for a game session, formatted as key:value pairs. These properties are passed to a game server process in the
         * GameSession object with a request to start a new game session.
         */
        var gameProperties: List<GameProperty>? = null
        /**
         * A set of custom game session properties, formatted as a single string value. This data is passed to a game server process in the
         * GameSession object with a request to start a new game session.
         */
        var gameSessionData: kotlin.String? = null
        /**
         * This parameter is no longer preferred. Please use
         * IdempotencyToken instead. Custom string that uniquely
         * identifies a request for a new game session. Maximum token length is 48 characters. If
         * provided, this string is included in the new game session's ID.
         */
        var gameSessionId: kotlin.String? = null
        /**
         * Custom string that uniquely identifies the new game session request.  This is useful
         * for ensuring that game session requests with the same idempotency token are processed
         * only once. Subsequent requests with the same string return the original
         * GameSession object, with an updated status. Maximum token length is 48
         * characters. If provided, this string is included in the new game session's ID.
         * A game session ARN has the following format:
         * arn:aws:gamelift:<region>::gamesession/<fleet ID>/<custom ID string or idempotency token>. Idempotency tokens remain in use for 30 days after a game session has ended;
         * game session objects are retained for this time period and then deleted.
         */
        var idempotencyToken: kotlin.String? = null
        /**
         * A fleet's remote location to place the new game session in. If this parameter is not
         * set, the new game session is placed in the fleet's home Region. Specify a remote
         * location with an AWS Region code such as us-west-2.
         */
        var location: kotlin.String? = null
        /**
         * The maximum number of players that can be connected simultaneously to the game session.
         */
        var maximumPlayerSessionCount: kotlin.Int? = null
        /**
         * A descriptive label that is associated with a game session. Session names do not need to be unique.
         */
        var name: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.gamelift.model.CreateGameSessionRequest) : this() {
            this.aliasId = x.aliasId
            this.creatorId = x.creatorId
            this.fleetId = x.fleetId
            this.gameProperties = x.gameProperties
            this.gameSessionData = x.gameSessionData
            this.gameSessionId = x.gameSessionId
            this.idempotencyToken = x.idempotencyToken
            this.location = x.location
            this.maximumPlayerSessionCount = x.maximumPlayerSessionCount
            this.name = x.name
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.gamelift.model.CreateGameSessionRequest = CreateGameSessionRequest(this)
    }
}
