// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.gamelift.model



/**
 * Represents the input for a request operation.
 */
class CreateMatchmakingConfigurationRequest private constructor(builder: Builder) {
    /**
     * A flag that determines whether a match that was created with this configuration must
     * be accepted by the matched players. To require acceptance, set to TRUE.
     * With this option enabled, matchmaking tickets use the status
     * REQUIRES_ACCEPTANCE to indicate when a completed potential match is
     * waiting for player acceptance.
     */
    val acceptanceRequired: kotlin.Boolean? = builder.acceptanceRequired
    /**
     * The length of time (in seconds) to wait for players to accept a proposed match, if
     * acceptance is required.
     */
    val acceptanceTimeoutSeconds: kotlin.Int? = builder.acceptanceTimeoutSeconds
    /**
     * The number of player slots in a match to keep open for future players. For example, if the configuration's rule set specifies
     * a match for a single 12-person team, and the additional player count is set to 2, only 10 players are selected for the match. This parameter is not used if FlexMatchMode is set to
     * STANDALONE.
     */
    val additionalPlayerCount: kotlin.Int? = builder.additionalPlayerCount
    /**
     * The method used to backfill game sessions that are created with this matchmaking
     * configuration. Specify MANUAL when your game manages backfill requests
     * manually or does not use the match backfill feature. Specify AUTOMATIC to
     * have GameLift create a StartMatchBackfill request whenever a game
     * session has one or more open slots. Learn more about manual and automatic backfill in
     * <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-backfill.html"> Backfill Existing Games with FlexMatch. Automatic backfill is not
     * available when FlexMatchMode is set to STANDALONE.
     */
    val backfillMode: aws.sdk.kotlin.services.gamelift.model.BackfillMode? = builder.backfillMode
    /**
     * Information to be added to all events related to this matchmaking configuration.
     */
    val customEventData: kotlin.String? = builder.customEventData
    /**
     * A human-readable description of the matchmaking configuration.
     */
    val description: kotlin.String? = builder.description
    /**
     * Indicates whether this matchmaking configuration is being used with GameLift hosting or
     * as a standalone matchmaking solution.
     *
     *
     *
     * STANDALONE - FlexMatch forms matches and returns
     * match information, including players and team assignments, in a
     * <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-events.html#match-events-matchmakingsucceeded">
     * MatchmakingSucceeded event.
     *
     *
     * WITH_QUEUE - FlexMatch forms matches and uses the specified GameLift queue to
     * start a game session for the match.
     */
    val flexMatchMode: aws.sdk.kotlin.services.gamelift.model.FlexMatchMode? = builder.flexMatchMode
    /**
     * A set of custom properties for a game session, formatted as key:value pairs. These properties are passed to a game server process in the
     * GameSession object with a request to start a new game session (see <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession">Start a Game Session). This information is added to the new GameSession
     * object that is created for a successful match. This parameter is not used if
     * FlexMatchMode is set to STANDALONE.
     */
    val gameProperties: List<GameProperty>? = builder.gameProperties
    /**
     * A set of custom game session properties, formatted as a single string value. This data is passed to a game server process in the
     * GameSession object with a request to start a new game session (see <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession">Start a Game Session). This information is added to the new GameSession object
     * that is created for a successful match. This parameter is not used if
     * FlexMatchMode is set to STANDALONE.
     */
    val gameSessionData: kotlin.String? = builder.gameSessionData
    /**
     * The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN) that is assigned to a GameLift game session queue resource and uniquely identifies it. ARNs are unique across all Regions. Format is arn:aws:gamelift:<region>::gamesessionqueue/<queue name>. Queues can be located in any Region. Queues are used to start new
     * GameLift-hosted game sessions for matches that are created with this matchmaking
     * configuration. If FlexMatchMode is set to STANDALONE, do not
     * set this parameter.
     */
    val gameSessionQueueArns: List<String>? = builder.gameSessionQueueArns
    /**
     * A unique identifier for the matchmaking configuration. This name is used to identify the configuration associated with a
     * matchmaking request or ticket.
     */
    val name: kotlin.String? = builder.name
    /**
     * An SNS topic ARN that is set up to receive matchmaking notifications. See <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-notification.html">
     * Setting up notifications for matchmaking for more information.
     */
    val notificationTarget: kotlin.String? = builder.notificationTarget
    /**
     * The maximum duration, in seconds, that a matchmaking ticket can remain in process
     * before timing out. Requests that fail due to timing out can be resubmitted as
     * needed.
     */
    val requestTimeoutSeconds: kotlin.Int? = builder.requestTimeoutSeconds
    /**
     * A unique identifier for the matchmaking rule set to use with this configuration. You can use either the rule set name or ARN
     * value. A matchmaking configuration can only use rule sets that are defined in the same
     * Region.
     */
    val ruleSetName: kotlin.String? = builder.ruleSetName
    /**
     * A list of labels to assign to the new matchmaking configuration resource. Tags are developer-defined
     * key-value pairs. Tagging
     * AWS resources are useful for resource management, access management and cost allocation.
     * For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html"> Tagging AWS Resources in the
     * AWS General Reference. Once the resource is created, you can
     * use TagResource, UntagResource, and
     * ListTagsForResource to add, remove, and view tags. The
     * maximum tag limit may be lower than stated. See the AWS General Reference for actual
     * tagging limits.
     */
    val tags: List<Tag>? = builder.tags

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.gamelift.model.CreateMatchmakingConfigurationRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateMatchmakingConfigurationRequest(")
        append("acceptanceRequired=$acceptanceRequired,")
        append("acceptanceTimeoutSeconds=$acceptanceTimeoutSeconds,")
        append("additionalPlayerCount=$additionalPlayerCount,")
        append("backfillMode=$backfillMode,")
        append("customEventData=$customEventData,")
        append("description=$description,")
        append("flexMatchMode=$flexMatchMode,")
        append("gameProperties=$gameProperties,")
        append("gameSessionData=$gameSessionData,")
        append("gameSessionQueueArns=$gameSessionQueueArns,")
        append("name=$name,")
        append("notificationTarget=$notificationTarget,")
        append("requestTimeoutSeconds=$requestTimeoutSeconds,")
        append("ruleSetName=$ruleSetName,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = acceptanceRequired?.hashCode() ?: 0
        result = 31 * result + (acceptanceTimeoutSeconds ?: 0)
        result = 31 * result + (additionalPlayerCount ?: 0)
        result = 31 * result + (backfillMode?.hashCode() ?: 0)
        result = 31 * result + (customEventData?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (flexMatchMode?.hashCode() ?: 0)
        result = 31 * result + (gameProperties?.hashCode() ?: 0)
        result = 31 * result + (gameSessionData?.hashCode() ?: 0)
        result = 31 * result + (gameSessionQueueArns?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (notificationTarget?.hashCode() ?: 0)
        result = 31 * result + (requestTimeoutSeconds ?: 0)
        result = 31 * result + (ruleSetName?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateMatchmakingConfigurationRequest

        if (acceptanceRequired != other.acceptanceRequired) return false
        if (acceptanceTimeoutSeconds != other.acceptanceTimeoutSeconds) return false
        if (additionalPlayerCount != other.additionalPlayerCount) return false
        if (backfillMode != other.backfillMode) return false
        if (customEventData != other.customEventData) return false
        if (description != other.description) return false
        if (flexMatchMode != other.flexMatchMode) return false
        if (gameProperties != other.gameProperties) return false
        if (gameSessionData != other.gameSessionData) return false
        if (gameSessionQueueArns != other.gameSessionQueueArns) return false
        if (name != other.name) return false
        if (notificationTarget != other.notificationTarget) return false
        if (requestTimeoutSeconds != other.requestTimeoutSeconds) return false
        if (ruleSetName != other.ruleSetName) return false
        if (tags != other.tags) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.gamelift.model.CreateMatchmakingConfigurationRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * A flag that determines whether a match that was created with this configuration must
         * be accepted by the matched players. To require acceptance, set to TRUE.
         * With this option enabled, matchmaking tickets use the status
         * REQUIRES_ACCEPTANCE to indicate when a completed potential match is
         * waiting for player acceptance.
         */
        var acceptanceRequired: kotlin.Boolean? = null
        /**
         * The length of time (in seconds) to wait for players to accept a proposed match, if
         * acceptance is required.
         */
        var acceptanceTimeoutSeconds: kotlin.Int? = null
        /**
         * The number of player slots in a match to keep open for future players. For example, if the configuration's rule set specifies
         * a match for a single 12-person team, and the additional player count is set to 2, only 10 players are selected for the match. This parameter is not used if FlexMatchMode is set to
         * STANDALONE.
         */
        var additionalPlayerCount: kotlin.Int? = null
        /**
         * The method used to backfill game sessions that are created with this matchmaking
         * configuration. Specify MANUAL when your game manages backfill requests
         * manually or does not use the match backfill feature. Specify AUTOMATIC to
         * have GameLift create a StartMatchBackfill request whenever a game
         * session has one or more open slots. Learn more about manual and automatic backfill in
         * <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-backfill.html"> Backfill Existing Games with FlexMatch. Automatic backfill is not
         * available when FlexMatchMode is set to STANDALONE.
         */
        var backfillMode: aws.sdk.kotlin.services.gamelift.model.BackfillMode? = null
        /**
         * Information to be added to all events related to this matchmaking configuration.
         */
        var customEventData: kotlin.String? = null
        /**
         * A human-readable description of the matchmaking configuration.
         */
        var description: kotlin.String? = null
        /**
         * Indicates whether this matchmaking configuration is being used with GameLift hosting or
         * as a standalone matchmaking solution.
         *
         *
         *
         * STANDALONE - FlexMatch forms matches and returns
         * match information, including players and team assignments, in a
         * <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-events.html#match-events-matchmakingsucceeded">
         * MatchmakingSucceeded event.
         *
         *
         * WITH_QUEUE - FlexMatch forms matches and uses the specified GameLift queue to
         * start a game session for the match.
         */
        var flexMatchMode: aws.sdk.kotlin.services.gamelift.model.FlexMatchMode? = null
        /**
         * A set of custom properties for a game session, formatted as key:value pairs. These properties are passed to a game server process in the
         * GameSession object with a request to start a new game session (see <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession">Start a Game Session). This information is added to the new GameSession
         * object that is created for a successful match. This parameter is not used if
         * FlexMatchMode is set to STANDALONE.
         */
        var gameProperties: List<GameProperty>? = null
        /**
         * A set of custom game session properties, formatted as a single string value. This data is passed to a game server process in the
         * GameSession object with a request to start a new game session (see <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession">Start a Game Session). This information is added to the new GameSession object
         * that is created for a successful match. This parameter is not used if
         * FlexMatchMode is set to STANDALONE.
         */
        var gameSessionData: kotlin.String? = null
        /**
         * The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN) that is assigned to a GameLift game session queue resource and uniquely identifies it. ARNs are unique across all Regions. Format is arn:aws:gamelift:<region>::gamesessionqueue/<queue name>. Queues can be located in any Region. Queues are used to start new
         * GameLift-hosted game sessions for matches that are created with this matchmaking
         * configuration. If FlexMatchMode is set to STANDALONE, do not
         * set this parameter.
         */
        var gameSessionQueueArns: List<String>? = null
        /**
         * A unique identifier for the matchmaking configuration. This name is used to identify the configuration associated with a
         * matchmaking request or ticket.
         */
        var name: kotlin.String? = null
        /**
         * An SNS topic ARN that is set up to receive matchmaking notifications. See <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-notification.html">
         * Setting up notifications for matchmaking for more information.
         */
        var notificationTarget: kotlin.String? = null
        /**
         * The maximum duration, in seconds, that a matchmaking ticket can remain in process
         * before timing out. Requests that fail due to timing out can be resubmitted as
         * needed.
         */
        var requestTimeoutSeconds: kotlin.Int? = null
        /**
         * A unique identifier for the matchmaking rule set to use with this configuration. You can use either the rule set name or ARN
         * value. A matchmaking configuration can only use rule sets that are defined in the same
         * Region.
         */
        var ruleSetName: kotlin.String? = null
        /**
         * A list of labels to assign to the new matchmaking configuration resource. Tags are developer-defined
         * key-value pairs. Tagging
         * AWS resources are useful for resource management, access management and cost allocation.
         * For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html"> Tagging AWS Resources in the
         * AWS General Reference. Once the resource is created, you can
         * use TagResource, UntagResource, and
         * ListTagsForResource to add, remove, and view tags. The
         * maximum tag limit may be lower than stated. See the AWS General Reference for actual
         * tagging limits.
         */
        var tags: List<Tag>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.gamelift.model.CreateMatchmakingConfigurationRequest) : this() {
            this.acceptanceRequired = x.acceptanceRequired
            this.acceptanceTimeoutSeconds = x.acceptanceTimeoutSeconds
            this.additionalPlayerCount = x.additionalPlayerCount
            this.backfillMode = x.backfillMode
            this.customEventData = x.customEventData
            this.description = x.description
            this.flexMatchMode = x.flexMatchMode
            this.gameProperties = x.gameProperties
            this.gameSessionData = x.gameSessionData
            this.gameSessionQueueArns = x.gameSessionQueueArns
            this.name = x.name
            this.notificationTarget = x.notificationTarget
            this.requestTimeoutSeconds = x.requestTimeoutSeconds
            this.ruleSetName = x.ruleSetName
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.gamelift.model.CreateMatchmakingConfigurationRequest = CreateMatchmakingConfigurationRequest(this)
    }
}
