// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.gamelift.model



/**
 * Represents the input for a request operation.
 */
class CreateVpcPeeringConnectionRequest private constructor(builder: Builder) {
    /**
     * A unique identifier for the fleet. You can use either the fleet ID or ARN value. This tells Amazon GameLift which GameLift
     * VPC to peer with.
     */
    val fleetId: kotlin.String? = builder.fleetId
    /**
     * A unique identifier for the AWS account with the VPC that you want to peer your
     * Amazon GameLift fleet with. You can find your Account ID in the AWS Management Console under account
     * settings.
     */
    val peerVpcAwsAccountId: kotlin.String? = builder.peerVpcAwsAccountId
    /**
     * A unique identifier for a VPC with resources to be accessed by your GameLift fleet. The
     * VPC must be in the same Region as your fleet. To look up a VPC ID, use the
     * <a href="https://console.aws.amazon.com/vpc/">VPC Dashboard in the AWS Management Console.
     * Learn more about VPC peering in <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/vpc-peering.html">VPC Peering with GameLift Fleets.
     */
    val peerVpcId: kotlin.String? = builder.peerVpcId

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.gamelift.model.CreateVpcPeeringConnectionRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateVpcPeeringConnectionRequest(")
        append("fleetId=$fleetId,")
        append("peerVpcAwsAccountId=$peerVpcAwsAccountId,")
        append("peerVpcId=$peerVpcId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = fleetId?.hashCode() ?: 0
        result = 31 * result + (peerVpcAwsAccountId?.hashCode() ?: 0)
        result = 31 * result + (peerVpcId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateVpcPeeringConnectionRequest

        if (fleetId != other.fleetId) return false
        if (peerVpcAwsAccountId != other.peerVpcAwsAccountId) return false
        if (peerVpcId != other.peerVpcId) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.gamelift.model.CreateVpcPeeringConnectionRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * A unique identifier for the fleet. You can use either the fleet ID or ARN value. This tells Amazon GameLift which GameLift
         * VPC to peer with.
         */
        var fleetId: kotlin.String? = null
        /**
         * A unique identifier for the AWS account with the VPC that you want to peer your
         * Amazon GameLift fleet with. You can find your Account ID in the AWS Management Console under account
         * settings.
         */
        var peerVpcAwsAccountId: kotlin.String? = null
        /**
         * A unique identifier for a VPC with resources to be accessed by your GameLift fleet. The
         * VPC must be in the same Region as your fleet. To look up a VPC ID, use the
         * <a href="https://console.aws.amazon.com/vpc/">VPC Dashboard in the AWS Management Console.
         * Learn more about VPC peering in <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/vpc-peering.html">VPC Peering with GameLift Fleets.
         */
        var peerVpcId: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.gamelift.model.CreateVpcPeeringConnectionRequest) : this() {
            this.fleetId = x.fleetId
            this.peerVpcAwsAccountId = x.peerVpcAwsAccountId
            this.peerVpcId = x.peerVpcId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.gamelift.model.CreateVpcPeeringConnectionRequest = CreateVpcPeeringConnectionRequest(this)
    }
}
