// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.gamelift.model



/**
 * Represents the input for a request operation.
 */
class DescribeFleetAttributesRequest private constructor(builder: Builder) {
    /**
     * A list of unique fleet identifiers to retrieve attributes for. You can use either the
     * fleet ID or ARN value. To retrieve attributes for all current fleets, do not include
     * this parameter.
     */
    val fleetIds: List<String>? = builder.fleetIds
    /**
     * The maximum number of results to return. Use this parameter with NextToken to get results as a set of sequential pages. This parameter is ignored when the request specifies one or a list of fleet
     * IDs.
     */
    val limit: kotlin.Int? = builder.limit
    /**
     * A token that indicates the start of the next sequential page of results. Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value. This parameter is ignored when the request specifies one or a list of fleet
     * IDs.
     */
    val nextToken: kotlin.String? = builder.nextToken

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.gamelift.model.DescribeFleetAttributesRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeFleetAttributesRequest(")
        append("fleetIds=$fleetIds,")
        append("limit=$limit,")
        append("nextToken=$nextToken)")
    }

    override fun hashCode(): kotlin.Int {
        var result = fleetIds?.hashCode() ?: 0
        result = 31 * result + (limit ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeFleetAttributesRequest

        if (fleetIds != other.fleetIds) return false
        if (limit != other.limit) return false
        if (nextToken != other.nextToken) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.gamelift.model.DescribeFleetAttributesRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * A list of unique fleet identifiers to retrieve attributes for. You can use either the
         * fleet ID or ARN value. To retrieve attributes for all current fleets, do not include
         * this parameter.
         */
        var fleetIds: List<String>? = null
        /**
         * The maximum number of results to return. Use this parameter with NextToken to get results as a set of sequential pages. This parameter is ignored when the request specifies one or a list of fleet
         * IDs.
         */
        var limit: kotlin.Int? = null
        /**
         * A token that indicates the start of the next sequential page of results. Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value. This parameter is ignored when the request specifies one or a list of fleet
         * IDs.
         */
        var nextToken: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.gamelift.model.DescribeFleetAttributesRequest) : this() {
            this.fleetIds = x.fleetIds
            this.limit = x.limit
            this.nextToken = x.nextToken
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.gamelift.model.DescribeFleetAttributesRequest = DescribeFleetAttributesRequest(this)
    }
}
