// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.gamelift.model



/**
 * Represents the input for a request operation.
 */
class DescribeFleetLocationAttributesRequest private constructor(builder: Builder) {
    /**
     * A unique identifier for the fleet to retrieve remote locations for. You can use either the fleet ID or ARN
     * value.
     */
    val fleetId: kotlin.String? = builder.fleetId
    /**
     * The maximum number of results to return. Use this parameter with NextToken to get results as a set of sequential pages. This limit is not currently enforced.
     */
    val limit: kotlin.Int? = builder.limit
    /**
     * A list of fleet locations to retrieve information for. Specify locations in the form of an AWS Region code, such as
     * us-west-2.
     */
    val locations: List<String>? = builder.locations
    /**
     * A token that indicates the start of the next sequential page of results. Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value.
     */
    val nextToken: kotlin.String? = builder.nextToken

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.gamelift.model.DescribeFleetLocationAttributesRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeFleetLocationAttributesRequest(")
        append("fleetId=$fleetId,")
        append("limit=$limit,")
        append("locations=$locations,")
        append("nextToken=$nextToken)")
    }

    override fun hashCode(): kotlin.Int {
        var result = fleetId?.hashCode() ?: 0
        result = 31 * result + (limit ?: 0)
        result = 31 * result + (locations?.hashCode() ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeFleetLocationAttributesRequest

        if (fleetId != other.fleetId) return false
        if (limit != other.limit) return false
        if (locations != other.locations) return false
        if (nextToken != other.nextToken) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.gamelift.model.DescribeFleetLocationAttributesRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * A unique identifier for the fleet to retrieve remote locations for. You can use either the fleet ID or ARN
         * value.
         */
        var fleetId: kotlin.String? = null
        /**
         * The maximum number of results to return. Use this parameter with NextToken to get results as a set of sequential pages. This limit is not currently enforced.
         */
        var limit: kotlin.Int? = null
        /**
         * A list of fleet locations to retrieve information for. Specify locations in the form of an AWS Region code, such as
         * us-west-2.
         */
        var locations: List<String>? = null
        /**
         * A token that indicates the start of the next sequential page of results. Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value.
         */
        var nextToken: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.gamelift.model.DescribeFleetLocationAttributesRequest) : this() {
            this.fleetId = x.fleetId
            this.limit = x.limit
            this.locations = x.locations
            this.nextToken = x.nextToken
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.gamelift.model.DescribeFleetLocationAttributesRequest = DescribeFleetLocationAttributesRequest(this)
    }
}
