// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.gamelift.model



/**
 * Represents the returned data in response to a request operation.
 */
class DescribeFleetLocationAttributesResponse private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN) that is assigned to a GameLift fleet resource and uniquely identifies it. ARNs are unique across all Regions. Format is arn:aws:gamelift:<region>::fleet/fleet-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912.
     */
    val fleetArn: kotlin.String? = builder.fleetArn
    /**
     * A unique identifier for the fleet that location attributes were requested for.
     */
    val fleetId: kotlin.String? = builder.fleetId
    /**
     * Location-specific information on the requested fleet's remote locations.
     */
    val locationAttributes: List<LocationAttributes>? = builder.locationAttributes
    /**
     * A token that indicates where to resume retrieving results on the next call to this operation. If no token is returned, these results represent the end of the list.
     */
    val nextToken: kotlin.String? = builder.nextToken

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.gamelift.model.DescribeFleetLocationAttributesResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeFleetLocationAttributesResponse(")
        append("fleetArn=$fleetArn,")
        append("fleetId=$fleetId,")
        append("locationAttributes=$locationAttributes,")
        append("nextToken=$nextToken)")
    }

    override fun hashCode(): kotlin.Int {
        var result = fleetArn?.hashCode() ?: 0
        result = 31 * result + (fleetId?.hashCode() ?: 0)
        result = 31 * result + (locationAttributes?.hashCode() ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeFleetLocationAttributesResponse

        if (fleetArn != other.fleetArn) return false
        if (fleetId != other.fleetId) return false
        if (locationAttributes != other.locationAttributes) return false
        if (nextToken != other.nextToken) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.gamelift.model.DescribeFleetLocationAttributesResponse = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN) that is assigned to a GameLift fleet resource and uniquely identifies it. ARNs are unique across all Regions. Format is arn:aws:gamelift:<region>::fleet/fleet-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912.
         */
        var fleetArn: kotlin.String? = null
        /**
         * A unique identifier for the fleet that location attributes were requested for.
         */
        var fleetId: kotlin.String? = null
        /**
         * Location-specific information on the requested fleet's remote locations.
         */
        var locationAttributes: List<LocationAttributes>? = null
        /**
         * A token that indicates where to resume retrieving results on the next call to this operation. If no token is returned, these results represent the end of the list.
         */
        var nextToken: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.gamelift.model.DescribeFleetLocationAttributesResponse) : this() {
            this.fleetArn = x.fleetArn
            this.fleetId = x.fleetId
            this.locationAttributes = x.locationAttributes
            this.nextToken = x.nextToken
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.gamelift.model.DescribeFleetLocationAttributesResponse = DescribeFleetLocationAttributesResponse(this)
    }
}
