// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.gamelift.model



/**
 * Represents the input for a request operation.
 */
class DescribeGameSessionDetailsRequest private constructor(builder: Builder) {
    /**
     * A unique identifier for the alias associated with the fleet to retrieve all game sessions for. You can use either
     * the alias ID or ARN value.
     */
    val aliasId: kotlin.String? = builder.aliasId
    /**
     * A unique identifier for the fleet to retrieve all game sessions active on the fleet. You can use either the fleet
     * ID or ARN value.
     */
    val fleetId: kotlin.String? = builder.fleetId
    /**
     * A unique identifier for the game session to retrieve.
     */
    val gameSessionId: kotlin.String? = builder.gameSessionId
    /**
     * The maximum number of results to return. Use this parameter with NextToken to get results as a set of sequential pages.
     */
    val limit: kotlin.Int? = builder.limit
    /**
     * A fleet location to get game sessions for. You can specify a fleet's home Region or a
     * remote location. Use the AWS Region code format, such as us-west-2.
     */
    val location: kotlin.String? = builder.location
    /**
     * A token that indicates the start of the next sequential page of results. Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value.
     */
    val nextToken: kotlin.String? = builder.nextToken
    /**
     * Game session status to filter results on. Possible game session statuses include
     * ACTIVE, TERMINATED, ACTIVATING and
     * TERMINATING (the last two are transitory).
     */
    val statusFilter: kotlin.String? = builder.statusFilter

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.gamelift.model.DescribeGameSessionDetailsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeGameSessionDetailsRequest(")
        append("aliasId=$aliasId,")
        append("fleetId=$fleetId,")
        append("gameSessionId=$gameSessionId,")
        append("limit=$limit,")
        append("location=$location,")
        append("nextToken=$nextToken,")
        append("statusFilter=$statusFilter)")
    }

    override fun hashCode(): kotlin.Int {
        var result = aliasId?.hashCode() ?: 0
        result = 31 * result + (fleetId?.hashCode() ?: 0)
        result = 31 * result + (gameSessionId?.hashCode() ?: 0)
        result = 31 * result + (limit ?: 0)
        result = 31 * result + (location?.hashCode() ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (statusFilter?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeGameSessionDetailsRequest

        if (aliasId != other.aliasId) return false
        if (fleetId != other.fleetId) return false
        if (gameSessionId != other.gameSessionId) return false
        if (limit != other.limit) return false
        if (location != other.location) return false
        if (nextToken != other.nextToken) return false
        if (statusFilter != other.statusFilter) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.gamelift.model.DescribeGameSessionDetailsRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * A unique identifier for the alias associated with the fleet to retrieve all game sessions for. You can use either
         * the alias ID or ARN value.
         */
        var aliasId: kotlin.String? = null
        /**
         * A unique identifier for the fleet to retrieve all game sessions active on the fleet. You can use either the fleet
         * ID or ARN value.
         */
        var fleetId: kotlin.String? = null
        /**
         * A unique identifier for the game session to retrieve.
         */
        var gameSessionId: kotlin.String? = null
        /**
         * The maximum number of results to return. Use this parameter with NextToken to get results as a set of sequential pages.
         */
        var limit: kotlin.Int? = null
        /**
         * A fleet location to get game sessions for. You can specify a fleet's home Region or a
         * remote location. Use the AWS Region code format, such as us-west-2.
         */
        var location: kotlin.String? = null
        /**
         * A token that indicates the start of the next sequential page of results. Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value.
         */
        var nextToken: kotlin.String? = null
        /**
         * Game session status to filter results on. Possible game session statuses include
         * ACTIVE, TERMINATED, ACTIVATING and
         * TERMINATING (the last two are transitory).
         */
        var statusFilter: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.gamelift.model.DescribeGameSessionDetailsRequest) : this() {
            this.aliasId = x.aliasId
            this.fleetId = x.fleetId
            this.gameSessionId = x.gameSessionId
            this.limit = x.limit
            this.location = x.location
            this.nextToken = x.nextToken
            this.statusFilter = x.statusFilter
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.gamelift.model.DescribeGameSessionDetailsRequest = DescribeGameSessionDetailsRequest(this)
    }
}
