// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.gamelift.model



/**
 * Represents the input for a request operation.
 */
class DescribeInstancesRequest private constructor(builder: Builder) {
    /**
     * A unique identifier for the fleet to retrieve instance information for.  You can use either the fleet ID or ARN
     * value.
     */
    val fleetId: kotlin.String? = builder.fleetId
    /**
     * A unique identifier for an instance to retrieve. Specify an instance ID or leave
     * blank to retrieve all instances in the fleet.
     */
    val instanceId: kotlin.String? = builder.instanceId
    /**
     * The maximum number of results to return. Use this parameter with NextToken to get results as a set of sequential pages.
     */
    val limit: kotlin.Int? = builder.limit
    /**
     * The name of a location to retrieve instance information for, in the form of an AWS
     * Region code such as us-west-2.
     */
    val location: kotlin.String? = builder.location
    /**
     * A token that indicates the start of the next sequential page of results. Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value.
     */
    val nextToken: kotlin.String? = builder.nextToken

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.gamelift.model.DescribeInstancesRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeInstancesRequest(")
        append("fleetId=$fleetId,")
        append("instanceId=$instanceId,")
        append("limit=$limit,")
        append("location=$location,")
        append("nextToken=$nextToken)")
    }

    override fun hashCode(): kotlin.Int {
        var result = fleetId?.hashCode() ?: 0
        result = 31 * result + (instanceId?.hashCode() ?: 0)
        result = 31 * result + (limit ?: 0)
        result = 31 * result + (location?.hashCode() ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeInstancesRequest

        if (fleetId != other.fleetId) return false
        if (instanceId != other.instanceId) return false
        if (limit != other.limit) return false
        if (location != other.location) return false
        if (nextToken != other.nextToken) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.gamelift.model.DescribeInstancesRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * A unique identifier for the fleet to retrieve instance information for.  You can use either the fleet ID or ARN
         * value.
         */
        var fleetId: kotlin.String? = null
        /**
         * A unique identifier for an instance to retrieve. Specify an instance ID or leave
         * blank to retrieve all instances in the fleet.
         */
        var instanceId: kotlin.String? = null
        /**
         * The maximum number of results to return. Use this parameter with NextToken to get results as a set of sequential pages.
         */
        var limit: kotlin.Int? = null
        /**
         * The name of a location to retrieve instance information for, in the form of an AWS
         * Region code such as us-west-2.
         */
        var location: kotlin.String? = null
        /**
         * A token that indicates the start of the next sequential page of results. Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value.
         */
        var nextToken: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.gamelift.model.DescribeInstancesRequest) : this() {
            this.fleetId = x.fleetId
            this.instanceId = x.instanceId
            this.limit = x.limit
            this.location = x.location
            this.nextToken = x.nextToken
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.gamelift.model.DescribeInstancesRequest = DescribeInstancesRequest(this)
    }
}
