// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.gamelift.model



/**
 * Represents the input for a request operation.
 */
class DescribePlayerSessionsRequest private constructor(builder: Builder) {
    /**
     * A unique identifier for the game session to retrieve player sessions for.
     */
    val gameSessionId: kotlin.String? = builder.gameSessionId
    /**
     * The maximum number of results to return. Use this parameter with NextToken to get results as a set of sequential pages. If a player session ID is specified, this parameter is ignored.
     */
    val limit: kotlin.Int? = builder.limit
    /**
     * A token that indicates the start of the next sequential page of results. Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value. If a player session ID is specified, this parameter is ignored.
     */
    val nextToken: kotlin.String? = builder.nextToken
    /**
     * A unique identifier for a player to retrieve player sessions for.
     */
    val playerId: kotlin.String? = builder.playerId
    /**
     * A unique identifier for a player session to retrieve.
     */
    val playerSessionId: kotlin.String? = builder.playerSessionId
    /**
     * Player session status to filter results on.
     * Possible player session statuses include the following:
     *
     *
     *
     * RESERVED -- The player session request has been
     * received, but the player has not yet connected to the server process and/or been
     * validated.
     *
     *
     * ACTIVE -- The player has been validated by the
     * server process and is currently connected.
     *
     *
     * COMPLETED -- The player connection has been
     * dropped.
     *
     *
     * TIMEDOUT -- A player session request was
     * received, but the player did not connect and/or was not validated within the
     * timeout limit (60 seconds).
     */
    val playerSessionStatusFilter: kotlin.String? = builder.playerSessionStatusFilter

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.gamelift.model.DescribePlayerSessionsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribePlayerSessionsRequest(")
        append("gameSessionId=$gameSessionId,")
        append("limit=$limit,")
        append("nextToken=$nextToken,")
        append("playerId=$playerId,")
        append("playerSessionId=$playerSessionId,")
        append("playerSessionStatusFilter=$playerSessionStatusFilter)")
    }

    override fun hashCode(): kotlin.Int {
        var result = gameSessionId?.hashCode() ?: 0
        result = 31 * result + (limit ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (playerId?.hashCode() ?: 0)
        result = 31 * result + (playerSessionId?.hashCode() ?: 0)
        result = 31 * result + (playerSessionStatusFilter?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribePlayerSessionsRequest

        if (gameSessionId != other.gameSessionId) return false
        if (limit != other.limit) return false
        if (nextToken != other.nextToken) return false
        if (playerId != other.playerId) return false
        if (playerSessionId != other.playerSessionId) return false
        if (playerSessionStatusFilter != other.playerSessionStatusFilter) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.gamelift.model.DescribePlayerSessionsRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * A unique identifier for the game session to retrieve player sessions for.
         */
        var gameSessionId: kotlin.String? = null
        /**
         * The maximum number of results to return. Use this parameter with NextToken to get results as a set of sequential pages. If a player session ID is specified, this parameter is ignored.
         */
        var limit: kotlin.Int? = null
        /**
         * A token that indicates the start of the next sequential page of results. Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value. If a player session ID is specified, this parameter is ignored.
         */
        var nextToken: kotlin.String? = null
        /**
         * A unique identifier for a player to retrieve player sessions for.
         */
        var playerId: kotlin.String? = null
        /**
         * A unique identifier for a player session to retrieve.
         */
        var playerSessionId: kotlin.String? = null
        /**
         * Player session status to filter results on.
         * Possible player session statuses include the following:
         *
         *
         *
         * RESERVED -- The player session request has been
         * received, but the player has not yet connected to the server process and/or been
         * validated.
         *
         *
         * ACTIVE -- The player has been validated by the
         * server process and is currently connected.
         *
         *
         * COMPLETED -- The player connection has been
         * dropped.
         *
         *
         * TIMEDOUT -- A player session request was
         * received, but the player did not connect and/or was not validated within the
         * timeout limit (60 seconds).
         */
        var playerSessionStatusFilter: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.gamelift.model.DescribePlayerSessionsRequest) : this() {
            this.gameSessionId = x.gameSessionId
            this.limit = x.limit
            this.nextToken = x.nextToken
            this.playerId = x.playerId
            this.playerSessionId = x.playerSessionId
            this.playerSessionStatusFilter = x.playerSessionStatusFilter
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.gamelift.model.DescribePlayerSessionsRequest = DescribePlayerSessionsRequest(this)
    }
}
