// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.gamelift.model



/**
 * Resource capacity settings. Fleet capacity is measured in EC2 instances. Pending and
 * terminating counts are non-zero when the fleet capacity is adjusting to a scaling event
 * or if access to resources is temporarily affected.
 * EC2 instance counts are part of FleetCapacity.
 */
class Ec2InstanceCounts private constructor(builder: Builder) {
    /**
     * Actual number of instances that are ready to host game sessions.
     */
    val active: kotlin.Int? = builder.active
    /**
     * Ideal number of active instances. GameLift will always try to maintain the desired
     * number of instances. Capacity is scaled up or down by changing the desired instances.
     */
    val desired: kotlin.Int? = builder.desired
    /**
     * Number of active instances that are not currently hosting a game session.
     */
    val idle: kotlin.Int? = builder.idle
    /**
     * The maximum instance count value allowed.
     */
    val maximum: kotlin.Int? = builder.maximum
    /**
     * The minimum instance count value allowed.
     */
    val minimum: kotlin.Int? = builder.minimum
    /**
     * Number of instances that are starting but not yet active.
     */
    val pending: kotlin.Int? = builder.pending
    /**
     * Number of instances that are no longer active but haven't yet been terminated.
     */
    val terminating: kotlin.Int? = builder.terminating

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.gamelift.model.Ec2InstanceCounts = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Ec2InstanceCounts(")
        append("active=$active,")
        append("desired=$desired,")
        append("idle=$idle,")
        append("maximum=$maximum,")
        append("minimum=$minimum,")
        append("pending=$pending,")
        append("terminating=$terminating)")
    }

    override fun hashCode(): kotlin.Int {
        var result = active ?: 0
        result = 31 * result + (desired ?: 0)
        result = 31 * result + (idle ?: 0)
        result = 31 * result + (maximum ?: 0)
        result = 31 * result + (minimum ?: 0)
        result = 31 * result + (pending ?: 0)
        result = 31 * result + (terminating ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Ec2InstanceCounts

        if (active != other.active) return false
        if (desired != other.desired) return false
        if (idle != other.idle) return false
        if (maximum != other.maximum) return false
        if (minimum != other.minimum) return false
        if (pending != other.pending) return false
        if (terminating != other.terminating) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.gamelift.model.Ec2InstanceCounts = Builder(this).apply(block).build()

    class Builder {
        /**
         * Actual number of instances that are ready to host game sessions.
         */
        var active: kotlin.Int? = null
        /**
         * Ideal number of active instances. GameLift will always try to maintain the desired
         * number of instances. Capacity is scaled up or down by changing the desired instances.
         */
        var desired: kotlin.Int? = null
        /**
         * Number of active instances that are not currently hosting a game session.
         */
        var idle: kotlin.Int? = null
        /**
         * The maximum instance count value allowed.
         */
        var maximum: kotlin.Int? = null
        /**
         * The minimum instance count value allowed.
         */
        var minimum: kotlin.Int? = null
        /**
         * Number of instances that are starting but not yet active.
         */
        var pending: kotlin.Int? = null
        /**
         * Number of instances that are no longer active but haven't yet been terminated.
         */
        var terminating: kotlin.Int? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.gamelift.model.Ec2InstanceCounts) : this() {
            this.active = x.active
            this.desired = x.desired
            this.idle = x.idle
            this.maximum = x.maximum
            this.minimum = x.minimum
            this.pending = x.pending
            this.terminating = x.terminating
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.gamelift.model.Ec2InstanceCounts = Ec2InstanceCounts(this)
    }
}
