// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.gamelift.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Log entry describing an event that involves GameLift resources (such as a fleet). In
 * addition to tracking activity, event codes and messages can provide additional
 * information for troubleshooting and debugging problems.
 *
 * Related actions
 *
 *
 * DescribeFleetEvents
 */
class Event private constructor(builder: Builder) {
    /**
     * The type of event being logged.
     *
     * Fleet creation events (ordered by fleet creation activity):
     *
     *
     *
     * FLEET_CREATED -- A fleet resource was successfully created with a status of
     * NEW. Event messaging includes the fleet ID.
     *
     * FLEET_STATE_DOWNLOADING -- Fleet status changed from NEW to
     * DOWNLOADING. The compressed build has started downloading to a
     * fleet instance for installation.
     *
     * FLEET_BINARY_DOWNLOAD_FAILED -- The build failed to download to the fleet
     * instance.
     *
     * FLEET_CREATION_EXTRACTING_BUILD – The game server build was successfully
     * downloaded to an instance, and the build files are now being extracted from the
     * uploaded build and saved to an instance. Failure at this stage prevents a fleet
     * from moving to ACTIVE status. Logs for this stage display a list of
     * the files that are extracted and saved on the instance. Access the logs by using
     * the URL in PreSignedLogUrl.
     *
     * FLEET_CREATION_RUNNING_INSTALLER – The game server build files were
     * successfully extracted, and the GameLift is now running the build's install
     * script (if one is included). Failure in this stage prevents a fleet from moving
     * to ACTIVE status. Logs for this stage list the installation steps
     * and whether or not the install completed successfully. Access the logs by using
     * the URL in PreSignedLogUrl.
     *
     * FLEET_CREATION_VALIDATING_RUNTIME_CONFIG -- The build process was successful,
     * and the GameLift is now verifying that the game server launch paths, which are
     * specified in the fleet's runtime configuration, exist. If any listed launch path
     * exists, GameLift tries to launch a game server process and waits for the process
     * to report ready. Failures in this stage prevent a fleet from moving to
     * ACTIVE status. Logs for this stage list the launch paths in the
     * runtime configuration and indicate whether each is found. Access the logs by
     * using the URL in PreSignedLogUrl.
     *
     *
     *
     * FLEET_STATE_VALIDATING -- Fleet status changed from
     * DOWNLOADING to VALIDATING.
     *
     * FLEET_VALIDATION_LAUNCH_PATH_NOT_FOUND -- Validation of the runtime
     * configuration failed because the executable specified in a launch path does not
     * exist on the instance.
     *
     * FLEET_STATE_BUILDING -- Fleet status changed from VALIDATING
     * to BUILDING.
     *
     * FLEET_VALIDATION_EXECUTABLE_RUNTIME_FAILURE -- Validation of the runtime
     * configuration failed because the executable specified in a launch path failed to
     * run on the fleet instance.
     *
     * FLEET_STATE_ACTIVATING -- Fleet status changed from BUILDING
     * to ACTIVATING.
     *
     * FLEET_ACTIVATION_FAILED - The fleet failed to successfully complete one of
     * the steps in the fleet activation process. This event code indicates that the
     * game build was successfully downloaded to a fleet instance, built, and
     * validated, but was not able to start a server process. Learn more at
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-creating-debug.html#fleets-creating-debug-creation"> Debug Fleet
     * Creation Issues
     *
     *
     * FLEET_STATE_ACTIVE -- The fleet's status changed from
     * ACTIVATING to ACTIVE. The fleet is now ready to
     * host game sessions.
     *
     *
     *
     * VPC peering events:
     *
     *
     *
     * FLEET_VPC_PEERING_SUCCEEDED -- A VPC peering connection has been
     * established between the VPC for an GameLift fleet and a VPC in your AWS
     * account.
     *
     * FLEET_VPC_PEERING_FAILED -- A requested VPC peering connection has failed.
     * Event details and status information (see DescribeVpcPeeringConnections) provide additional detail. A
     * common reason for peering failure is that the two VPCs have overlapping CIDR
     * blocks of IPv4 addresses. To resolve this, change the CIDR block for the VPC in
     * your AWS account. For more information on VPC peering failures, see <a href="https://docs.aws.amazon.com/AmazonVPC/latest/PeeringGuide/invalid-peering-configurations.html">https://docs.aws.amazon.com/AmazonVPC/latest/PeeringGuide/invalid-peering-configurations.html
     *
     *
     * FLEET_VPC_PEERING_DELETED -- A VPC peering connection has been successfully
     * deleted.
     *
     *
     *
     * Spot instance events:
     *
     *
     *
     * INSTANCE_INTERRUPTED -- A spot instance was interrupted by EC2 with a
     * two-minute notification.
     *
     *
     *
     * Other fleet events:
     *
     *
     *
     * FLEET_SCALING_EVENT -- A change was made to the fleet's capacity settings
     * (desired instances, minimum/maximum scaling limits). Event messaging includes
     * the new capacity settings.
     *
     * FLEET_NEW_GAME_SESSION_PROTECTION_POLICY_UPDATED -- A change was made to
     * the fleet's game session protection policy setting. Event messaging includes
     * both the old and new policy setting.
     *
     * FLEET_DELETED -- A request to delete a fleet was initiated.
     *
     * GENERIC_EVENT -- An unspecified event has occurred.
     */
    val eventCode: aws.sdk.kotlin.services.gamelift.model.EventCode? = builder.eventCode
    /**
     * A unique identifier for a fleet event.
     */
    val eventId: kotlin.String? = builder.eventId
    /**
     * Time stamp indicating when this event occurred. Format is a number expressed in Unix time as milliseconds (for example "1469498468.057").
     */
    val eventTime: aws.smithy.kotlin.runtime.time.Instant? = builder.eventTime
    /**
     * Additional information related to the event.
     */
    val message: kotlin.String? = builder.message
    /**
     * Location of stored logs with additional detail that is related to the event. This
     * is useful for debugging issues. The URL is valid for 15 minutes. You can also access
     * fleet creation logs through the GameLift console.
     */
    val preSignedLogUrl: kotlin.String? = builder.preSignedLogUrl
    /**
     * A unique identifier for an event resource, such as a fleet ID.
     */
    val resourceId: kotlin.String? = builder.resourceId

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.gamelift.model.Event = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Event(")
        append("eventCode=$eventCode,")
        append("eventId=$eventId,")
        append("eventTime=$eventTime,")
        append("message=$message,")
        append("preSignedLogUrl=$preSignedLogUrl,")
        append("resourceId=$resourceId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = eventCode?.hashCode() ?: 0
        result = 31 * result + (eventId?.hashCode() ?: 0)
        result = 31 * result + (eventTime?.hashCode() ?: 0)
        result = 31 * result + (message?.hashCode() ?: 0)
        result = 31 * result + (preSignedLogUrl?.hashCode() ?: 0)
        result = 31 * result + (resourceId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Event

        if (eventCode != other.eventCode) return false
        if (eventId != other.eventId) return false
        if (eventTime != other.eventTime) return false
        if (message != other.message) return false
        if (preSignedLogUrl != other.preSignedLogUrl) return false
        if (resourceId != other.resourceId) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.gamelift.model.Event = Builder(this).apply(block).build()

    class Builder {
        /**
         * The type of event being logged.
         *
         * Fleet creation events (ordered by fleet creation activity):
         *
         *
         *
         * FLEET_CREATED -- A fleet resource was successfully created with a status of
         * NEW. Event messaging includes the fleet ID.
         *
         * FLEET_STATE_DOWNLOADING -- Fleet status changed from NEW to
         * DOWNLOADING. The compressed build has started downloading to a
         * fleet instance for installation.
         *
         * FLEET_BINARY_DOWNLOAD_FAILED -- The build failed to download to the fleet
         * instance.
         *
         * FLEET_CREATION_EXTRACTING_BUILD – The game server build was successfully
         * downloaded to an instance, and the build files are now being extracted from the
         * uploaded build and saved to an instance. Failure at this stage prevents a fleet
         * from moving to ACTIVE status. Logs for this stage display a list of
         * the files that are extracted and saved on the instance. Access the logs by using
         * the URL in PreSignedLogUrl.
         *
         * FLEET_CREATION_RUNNING_INSTALLER – The game server build files were
         * successfully extracted, and the GameLift is now running the build's install
         * script (if one is included). Failure in this stage prevents a fleet from moving
         * to ACTIVE status. Logs for this stage list the installation steps
         * and whether or not the install completed successfully. Access the logs by using
         * the URL in PreSignedLogUrl.
         *
         * FLEET_CREATION_VALIDATING_RUNTIME_CONFIG -- The build process was successful,
         * and the GameLift is now verifying that the game server launch paths, which are
         * specified in the fleet's runtime configuration, exist. If any listed launch path
         * exists, GameLift tries to launch a game server process and waits for the process
         * to report ready. Failures in this stage prevent a fleet from moving to
         * ACTIVE status. Logs for this stage list the launch paths in the
         * runtime configuration and indicate whether each is found. Access the logs by
         * using the URL in PreSignedLogUrl.
         *
         *
         *
         * FLEET_STATE_VALIDATING -- Fleet status changed from
         * DOWNLOADING to VALIDATING.
         *
         * FLEET_VALIDATION_LAUNCH_PATH_NOT_FOUND -- Validation of the runtime
         * configuration failed because the executable specified in a launch path does not
         * exist on the instance.
         *
         * FLEET_STATE_BUILDING -- Fleet status changed from VALIDATING
         * to BUILDING.
         *
         * FLEET_VALIDATION_EXECUTABLE_RUNTIME_FAILURE -- Validation of the runtime
         * configuration failed because the executable specified in a launch path failed to
         * run on the fleet instance.
         *
         * FLEET_STATE_ACTIVATING -- Fleet status changed from BUILDING
         * to ACTIVATING.
         *
         * FLEET_ACTIVATION_FAILED - The fleet failed to successfully complete one of
         * the steps in the fleet activation process. This event code indicates that the
         * game build was successfully downloaded to a fleet instance, built, and
         * validated, but was not able to start a server process. Learn more at
         * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-creating-debug.html#fleets-creating-debug-creation"> Debug Fleet
         * Creation Issues
         *
         *
         * FLEET_STATE_ACTIVE -- The fleet's status changed from
         * ACTIVATING to ACTIVE. The fleet is now ready to
         * host game sessions.
         *
         *
         *
         * VPC peering events:
         *
         *
         *
         * FLEET_VPC_PEERING_SUCCEEDED -- A VPC peering connection has been
         * established between the VPC for an GameLift fleet and a VPC in your AWS
         * account.
         *
         * FLEET_VPC_PEERING_FAILED -- A requested VPC peering connection has failed.
         * Event details and status information (see DescribeVpcPeeringConnections) provide additional detail. A
         * common reason for peering failure is that the two VPCs have overlapping CIDR
         * blocks of IPv4 addresses. To resolve this, change the CIDR block for the VPC in
         * your AWS account. For more information on VPC peering failures, see <a href="https://docs.aws.amazon.com/AmazonVPC/latest/PeeringGuide/invalid-peering-configurations.html">https://docs.aws.amazon.com/AmazonVPC/latest/PeeringGuide/invalid-peering-configurations.html
         *
         *
         * FLEET_VPC_PEERING_DELETED -- A VPC peering connection has been successfully
         * deleted.
         *
         *
         *
         * Spot instance events:
         *
         *
         *
         * INSTANCE_INTERRUPTED -- A spot instance was interrupted by EC2 with a
         * two-minute notification.
         *
         *
         *
         * Other fleet events:
         *
         *
         *
         * FLEET_SCALING_EVENT -- A change was made to the fleet's capacity settings
         * (desired instances, minimum/maximum scaling limits). Event messaging includes
         * the new capacity settings.
         *
         * FLEET_NEW_GAME_SESSION_PROTECTION_POLICY_UPDATED -- A change was made to
         * the fleet's game session protection policy setting. Event messaging includes
         * both the old and new policy setting.
         *
         * FLEET_DELETED -- A request to delete a fleet was initiated.
         *
         * GENERIC_EVENT -- An unspecified event has occurred.
         */
        var eventCode: aws.sdk.kotlin.services.gamelift.model.EventCode? = null
        /**
         * A unique identifier for a fleet event.
         */
        var eventId: kotlin.String? = null
        /**
         * Time stamp indicating when this event occurred. Format is a number expressed in Unix time as milliseconds (for example "1469498468.057").
         */
        var eventTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Additional information related to the event.
         */
        var message: kotlin.String? = null
        /**
         * Location of stored logs with additional detail that is related to the event. This
         * is useful for debugging issues. The URL is valid for 15 minutes. You can also access
         * fleet creation logs through the GameLift console.
         */
        var preSignedLogUrl: kotlin.String? = null
        /**
         * A unique identifier for an event resource, such as a fleet ID.
         */
        var resourceId: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.gamelift.model.Event) : this() {
            this.eventCode = x.eventCode
            this.eventId = x.eventId
            this.eventTime = x.eventTime
            this.message = x.message
            this.preSignedLogUrl = x.preSignedLogUrl
            this.resourceId = x.resourceId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.gamelift.model.Event = Event(this)
    }
}
