// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.gamelift.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes a GameLift fleet of game hosting resources.
 *
 * Related actions
 *
 *
 * CreateFleet | DescribeFleetAttributes
 */
class FleetAttributes private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN) associated with the GameLift build resource that is deployed on instances in
     * this fleet. In a GameLift build ARN, the resource ID matches the BuildId
     * value.
     */
    val buildArn: kotlin.String? = builder.buildArn
    /**
     * A unique identifier for the build resource that is deployed on instances in this fleet.
     */
    val buildId: kotlin.String? = builder.buildId
    /**
     * Indicates whether a TLS/SSL certificate was generated for the fleet.
     */
    val certificateConfiguration: aws.sdk.kotlin.services.gamelift.model.CertificateConfiguration? = builder.certificateConfiguration
    /**
     * A time stamp indicating when this data object was created. Format is a number expressed in Unix time as milliseconds (for example "1469498468.057").
     */
    val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * A human-readable description of the fleet.
     */
    val description: kotlin.String? = builder.description
    /**
     * The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN) that is assigned to a GameLift fleet resource and uniquely identifies it. ARNs are unique across all Regions. Format is arn:aws:gamelift:<region>::fleet/fleet-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912. In a GameLift fleet ARN, the resource ID matches the FleetId
     * value.
     */
    val fleetArn: kotlin.String? = builder.fleetArn
    /**
     * A unique identifier for the fleet.
     */
    val fleetId: kotlin.String? = builder.fleetId
    /**
     * The kind of instances, On-Demand or Spot, that this fleet uses.
     */
    val fleetType: aws.sdk.kotlin.services.gamelift.model.FleetType? = builder.fleetType
    /**
     * A unique identifier for an AWS IAM role that manages access to your AWS services.
     * With an instance role ARN set, any application that runs on an instance in this fleet can assume the role,
     * including install scripts, server processes, and daemons (background processes). Create a role or look up a role's
     * ARN by using the <a href="https://console.aws.amazon.com/iam/">IAM dashboard in the AWS Management Console.
     * Learn more about using on-box credentials for your game servers at
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-resources.html">
     * Access external resources from a game server.
     */
    val instanceRoleArn: kotlin.String? = builder.instanceRoleArn
    /**
     * The EC2 instance type that determines the computing resources of each instance in
     * the fleet. Instance type defines the CPU, memory, storage, and networking capacity. See
     * <a href="http://aws.amazon.com/ec2/instance-types/">Amazon EC2 Instance Types
     * for detailed descriptions.
     */
    val instanceType: aws.sdk.kotlin.services.gamelift.model.Ec2InstanceType? = builder.instanceType
    /**
     * This parameter is no longer used. Game session log
     * paths are now defined using the GameLift server API ProcessReady()
     * logParameters. See more information in the <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api-ref.html#gamelift-sdk-server-api-ref-dataypes-process">Server API Reference.
     */
    val logPaths: List<String>? = builder.logPaths
    /**
     * Name of a metric group that metrics for this fleet are added to. In Amazon CloudWatch,
     * you can view aggregated metrics for fleets that are in a metric group. A fleet can be
     * included in only one metric group at a time.
     */
    val metricGroups: List<String>? = builder.metricGroups
    /**
     * A descriptive label that is associated with a fleet. Fleet names do not need to be unique.
     */
    val name: kotlin.String? = builder.name
    /**
     * The type of game session protection to set on all new instances that are started in
     * the fleet.
     *
     *
     *
     * NoProtection -- The game session can be
     * terminated during a scale-down event.
     *
     *
     * FullProtection -- If the game session is in an
     * ACTIVE status, it cannot be terminated during a scale-down
     * event.
     */
    val newGameSessionProtectionPolicy: aws.sdk.kotlin.services.gamelift.model.ProtectionPolicy? = builder.newGameSessionProtectionPolicy
    /**
     * The operating system of the fleet's computing resources. A fleet's operating system is
     * determined by the OS of the build or script that is deployed on this fleet.
     */
    val operatingSystem: aws.sdk.kotlin.services.gamelift.model.OperatingSystem? = builder.operatingSystem
    /**
     * The fleet policy that limits the number of game sessions an individual player can
     * create over a span of time.
     */
    val resourceCreationLimitPolicy: aws.sdk.kotlin.services.gamelift.model.ResourceCreationLimitPolicy? = builder.resourceCreationLimitPolicy
    /**
     * The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN) associated with the GameLift script resource that is deployed on instances
     * in this fleet. In a GameLift script ARN, the resource ID matches the
     * ScriptId value.
     */
    val scriptArn: kotlin.String? = builder.scriptArn
    /**
     * A unique identifier for the Realtime script resource that is deployed on instances in this fleet.
     */
    val scriptId: kotlin.String? = builder.scriptId
    /**
     * This parameter is no longer used. Server launch
     * parameters are now defined  using the fleet's RuntimeConfiguration
     * parameter. Requests that use this parameter instead continue to be valid.
     */
    val serverLaunchParameters: kotlin.String? = builder.serverLaunchParameters
    /**
     * This parameter is no longer used. Server launch paths
     * are now defined  using the fleet's RuntimeConfiguration parameter.
     * Requests that use this parameter instead continue to be valid.
     */
    val serverLaunchPath: kotlin.String? = builder.serverLaunchPath
    /**
     * Current status of the fleet. Possible fleet statuses include the following:
     *
     *
     *
     * NEW -- A new fleet has been defined and desired
     * instances is set to 1.
     *
     *
     * DOWNLOADING/VALIDATING/BUILDING/ACTIVATING --
     * GameLift is setting up the new fleet, creating new instances with the game build
     * or Realtime script and starting server processes.
     *
     *
     * ACTIVE -- Hosts can now accept game
     * sessions.
     *
     *
     * ERROR -- An error occurred when downloading,
     * validating, building, or activating the fleet.
     *
     *
     * DELETING -- Hosts are responding to a delete
     * fleet request.
     *
     *
     * TERMINATED -- The fleet no longer
     * exists.
     */
    val status: aws.sdk.kotlin.services.gamelift.model.FleetStatus? = builder.status
    /**
     * A list of fleet activity that has been suspended using StopFleetActions. This includes fleet auto-scaling.
     */
    val stoppedActions: List<FleetAction>? = builder.stoppedActions
    /**
     * A time stamp indicating when this data object was terminated. Format is a number expressed in Unix time as milliseconds (for example "1469498468.057").
     */
    val terminationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.terminationTime

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.gamelift.model.FleetAttributes = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("FleetAttributes(")
        append("buildArn=$buildArn,")
        append("buildId=$buildId,")
        append("certificateConfiguration=$certificateConfiguration,")
        append("creationTime=$creationTime,")
        append("description=$description,")
        append("fleetArn=$fleetArn,")
        append("fleetId=$fleetId,")
        append("fleetType=$fleetType,")
        append("instanceRoleArn=$instanceRoleArn,")
        append("instanceType=$instanceType,")
        append("logPaths=$logPaths,")
        append("metricGroups=$metricGroups,")
        append("name=$name,")
        append("newGameSessionProtectionPolicy=$newGameSessionProtectionPolicy,")
        append("operatingSystem=$operatingSystem,")
        append("resourceCreationLimitPolicy=$resourceCreationLimitPolicy,")
        append("scriptArn=$scriptArn,")
        append("scriptId=$scriptId,")
        append("serverLaunchParameters=$serverLaunchParameters,")
        append("serverLaunchPath=$serverLaunchPath,")
        append("status=$status,")
        append("stoppedActions=$stoppedActions,")
        append("terminationTime=$terminationTime)")
    }

    override fun hashCode(): kotlin.Int {
        var result = buildArn?.hashCode() ?: 0
        result = 31 * result + (buildId?.hashCode() ?: 0)
        result = 31 * result + (certificateConfiguration?.hashCode() ?: 0)
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (fleetArn?.hashCode() ?: 0)
        result = 31 * result + (fleetId?.hashCode() ?: 0)
        result = 31 * result + (fleetType?.hashCode() ?: 0)
        result = 31 * result + (instanceRoleArn?.hashCode() ?: 0)
        result = 31 * result + (instanceType?.hashCode() ?: 0)
        result = 31 * result + (logPaths?.hashCode() ?: 0)
        result = 31 * result + (metricGroups?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (newGameSessionProtectionPolicy?.hashCode() ?: 0)
        result = 31 * result + (operatingSystem?.hashCode() ?: 0)
        result = 31 * result + (resourceCreationLimitPolicy?.hashCode() ?: 0)
        result = 31 * result + (scriptArn?.hashCode() ?: 0)
        result = 31 * result + (scriptId?.hashCode() ?: 0)
        result = 31 * result + (serverLaunchParameters?.hashCode() ?: 0)
        result = 31 * result + (serverLaunchPath?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (stoppedActions?.hashCode() ?: 0)
        result = 31 * result + (terminationTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as FleetAttributes

        if (buildArn != other.buildArn) return false
        if (buildId != other.buildId) return false
        if (certificateConfiguration != other.certificateConfiguration) return false
        if (creationTime != other.creationTime) return false
        if (description != other.description) return false
        if (fleetArn != other.fleetArn) return false
        if (fleetId != other.fleetId) return false
        if (fleetType != other.fleetType) return false
        if (instanceRoleArn != other.instanceRoleArn) return false
        if (instanceType != other.instanceType) return false
        if (logPaths != other.logPaths) return false
        if (metricGroups != other.metricGroups) return false
        if (name != other.name) return false
        if (newGameSessionProtectionPolicy != other.newGameSessionProtectionPolicy) return false
        if (operatingSystem != other.operatingSystem) return false
        if (resourceCreationLimitPolicy != other.resourceCreationLimitPolicy) return false
        if (scriptArn != other.scriptArn) return false
        if (scriptId != other.scriptId) return false
        if (serverLaunchParameters != other.serverLaunchParameters) return false
        if (serverLaunchPath != other.serverLaunchPath) return false
        if (status != other.status) return false
        if (stoppedActions != other.stoppedActions) return false
        if (terminationTime != other.terminationTime) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.gamelift.model.FleetAttributes = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN) associated with the GameLift build resource that is deployed on instances in
         * this fleet. In a GameLift build ARN, the resource ID matches the BuildId
         * value.
         */
        var buildArn: kotlin.String? = null
        /**
         * A unique identifier for the build resource that is deployed on instances in this fleet.
         */
        var buildId: kotlin.String? = null
        /**
         * Indicates whether a TLS/SSL certificate was generated for the fleet.
         */
        var certificateConfiguration: aws.sdk.kotlin.services.gamelift.model.CertificateConfiguration? = null
        /**
         * A time stamp indicating when this data object was created. Format is a number expressed in Unix time as milliseconds (for example "1469498468.057").
         */
        var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A human-readable description of the fleet.
         */
        var description: kotlin.String? = null
        /**
         * The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN) that is assigned to a GameLift fleet resource and uniquely identifies it. ARNs are unique across all Regions. Format is arn:aws:gamelift:<region>::fleet/fleet-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912. In a GameLift fleet ARN, the resource ID matches the FleetId
         * value.
         */
        var fleetArn: kotlin.String? = null
        /**
         * A unique identifier for the fleet.
         */
        var fleetId: kotlin.String? = null
        /**
         * The kind of instances, On-Demand or Spot, that this fleet uses.
         */
        var fleetType: aws.sdk.kotlin.services.gamelift.model.FleetType? = null
        /**
         * A unique identifier for an AWS IAM role that manages access to your AWS services.
         * With an instance role ARN set, any application that runs on an instance in this fleet can assume the role,
         * including install scripts, server processes, and daemons (background processes). Create a role or look up a role's
         * ARN by using the <a href="https://console.aws.amazon.com/iam/">IAM dashboard in the AWS Management Console.
         * Learn more about using on-box credentials for your game servers at
         * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-resources.html">
         * Access external resources from a game server.
         */
        var instanceRoleArn: kotlin.String? = null
        /**
         * The EC2 instance type that determines the computing resources of each instance in
         * the fleet. Instance type defines the CPU, memory, storage, and networking capacity. See
         * <a href="http://aws.amazon.com/ec2/instance-types/">Amazon EC2 Instance Types
         * for detailed descriptions.
         */
        var instanceType: aws.sdk.kotlin.services.gamelift.model.Ec2InstanceType? = null
        /**
         * This parameter is no longer used. Game session log
         * paths are now defined using the GameLift server API ProcessReady()
         * logParameters. See more information in the <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api-ref.html#gamelift-sdk-server-api-ref-dataypes-process">Server API Reference.
         */
        var logPaths: List<String>? = null
        /**
         * Name of a metric group that metrics for this fleet are added to. In Amazon CloudWatch,
         * you can view aggregated metrics for fleets that are in a metric group. A fleet can be
         * included in only one metric group at a time.
         */
        var metricGroups: List<String>? = null
        /**
         * A descriptive label that is associated with a fleet. Fleet names do not need to be unique.
         */
        var name: kotlin.String? = null
        /**
         * The type of game session protection to set on all new instances that are started in
         * the fleet.
         *
         *
         *
         * NoProtection -- The game session can be
         * terminated during a scale-down event.
         *
         *
         * FullProtection -- If the game session is in an
         * ACTIVE status, it cannot be terminated during a scale-down
         * event.
         */
        var newGameSessionProtectionPolicy: aws.sdk.kotlin.services.gamelift.model.ProtectionPolicy? = null
        /**
         * The operating system of the fleet's computing resources. A fleet's operating system is
         * determined by the OS of the build or script that is deployed on this fleet.
         */
        var operatingSystem: aws.sdk.kotlin.services.gamelift.model.OperatingSystem? = null
        /**
         * The fleet policy that limits the number of game sessions an individual player can
         * create over a span of time.
         */
        var resourceCreationLimitPolicy: aws.sdk.kotlin.services.gamelift.model.ResourceCreationLimitPolicy? = null
        /**
         * The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN) associated with the GameLift script resource that is deployed on instances
         * in this fleet. In a GameLift script ARN, the resource ID matches the
         * ScriptId value.
         */
        var scriptArn: kotlin.String? = null
        /**
         * A unique identifier for the Realtime script resource that is deployed on instances in this fleet.
         */
        var scriptId: kotlin.String? = null
        /**
         * This parameter is no longer used. Server launch
         * parameters are now defined  using the fleet's RuntimeConfiguration
         * parameter. Requests that use this parameter instead continue to be valid.
         */
        var serverLaunchParameters: kotlin.String? = null
        /**
         * This parameter is no longer used. Server launch paths
         * are now defined  using the fleet's RuntimeConfiguration parameter.
         * Requests that use this parameter instead continue to be valid.
         */
        var serverLaunchPath: kotlin.String? = null
        /**
         * Current status of the fleet. Possible fleet statuses include the following:
         *
         *
         *
         * NEW -- A new fleet has been defined and desired
         * instances is set to 1.
         *
         *
         * DOWNLOADING/VALIDATING/BUILDING/ACTIVATING --
         * GameLift is setting up the new fleet, creating new instances with the game build
         * or Realtime script and starting server processes.
         *
         *
         * ACTIVE -- Hosts can now accept game
         * sessions.
         *
         *
         * ERROR -- An error occurred when downloading,
         * validating, building, or activating the fleet.
         *
         *
         * DELETING -- Hosts are responding to a delete
         * fleet request.
         *
         *
         * TERMINATED -- The fleet no longer
         * exists.
         */
        var status: aws.sdk.kotlin.services.gamelift.model.FleetStatus? = null
        /**
         * A list of fleet activity that has been suspended using StopFleetActions. This includes fleet auto-scaling.
         */
        var stoppedActions: List<FleetAction>? = null
        /**
         * A time stamp indicating when this data object was terminated. Format is a number expressed in Unix time as milliseconds (for example "1469498468.057").
         */
        var terminationTime: aws.smithy.kotlin.runtime.time.Instant? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.gamelift.model.FleetAttributes) : this() {
            this.buildArn = x.buildArn
            this.buildId = x.buildId
            this.certificateConfiguration = x.certificateConfiguration
            this.creationTime = x.creationTime
            this.description = x.description
            this.fleetArn = x.fleetArn
            this.fleetId = x.fleetId
            this.fleetType = x.fleetType
            this.instanceRoleArn = x.instanceRoleArn
            this.instanceType = x.instanceType
            this.logPaths = x.logPaths
            this.metricGroups = x.metricGroups
            this.name = x.name
            this.newGameSessionProtectionPolicy = x.newGameSessionProtectionPolicy
            this.operatingSystem = x.operatingSystem
            this.resourceCreationLimitPolicy = x.resourceCreationLimitPolicy
            this.scriptArn = x.scriptArn
            this.scriptId = x.scriptId
            this.serverLaunchParameters = x.serverLaunchParameters
            this.serverLaunchPath = x.serverLaunchPath
            this.status = x.status
            this.stoppedActions = x.stoppedActions
            this.terminationTime = x.terminationTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.gamelift.model.FleetAttributes = FleetAttributes(this)

        /**
         * construct an [aws.sdk.kotlin.services.gamelift.model.CertificateConfiguration] inside the given [block]
         */
        fun certificateConfiguration(block: aws.sdk.kotlin.services.gamelift.model.CertificateConfiguration.Builder.() -> kotlin.Unit) {
            this.certificateConfiguration = aws.sdk.kotlin.services.gamelift.model.CertificateConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.gamelift.model.ResourceCreationLimitPolicy] inside the given [block]
         */
        fun resourceCreationLimitPolicy(block: aws.sdk.kotlin.services.gamelift.model.ResourceCreationLimitPolicy.Builder.() -> kotlin.Unit) {
            this.resourceCreationLimitPolicy = aws.sdk.kotlin.services.gamelift.model.ResourceCreationLimitPolicy.invoke(block)
        }
    }
}
