// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.gamelift.model



/**
 * Current resource utilization statistics in a specified fleet or location. The location
 * value might refer to a fleet's remote location or its home Region.
 *
 * Related actions
 *
 *
 * DescribeFleetUtilization | DescribeFleetLocationUtilization
 */
class FleetUtilization private constructor(builder: Builder) {
    /**
     * The number of active game sessions that are currently being hosted across all
     * instances in the fleet location.
     */
    val activeGameSessionCount: kotlin.Int? = builder.activeGameSessionCount
    /**
     * The number of server processes in ACTIVE status that are currently
     * running across all instances in the fleet location.
     */
    val activeServerProcessCount: kotlin.Int? = builder.activeServerProcessCount
    /**
     * The number of active player sessions that are currently being hosted across all
     * instances in the fleet location.
     */
    val currentPlayerSessionCount: kotlin.Int? = builder.currentPlayerSessionCount
    /**
     * The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN) that is assigned to a GameLift fleet resource and uniquely identifies it. ARNs are unique across all Regions. Format is arn:aws:gamelift:<region>::fleet/fleet-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912.
     */
    val fleetArn: kotlin.String? = builder.fleetArn
    /**
     * A unique identifier for the fleet associated with the location.
     */
    val fleetId: kotlin.String? = builder.fleetId
    /**
     * The fleet location for the fleet utilization information, expressed as an AWS Region
     * code, such as us-west-2.
     */
    val location: kotlin.String? = builder.location
    /**
     * The maximum number of players allowed across all game sessions that are currently
     * being hosted across all instances in the fleet location.
     */
    val maximumPlayerSessionCount: kotlin.Int? = builder.maximumPlayerSessionCount

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.gamelift.model.FleetUtilization = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("FleetUtilization(")
        append("activeGameSessionCount=$activeGameSessionCount,")
        append("activeServerProcessCount=$activeServerProcessCount,")
        append("currentPlayerSessionCount=$currentPlayerSessionCount,")
        append("fleetArn=$fleetArn,")
        append("fleetId=$fleetId,")
        append("location=$location,")
        append("maximumPlayerSessionCount=$maximumPlayerSessionCount)")
    }

    override fun hashCode(): kotlin.Int {
        var result = activeGameSessionCount ?: 0
        result = 31 * result + (activeServerProcessCount ?: 0)
        result = 31 * result + (currentPlayerSessionCount ?: 0)
        result = 31 * result + (fleetArn?.hashCode() ?: 0)
        result = 31 * result + (fleetId?.hashCode() ?: 0)
        result = 31 * result + (location?.hashCode() ?: 0)
        result = 31 * result + (maximumPlayerSessionCount ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as FleetUtilization

        if (activeGameSessionCount != other.activeGameSessionCount) return false
        if (activeServerProcessCount != other.activeServerProcessCount) return false
        if (currentPlayerSessionCount != other.currentPlayerSessionCount) return false
        if (fleetArn != other.fleetArn) return false
        if (fleetId != other.fleetId) return false
        if (location != other.location) return false
        if (maximumPlayerSessionCount != other.maximumPlayerSessionCount) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.gamelift.model.FleetUtilization = Builder(this).apply(block).build()

    class Builder {
        /**
         * The number of active game sessions that are currently being hosted across all
         * instances in the fleet location.
         */
        var activeGameSessionCount: kotlin.Int? = null
        /**
         * The number of server processes in ACTIVE status that are currently
         * running across all instances in the fleet location.
         */
        var activeServerProcessCount: kotlin.Int? = null
        /**
         * The number of active player sessions that are currently being hosted across all
         * instances in the fleet location.
         */
        var currentPlayerSessionCount: kotlin.Int? = null
        /**
         * The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN) that is assigned to a GameLift fleet resource and uniquely identifies it. ARNs are unique across all Regions. Format is arn:aws:gamelift:<region>::fleet/fleet-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912.
         */
        var fleetArn: kotlin.String? = null
        /**
         * A unique identifier for the fleet associated with the location.
         */
        var fleetId: kotlin.String? = null
        /**
         * The fleet location for the fleet utilization information, expressed as an AWS Region
         * code, such as us-west-2.
         */
        var location: kotlin.String? = null
        /**
         * The maximum number of players allowed across all game sessions that are currently
         * being hosted across all instances in the fleet location.
         */
        var maximumPlayerSessionCount: kotlin.Int? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.gamelift.model.FleetUtilization) : this() {
            this.activeGameSessionCount = x.activeGameSessionCount
            this.activeServerProcessCount = x.activeServerProcessCount
            this.currentPlayerSessionCount = x.currentPlayerSessionCount
            this.fleetArn = x.fleetArn
            this.fleetId = x.fleetId
            this.location = x.location
            this.maximumPlayerSessionCount = x.maximumPlayerSessionCount
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.gamelift.model.FleetUtilization = FleetUtilization(this)
    }
}
