// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.gamelift.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * This data type is used with the GameLift FleetIQ and game server groups.
 *
 * Properties that describe a game server group resource. A game server group manages
 * certain properties related to a corresponding EC2 Auto Scaling group.
 * A game server group is created by a successful call to
 * CreateGameServerGroup and deleted by calling
 * DeleteGameServerGroup. Game server group activity can be temporarily
 * suspended and resumed by calling SuspendGameServerGroup and
 * ResumeGameServerGroup, respectively.
 *
 * Related actions
 *
 *
 * CreateGameServerGroup |
 * ListGameServerGroups |
 * DescribeGameServerGroup |
 * UpdateGameServerGroup |
 * DeleteGameServerGroup |
 * ResumeGameServerGroup |
 * SuspendGameServerGroup |
 * DescribeGameServerInstances |
 * <a href="https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/reference-awssdk-fleetiq.html">All APIs by task
 */
class GameServerGroup private constructor(builder: Builder) {
    /**
     * A generated unique ID for the EC2 Auto Scaling group that is associated with this
     * game server group.
     */
    val autoScalingGroupArn: kotlin.String? = builder.autoScalingGroupArn
    /**
     * Indicates how GameLift FleetIQ balances the use of Spot Instances and On-Demand Instances in the
     * game server group. Method options include the following:
     *
     *
     *
     * SPOT_ONLY - Only Spot Instances are used in the game server group. If Spot
     * Instances are unavailable or not viable for game hosting, the game server group
     * provides no hosting capacity until Spot Instances can again be used. Until then,
     * no new instances are started, and the existing nonviable Spot Instances are
     * terminated (after current gameplay ends) and are not replaced.
     *
     *
     * SPOT_PREFERRED - (default value) Spot Instances are used whenever available in
     * the game server group. If Spot Instances are unavailable, the game server group
     * continues to provide hosting capacity by falling back to On-Demand Instances.
     * Existing nonviable Spot Instances are terminated (after current gameplay ends)
     * and are replaced with new On-Demand Instances.
     *
     *
     * ON_DEMAND_ONLY - Only On-Demand Instances are used in the game
     * server group. No Spot Instances are used, even when available, while this
     * balancing strategy is in force.
     */
    val balancingStrategy: aws.sdk.kotlin.services.gamelift.model.BalancingStrategy? = builder.balancingStrategy
    /**
     * A time stamp indicating when this data object was created. Format is a number expressed in Unix time as milliseconds (for example "1469498468.057").
     */
    val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * A generated unique ID for the game server group.
     */
    val gameServerGroupArn: kotlin.String? = builder.gameServerGroupArn
    /**
     * A developer-defined identifier for the game server group. The name is unique for each
     * Region in each AWS account.
     */
    val gameServerGroupName: kotlin.String? = builder.gameServerGroupName
    /**
     * A flag that indicates whether instances in the game server group are protected
     * from early termination. Unprotected instances that have active game servers running might
     * be terminated during a scale-down event, causing players to be dropped from the game.
     * Protected instances cannot be terminated while there are active game servers running except
     * in the event of a forced game server group deletion (see ). An exception to this is with Spot
     * Instances, which can be terminated by AWS regardless of protection status.
     */
    val gameServerProtectionPolicy: aws.sdk.kotlin.services.gamelift.model.GameServerProtectionPolicy? = builder.gameServerProtectionPolicy
    /**
     * The set of EC2 instance types that GameLift FleetIQ can use when balancing and automatically
     * scaling instances in the corresponding Auto Scaling group.
     */
    val instanceDefinitions: List<InstanceDefinition>? = builder.instanceDefinitions
    /**
     * A timestamp that indicates when this game server group was last updated.
     */
    val lastUpdatedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedTime
    /**
     * The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN) for an IAM role that
     * allows Amazon GameLift to access your EC2 Auto Scaling groups.
     */
    val roleArn: kotlin.String? = builder.roleArn
    /**
     * The current status of the game server group. Possible statuses include:
     *
     *
     *
     * NEW - GameLift FleetIQ has validated the CreateGameServerGroup()
     * request.
     *
     *
     * ACTIVATING - GameLift FleetIQ is setting up a game server group, which
     * includes creating an Auto Scaling group in your AWS account.
     *
     *
     * ACTIVE - The game server group has been successfully created.
     *
     *
     * DELETE_SCHEDULED - A request to delete the game server group has
     * been received.
     *
     *
     * DELETING - GameLift FleetIQ has received a valid
     * DeleteGameServerGroup() request and is processing it. GameLift FleetIQ
     * must first complete and release hosts before it deletes the Auto Scaling group
     * and the game server group.
     *
     *
     * DELETED - The game server group has been successfully deleted.
     *
     *
     * ERROR - The asynchronous processes of activating or deleting a game server group
     * has failed, resulting in an error state.
     */
    val status: aws.sdk.kotlin.services.gamelift.model.GameServerGroupStatus? = builder.status
    /**
     * Additional information about the current game server group status. This information
     * might provide additional insight on groups that are in ERROR status.
     */
    val statusReason: kotlin.String? = builder.statusReason
    /**
     * A list of activities that are currently suspended for this game server group.
     * If this property is empty, all activities are occurring.
     */
    val suspendedActions: List<GameServerGroupAction>? = builder.suspendedActions

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.gamelift.model.GameServerGroup = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GameServerGroup(")
        append("autoScalingGroupArn=$autoScalingGroupArn,")
        append("balancingStrategy=$balancingStrategy,")
        append("creationTime=$creationTime,")
        append("gameServerGroupArn=$gameServerGroupArn,")
        append("gameServerGroupName=$gameServerGroupName,")
        append("gameServerProtectionPolicy=$gameServerProtectionPolicy,")
        append("instanceDefinitions=$instanceDefinitions,")
        append("lastUpdatedTime=$lastUpdatedTime,")
        append("roleArn=$roleArn,")
        append("status=$status,")
        append("statusReason=$statusReason,")
        append("suspendedActions=$suspendedActions)")
    }

    override fun hashCode(): kotlin.Int {
        var result = autoScalingGroupArn?.hashCode() ?: 0
        result = 31 * result + (balancingStrategy?.hashCode() ?: 0)
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (gameServerGroupArn?.hashCode() ?: 0)
        result = 31 * result + (gameServerGroupName?.hashCode() ?: 0)
        result = 31 * result + (gameServerProtectionPolicy?.hashCode() ?: 0)
        result = 31 * result + (instanceDefinitions?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedTime?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (statusReason?.hashCode() ?: 0)
        result = 31 * result + (suspendedActions?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GameServerGroup

        if (autoScalingGroupArn != other.autoScalingGroupArn) return false
        if (balancingStrategy != other.balancingStrategy) return false
        if (creationTime != other.creationTime) return false
        if (gameServerGroupArn != other.gameServerGroupArn) return false
        if (gameServerGroupName != other.gameServerGroupName) return false
        if (gameServerProtectionPolicy != other.gameServerProtectionPolicy) return false
        if (instanceDefinitions != other.instanceDefinitions) return false
        if (lastUpdatedTime != other.lastUpdatedTime) return false
        if (roleArn != other.roleArn) return false
        if (status != other.status) return false
        if (statusReason != other.statusReason) return false
        if (suspendedActions != other.suspendedActions) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.gamelift.model.GameServerGroup = Builder(this).apply(block).build()

    class Builder {
        /**
         * A generated unique ID for the EC2 Auto Scaling group that is associated with this
         * game server group.
         */
        var autoScalingGroupArn: kotlin.String? = null
        /**
         * Indicates how GameLift FleetIQ balances the use of Spot Instances and On-Demand Instances in the
         * game server group. Method options include the following:
         *
         *
         *
         * SPOT_ONLY - Only Spot Instances are used in the game server group. If Spot
         * Instances are unavailable or not viable for game hosting, the game server group
         * provides no hosting capacity until Spot Instances can again be used. Until then,
         * no new instances are started, and the existing nonviable Spot Instances are
         * terminated (after current gameplay ends) and are not replaced.
         *
         *
         * SPOT_PREFERRED - (default value) Spot Instances are used whenever available in
         * the game server group. If Spot Instances are unavailable, the game server group
         * continues to provide hosting capacity by falling back to On-Demand Instances.
         * Existing nonviable Spot Instances are terminated (after current gameplay ends)
         * and are replaced with new On-Demand Instances.
         *
         *
         * ON_DEMAND_ONLY - Only On-Demand Instances are used in the game
         * server group. No Spot Instances are used, even when available, while this
         * balancing strategy is in force.
         */
        var balancingStrategy: aws.sdk.kotlin.services.gamelift.model.BalancingStrategy? = null
        /**
         * A time stamp indicating when this data object was created. Format is a number expressed in Unix time as milliseconds (for example "1469498468.057").
         */
        var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A generated unique ID for the game server group.
         */
        var gameServerGroupArn: kotlin.String? = null
        /**
         * A developer-defined identifier for the game server group. The name is unique for each
         * Region in each AWS account.
         */
        var gameServerGroupName: kotlin.String? = null
        /**
         * A flag that indicates whether instances in the game server group are protected
         * from early termination. Unprotected instances that have active game servers running might
         * be terminated during a scale-down event, causing players to be dropped from the game.
         * Protected instances cannot be terminated while there are active game servers running except
         * in the event of a forced game server group deletion (see ). An exception to this is with Spot
         * Instances, which can be terminated by AWS regardless of protection status.
         */
        var gameServerProtectionPolicy: aws.sdk.kotlin.services.gamelift.model.GameServerProtectionPolicy? = null
        /**
         * The set of EC2 instance types that GameLift FleetIQ can use when balancing and automatically
         * scaling instances in the corresponding Auto Scaling group.
         */
        var instanceDefinitions: List<InstanceDefinition>? = null
        /**
         * A timestamp that indicates when this game server group was last updated.
         */
        var lastUpdatedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN) for an IAM role that
         * allows Amazon GameLift to access your EC2 Auto Scaling groups.
         */
        var roleArn: kotlin.String? = null
        /**
         * The current status of the game server group. Possible statuses include:
         *
         *
         *
         * NEW - GameLift FleetIQ has validated the CreateGameServerGroup()
         * request.
         *
         *
         * ACTIVATING - GameLift FleetIQ is setting up a game server group, which
         * includes creating an Auto Scaling group in your AWS account.
         *
         *
         * ACTIVE - The game server group has been successfully created.
         *
         *
         * DELETE_SCHEDULED - A request to delete the game server group has
         * been received.
         *
         *
         * DELETING - GameLift FleetIQ has received a valid
         * DeleteGameServerGroup() request and is processing it. GameLift FleetIQ
         * must first complete and release hosts before it deletes the Auto Scaling group
         * and the game server group.
         *
         *
         * DELETED - The game server group has been successfully deleted.
         *
         *
         * ERROR - The asynchronous processes of activating or deleting a game server group
         * has failed, resulting in an error state.
         */
        var status: aws.sdk.kotlin.services.gamelift.model.GameServerGroupStatus? = null
        /**
         * Additional information about the current game server group status. This information
         * might provide additional insight on groups that are in ERROR status.
         */
        var statusReason: kotlin.String? = null
        /**
         * A list of activities that are currently suspended for this game server group.
         * If this property is empty, all activities are occurring.
         */
        var suspendedActions: List<GameServerGroupAction>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.gamelift.model.GameServerGroup) : this() {
            this.autoScalingGroupArn = x.autoScalingGroupArn
            this.balancingStrategy = x.balancingStrategy
            this.creationTime = x.creationTime
            this.gameServerGroupArn = x.gameServerGroupArn
            this.gameServerGroupName = x.gameServerGroupName
            this.gameServerProtectionPolicy = x.gameServerProtectionPolicy
            this.instanceDefinitions = x.instanceDefinitions
            this.lastUpdatedTime = x.lastUpdatedTime
            this.roleArn = x.roleArn
            this.status = x.status
            this.statusReason = x.statusReason
            this.suspendedActions = x.suspendedActions
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.gamelift.model.GameServerGroup = GameServerGroup(this)
    }
}
