// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.gamelift.model



/**
 * This data type is used with the GameLift FleetIQ and game server groups.
 *
 * Configuration settings for intelligent automatic scaling that uses target tracking.
 * These settings are used to add an Auto Scaling policy when creating the corresponding
 * Auto Scaling group with CreateGameServerGroup. After the Auto Scaling
 * group is created, all updates to Auto Scaling policies, including changing this policy
 * and adding or removing other policies, is done directly on the Auto Scaling group.
 */
class GameServerGroupAutoScalingPolicy private constructor(builder: Builder) {
    /**
     * Length of time, in seconds, it takes for a new instance to start new game server
     * processes and register with GameLift FleetIQ. Specifying a warm-up time can be useful, particularly
     * with game servers that take a long time to start up, because it avoids prematurely
     * starting new instances.
     */
    val estimatedInstanceWarmup: kotlin.Int? = builder.estimatedInstanceWarmup
    /**
     * Settings for a target-based scaling policy applied to Auto Scaling group. These
     * settings are used to create a target-based policy that tracks the GameLift FleetIQ metric
     * "PercentUtilizedGameServers" and specifies a target value for the
     * metric. As player usage changes, the policy triggers to adjust the game server group
     * capacity so that the metric returns to the target value.
     */
    val targetTrackingConfiguration: aws.sdk.kotlin.services.gamelift.model.TargetTrackingConfiguration? = builder.targetTrackingConfiguration

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.gamelift.model.GameServerGroupAutoScalingPolicy = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GameServerGroupAutoScalingPolicy(")
        append("estimatedInstanceWarmup=$estimatedInstanceWarmup,")
        append("targetTrackingConfiguration=$targetTrackingConfiguration)")
    }

    override fun hashCode(): kotlin.Int {
        var result = estimatedInstanceWarmup ?: 0
        result = 31 * result + (targetTrackingConfiguration?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GameServerGroupAutoScalingPolicy

        if (estimatedInstanceWarmup != other.estimatedInstanceWarmup) return false
        if (targetTrackingConfiguration != other.targetTrackingConfiguration) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.gamelift.model.GameServerGroupAutoScalingPolicy = Builder(this).apply(block).build()

    class Builder {
        /**
         * Length of time, in seconds, it takes for a new instance to start new game server
         * processes and register with GameLift FleetIQ. Specifying a warm-up time can be useful, particularly
         * with game servers that take a long time to start up, because it avoids prematurely
         * starting new instances.
         */
        var estimatedInstanceWarmup: kotlin.Int? = null
        /**
         * Settings for a target-based scaling policy applied to Auto Scaling group. These
         * settings are used to create a target-based policy that tracks the GameLift FleetIQ metric
         * "PercentUtilizedGameServers" and specifies a target value for the
         * metric. As player usage changes, the policy triggers to adjust the game server group
         * capacity so that the metric returns to the target value.
         */
        var targetTrackingConfiguration: aws.sdk.kotlin.services.gamelift.model.TargetTrackingConfiguration? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.gamelift.model.GameServerGroupAutoScalingPolicy) : this() {
            this.estimatedInstanceWarmup = x.estimatedInstanceWarmup
            this.targetTrackingConfiguration = x.targetTrackingConfiguration
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.gamelift.model.GameServerGroupAutoScalingPolicy = GameServerGroupAutoScalingPolicy(this)

        /**
         * construct an [aws.sdk.kotlin.services.gamelift.model.TargetTrackingConfiguration] inside the given [block]
         */
        fun targetTrackingConfiguration(block: aws.sdk.kotlin.services.gamelift.model.TargetTrackingConfiguration.Builder.() -> kotlin.Unit) {
            this.targetTrackingConfiguration = aws.sdk.kotlin.services.gamelift.model.TargetTrackingConfiguration.invoke(block)
        }
    }
}
