// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.gamelift.model



/**
 * This data type is used with the GameLift FleetIQ and game server groups.
 *
 * Additional properties, including status, that describe an EC2 instance in a game
 * server group. Instance configurations are set with game server group properties (see
 * DescribeGameServerGroup and with the EC2 launch template that was used
 * when creating the game server group.
 * Retrieve game server instances for a game server group by calling
 * DescribeGameServerInstances.
 *
 * Related actions
 *
 *
 * CreateGameServerGroup |
 * ListGameServerGroups |
 * DescribeGameServerGroup |
 * UpdateGameServerGroup |
 * DeleteGameServerGroup |
 * ResumeGameServerGroup |
 * SuspendGameServerGroup |
 * DescribeGameServerInstances |
 * <a href="https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/reference-awssdk-fleetiq.html">All APIs by task
 */
class GameServerInstance private constructor(builder: Builder) {
    /**
     * A generated unique identifier for the game server group that includes the game
     * server instance.
     */
    val gameServerGroupArn: kotlin.String? = builder.gameServerGroupArn
    /**
     * A developer-defined identifier for the game server group that includes the game
     * server instance. The name is unique for each Region in each AWS account.
     */
    val gameServerGroupName: kotlin.String? = builder.gameServerGroupName
    /**
     * The unique identifier for the instance where the game server is running. This ID is
     * available in the instance metadata. EC2 instance IDs
     * use a 17-character format, for example: i-1234567890abcdef0.
     */
    val instanceId: kotlin.String? = builder.instanceId
    /**
     * Current status of the game server instance.
     *
     *
     * ACTIVE -- The instance is viable for hosting
     * game servers.
     *
     *
     *
     * DRAINING -- The instance is not viable for
     * hosting game servers. Existing game servers are in the process of ending, and
     * new game servers are not started on this instance unless no other resources are
     * available. When the instance is put in DRAINING, a new instance is started up to
     * replace it. Once the instance has no UTILIZED game servers, it will be terminated
     * in favor of the new instance.
     *
     *
     *
     * SPOT_TERMINATING -- The instance is in the
     * process of shutting down due to a Spot instance interruption. No new game
     * servers are started on this instance.
     */
    val instanceStatus: aws.sdk.kotlin.services.gamelift.model.GameServerInstanceStatus? = builder.instanceStatus

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.gamelift.model.GameServerInstance = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GameServerInstance(")
        append("gameServerGroupArn=$gameServerGroupArn,")
        append("gameServerGroupName=$gameServerGroupName,")
        append("instanceId=$instanceId,")
        append("instanceStatus=$instanceStatus)")
    }

    override fun hashCode(): kotlin.Int {
        var result = gameServerGroupArn?.hashCode() ?: 0
        result = 31 * result + (gameServerGroupName?.hashCode() ?: 0)
        result = 31 * result + (instanceId?.hashCode() ?: 0)
        result = 31 * result + (instanceStatus?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GameServerInstance

        if (gameServerGroupArn != other.gameServerGroupArn) return false
        if (gameServerGroupName != other.gameServerGroupName) return false
        if (instanceId != other.instanceId) return false
        if (instanceStatus != other.instanceStatus) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.gamelift.model.GameServerInstance = Builder(this).apply(block).build()

    class Builder {
        /**
         * A generated unique identifier for the game server group that includes the game
         * server instance.
         */
        var gameServerGroupArn: kotlin.String? = null
        /**
         * A developer-defined identifier for the game server group that includes the game
         * server instance. The name is unique for each Region in each AWS account.
         */
        var gameServerGroupName: kotlin.String? = null
        /**
         * The unique identifier for the instance where the game server is running. This ID is
         * available in the instance metadata. EC2 instance IDs
         * use a 17-character format, for example: i-1234567890abcdef0.
         */
        var instanceId: kotlin.String? = null
        /**
         * Current status of the game server instance.
         *
         *
         * ACTIVE -- The instance is viable for hosting
         * game servers.
         *
         *
         *
         * DRAINING -- The instance is not viable for
         * hosting game servers. Existing game servers are in the process of ending, and
         * new game servers are not started on this instance unless no other resources are
         * available. When the instance is put in DRAINING, a new instance is started up to
         * replace it. Once the instance has no UTILIZED game servers, it will be terminated
         * in favor of the new instance.
         *
         *
         *
         * SPOT_TERMINATING -- The instance is in the
         * process of shutting down due to a Spot instance interruption. No new game
         * servers are started on this instance.
         */
        var instanceStatus: aws.sdk.kotlin.services.gamelift.model.GameServerInstanceStatus? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.gamelift.model.GameServerInstance) : this() {
            this.gameServerGroupArn = x.gameServerGroupArn
            this.gameServerGroupName = x.gameServerGroupName
            this.instanceId = x.instanceId
            this.instanceStatus = x.instanceStatus
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.gamelift.model.GameServerInstance = GameServerInstance(this)
    }
}
