// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.gamelift.model



/**
 * Connection information for a new game session that is created in response to a StartMatchmaking request. Once a match is made, the FlexMatch engine
 * creates a new game session for it. This information, including the game session endpoint
 * and player sessions for each player in the original matchmaking request, is added to the
 * MatchmakingTicket, which can be retrieved by calling DescribeMatchmaking.
 */
class GameSessionConnectionInfo private constructor(builder: Builder) {
    /**
     * The DNS identifier assigned to the instance that is running the game session. Values have
     * the following format:
     *
     *
     * TLS-enabled fleets: <unique identifier>.<region identifier>.amazongamelift.com.
     *
     * Non-TLS-enabled fleets: ec2-<unique identifier>.compute.amazonaws.com. (See
     * <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-instance-addressing.html#concepts-public-addresses">Amazon EC2 Instance IP Addressing.)
     *
     *
     * When connecting to a game session that is running on a TLS-enabled fleet, you must use the DNS name, not the IP address.
     */
    val dnsName: kotlin.String? = builder.dnsName
    /**
     * A unique identifier for the game session. Use the game session ID.
     */
    val gameSessionArn: kotlin.String? = builder.gameSessionArn
    /**
     * The IP address of the game session. To connect to a GameLift game server, an app needs both the IP address and port number.
     */
    val ipAddress: kotlin.String? = builder.ipAddress
    /**
     * A collection of player session IDs, one for each player ID that was included in the
     * original matchmaking request.
     */
    val matchedPlayerSessions: List<MatchedPlayerSession>? = builder.matchedPlayerSessions
    /**
     * The port number for the game session. To connect to a GameLift game server, an app needs both the IP address and port number.
     */
    val port: kotlin.Int? = builder.port

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.gamelift.model.GameSessionConnectionInfo = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GameSessionConnectionInfo(")
        append("dnsName=$dnsName,")
        append("gameSessionArn=$gameSessionArn,")
        append("ipAddress=$ipAddress,")
        append("matchedPlayerSessions=$matchedPlayerSessions,")
        append("port=$port)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dnsName?.hashCode() ?: 0
        result = 31 * result + (gameSessionArn?.hashCode() ?: 0)
        result = 31 * result + (ipAddress?.hashCode() ?: 0)
        result = 31 * result + (matchedPlayerSessions?.hashCode() ?: 0)
        result = 31 * result + (port ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GameSessionConnectionInfo

        if (dnsName != other.dnsName) return false
        if (gameSessionArn != other.gameSessionArn) return false
        if (ipAddress != other.ipAddress) return false
        if (matchedPlayerSessions != other.matchedPlayerSessions) return false
        if (port != other.port) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.gamelift.model.GameSessionConnectionInfo = Builder(this).apply(block).build()

    class Builder {
        /**
         * The DNS identifier assigned to the instance that is running the game session. Values have
         * the following format:
         *
         *
         * TLS-enabled fleets: <unique identifier>.<region identifier>.amazongamelift.com.
         *
         * Non-TLS-enabled fleets: ec2-<unique identifier>.compute.amazonaws.com. (See
         * <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-instance-addressing.html#concepts-public-addresses">Amazon EC2 Instance IP Addressing.)
         *
         *
         * When connecting to a game session that is running on a TLS-enabled fleet, you must use the DNS name, not the IP address.
         */
        var dnsName: kotlin.String? = null
        /**
         * A unique identifier for the game session. Use the game session ID.
         */
        var gameSessionArn: kotlin.String? = null
        /**
         * The IP address of the game session. To connect to a GameLift game server, an app needs both the IP address and port number.
         */
        var ipAddress: kotlin.String? = null
        /**
         * A collection of player session IDs, one for each player ID that was included in the
         * original matchmaking request.
         */
        var matchedPlayerSessions: List<MatchedPlayerSession>? = null
        /**
         * The port number for the game session. To connect to a GameLift game server, an app needs both the IP address and port number.
         */
        var port: kotlin.Int? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.gamelift.model.GameSessionConnectionInfo) : this() {
            this.dnsName = x.dnsName
            this.gameSessionArn = x.gameSessionArn
            this.ipAddress = x.ipAddress
            this.matchedPlayerSessions = x.matchedPlayerSessions
            this.port = x.port
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.gamelift.model.GameSessionConnectionInfo = GameSessionConnectionInfo(this)
    }
}
