// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.gamelift.model



/**
 * Information required to remotely connect to a fleet instance. Access is requested
 * by calling GetInstanceAccess.
 */
class InstanceAccess private constructor(builder: Builder) {
    /**
     * Credentials required to access the instance.
     */
    val credentials: aws.sdk.kotlin.services.gamelift.model.InstanceCredentials? = builder.credentials
    /**
     * A unique identifier for the fleet containing the instance being accessed.
     */
    val fleetId: kotlin.String? = builder.fleetId
    /**
     * A unique identifier for the instance being accessed.
     */
    val instanceId: kotlin.String? = builder.instanceId
    /**
     * IP address that is assigned to the instance.
     */
    val ipAddress: kotlin.String? = builder.ipAddress
    /**
     * Operating system that is running on the instance.
     */
    val operatingSystem: aws.sdk.kotlin.services.gamelift.model.OperatingSystem? = builder.operatingSystem

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.gamelift.model.InstanceAccess = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InstanceAccess(")
        append("credentials=*** Sensitive Data Redacted ***,")
        append("fleetId=$fleetId,")
        append("instanceId=$instanceId,")
        append("ipAddress=$ipAddress,")
        append("operatingSystem=$operatingSystem)")
    }

    override fun hashCode(): kotlin.Int {
        var result = credentials?.hashCode() ?: 0
        result = 31 * result + (fleetId?.hashCode() ?: 0)
        result = 31 * result + (instanceId?.hashCode() ?: 0)
        result = 31 * result + (ipAddress?.hashCode() ?: 0)
        result = 31 * result + (operatingSystem?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InstanceAccess

        if (credentials != other.credentials) return false
        if (fleetId != other.fleetId) return false
        if (instanceId != other.instanceId) return false
        if (ipAddress != other.ipAddress) return false
        if (operatingSystem != other.operatingSystem) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.gamelift.model.InstanceAccess = Builder(this).apply(block).build()

    class Builder {
        /**
         * Credentials required to access the instance.
         */
        var credentials: aws.sdk.kotlin.services.gamelift.model.InstanceCredentials? = null
        /**
         * A unique identifier for the fleet containing the instance being accessed.
         */
        var fleetId: kotlin.String? = null
        /**
         * A unique identifier for the instance being accessed.
         */
        var instanceId: kotlin.String? = null
        /**
         * IP address that is assigned to the instance.
         */
        var ipAddress: kotlin.String? = null
        /**
         * Operating system that is running on the instance.
         */
        var operatingSystem: aws.sdk.kotlin.services.gamelift.model.OperatingSystem? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.gamelift.model.InstanceAccess) : this() {
            this.credentials = x.credentials
            this.fleetId = x.fleetId
            this.instanceId = x.instanceId
            this.ipAddress = x.ipAddress
            this.operatingSystem = x.operatingSystem
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.gamelift.model.InstanceAccess = InstanceAccess(this)

        /**
         * construct an [aws.sdk.kotlin.services.gamelift.model.InstanceCredentials] inside the given [block]
         */
        fun credentials(block: aws.sdk.kotlin.services.gamelift.model.InstanceCredentials.Builder.() -> kotlin.Unit) {
            this.credentials = aws.sdk.kotlin.services.gamelift.model.InstanceCredentials.invoke(block)
        }
    }
}
