// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.gamelift.model



/**
 * A range of IP addresses and port settings that allow inbound traffic to connect to
 * server processes on an instance in a fleet. New game sessions are assigned an IP
 * address/port number combination, which must fall into the fleet's allowed ranges. Fleets
 * with custom game builds must have permissions explicitly set. For Realtime Servers fleets, GameLift
 * automatically opens two port ranges, one for TCP messaging and one for UDP.
 *
 * Related actions
 *
 *
 * DescribeFleetPortSettings
 */
class IpPermission private constructor(builder: Builder) {
    /**
     * A starting value for a range of allowed port numbers.
     */
    val fromPort: kotlin.Int? = builder.fromPort
    /**
     * A range of allowed IP addresses. This value must be expressed in CIDR notation.
     * Example: "000.000.000.000/&#91;subnet mask&#93;" or optionally the shortened
     * version "0.0.0.0/&#91;subnet mask&#93;".
     */
    val ipRange: kotlin.String? = builder.ipRange
    /**
     * The network communication protocol used by the fleet.
     */
    val protocol: aws.sdk.kotlin.services.gamelift.model.IpProtocol? = builder.protocol
    /**
     * An ending value for a range of allowed port numbers. Port numbers are end-inclusive.
     * This value must be higher than FromPort.
     */
    val toPort: kotlin.Int? = builder.toPort

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.gamelift.model.IpPermission = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("IpPermission(")
        append("fromPort=$fromPort,")
        append("ipRange=$ipRange,")
        append("protocol=$protocol,")
        append("toPort=$toPort)")
    }

    override fun hashCode(): kotlin.Int {
        var result = fromPort ?: 0
        result = 31 * result + (ipRange?.hashCode() ?: 0)
        result = 31 * result + (protocol?.hashCode() ?: 0)
        result = 31 * result + (toPort ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as IpPermission

        if (fromPort != other.fromPort) return false
        if (ipRange != other.ipRange) return false
        if (protocol != other.protocol) return false
        if (toPort != other.toPort) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.gamelift.model.IpPermission = Builder(this).apply(block).build()

    class Builder {
        /**
         * A starting value for a range of allowed port numbers.
         */
        var fromPort: kotlin.Int? = null
        /**
         * A range of allowed IP addresses. This value must be expressed in CIDR notation.
         * Example: "000.000.000.000/&#91;subnet mask&#93;" or optionally the shortened
         * version "0.0.0.0/&#91;subnet mask&#93;".
         */
        var ipRange: kotlin.String? = null
        /**
         * The network communication protocol used by the fleet.
         */
        var protocol: aws.sdk.kotlin.services.gamelift.model.IpProtocol? = null
        /**
         * An ending value for a range of allowed port numbers. Port numbers are end-inclusive.
         * This value must be higher than FromPort.
         */
        var toPort: kotlin.Int? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.gamelift.model.IpPermission) : this() {
            this.fromPort = x.fromPort
            this.ipRange = x.ipRange
            this.protocol = x.protocol
            this.toPort = x.toPort
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.gamelift.model.IpPermission = IpPermission(this)
    }
}
