// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.gamelift.model



/**
 * This data type is used with the GameLift FleetIQ and game server groups.
 *
 * An EC2 launch template that contains configuration settings and game server code to
 * be deployed to all instances in a game server group. The launch template is specified
 * when creating a new game server group with CreateGameServerGroup.
 */
class LaunchTemplateSpecification private constructor(builder: Builder) {
    /**
     * A unique identifier for an existing EC2 launch template.
     */
    val launchTemplateId: kotlin.String? = builder.launchTemplateId
    /**
     * A readable identifier for an existing EC2 launch template.
     */
    val launchTemplateName: kotlin.String? = builder.launchTemplateName
    /**
     * The version of the EC2 launch template to use. If no version is specified, the
     * default version will be used. With Amazon EC2, you can specify a default version for a
     * launch template. If none is set, the default is the first version created.
     */
    val version: kotlin.String? = builder.version

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.gamelift.model.LaunchTemplateSpecification = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("LaunchTemplateSpecification(")
        append("launchTemplateId=$launchTemplateId,")
        append("launchTemplateName=$launchTemplateName,")
        append("version=$version)")
    }

    override fun hashCode(): kotlin.Int {
        var result = launchTemplateId?.hashCode() ?: 0
        result = 31 * result + (launchTemplateName?.hashCode() ?: 0)
        result = 31 * result + (version?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as LaunchTemplateSpecification

        if (launchTemplateId != other.launchTemplateId) return false
        if (launchTemplateName != other.launchTemplateName) return false
        if (version != other.version) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.gamelift.model.LaunchTemplateSpecification = Builder(this).apply(block).build()

    class Builder {
        /**
         * A unique identifier for an existing EC2 launch template.
         */
        var launchTemplateId: kotlin.String? = null
        /**
         * A readable identifier for an existing EC2 launch template.
         */
        var launchTemplateName: kotlin.String? = null
        /**
         * The version of the EC2 launch template to use. If no version is specified, the
         * default version will be used. With Amazon EC2, you can specify a default version for a
         * launch template. If none is set, the default is the first version created.
         */
        var version: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.gamelift.model.LaunchTemplateSpecification) : this() {
            this.launchTemplateId = x.launchTemplateId
            this.launchTemplateName = x.launchTemplateName
            this.version = x.version
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.gamelift.model.LaunchTemplateSpecification = LaunchTemplateSpecification(this)
    }
}
