// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.gamelift.model



/**
 * Represents the input for a request operation.
 */
class ListFleetsRequest private constructor(builder: Builder) {
    /**
     * A unique identifier for the build to request fleets for. Use this parameter to return only fleets using a
     * specified build. Use either the build ID or ARN value.
     */
    val buildId: kotlin.String? = builder.buildId
    /**
     * The maximum number of results to return. Use this parameter with NextToken to get results as a set of sequential pages.
     */
    val limit: kotlin.Int? = builder.limit
    /**
     * A token that indicates the start of the next sequential page of results. Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value.
     */
    val nextToken: kotlin.String? = builder.nextToken
    /**
     * A unique identifier for the Realtime script to request fleets for. Use this parameter to return only fleets using a
     * specified script. Use either the script ID or ARN value.
     */
    val scriptId: kotlin.String? = builder.scriptId

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.gamelift.model.ListFleetsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListFleetsRequest(")
        append("buildId=$buildId,")
        append("limit=$limit,")
        append("nextToken=$nextToken,")
        append("scriptId=$scriptId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = buildId?.hashCode() ?: 0
        result = 31 * result + (limit ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (scriptId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListFleetsRequest

        if (buildId != other.buildId) return false
        if (limit != other.limit) return false
        if (nextToken != other.nextToken) return false
        if (scriptId != other.scriptId) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.gamelift.model.ListFleetsRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * A unique identifier for the build to request fleets for. Use this parameter to return only fleets using a
         * specified build. Use either the build ID or ARN value.
         */
        var buildId: kotlin.String? = null
        /**
         * The maximum number of results to return. Use this parameter with NextToken to get results as a set of sequential pages.
         */
        var limit: kotlin.Int? = null
        /**
         * A token that indicates the start of the next sequential page of results. Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value.
         */
        var nextToken: kotlin.String? = null
        /**
         * A unique identifier for the Realtime script to request fleets for. Use this parameter to return only fleets using a
         * specified script. Use either the script ID or ARN value.
         */
        var scriptId: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.gamelift.model.ListFleetsRequest) : this() {
            this.buildId = x.buildId
            this.limit = x.limit
            this.nextToken = x.nextToken
            this.scriptId = x.scriptId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.gamelift.model.ListFleetsRequest = ListFleetsRequest(this)
    }
}
