// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.gamelift.model



/**
 * Represents a location in a multi-location fleet.
 *
 * Related actions
 *
 *
 * DescribeFleetLocationAttributes
 */
class LocationAttributes private constructor(builder: Builder) {
    /**
     * A fleet location and its current life-cycle state.
     */
    val locationState: aws.sdk.kotlin.services.gamelift.model.LocationState? = builder.locationState
    /**
     * A list of fleet actions that have been suspended in the fleet location.
     */
    val stoppedActions: List<FleetAction>? = builder.stoppedActions
    /**
     * The status of fleet activity updates to the location. The status
     * PENDING_UPDATE indicates that StopFleetActions or StartFleetActions
     * has been requested but the update has not yet been completed for the location.
     */
    val updateStatus: aws.sdk.kotlin.services.gamelift.model.LocationUpdateStatus? = builder.updateStatus

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.gamelift.model.LocationAttributes = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("LocationAttributes(")
        append("locationState=$locationState,")
        append("stoppedActions=$stoppedActions,")
        append("updateStatus=$updateStatus)")
    }

    override fun hashCode(): kotlin.Int {
        var result = locationState?.hashCode() ?: 0
        result = 31 * result + (stoppedActions?.hashCode() ?: 0)
        result = 31 * result + (updateStatus?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as LocationAttributes

        if (locationState != other.locationState) return false
        if (stoppedActions != other.stoppedActions) return false
        if (updateStatus != other.updateStatus) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.gamelift.model.LocationAttributes = Builder(this).apply(block).build()

    class Builder {
        /**
         * A fleet location and its current life-cycle state.
         */
        var locationState: aws.sdk.kotlin.services.gamelift.model.LocationState? = null
        /**
         * A list of fleet actions that have been suspended in the fleet location.
         */
        var stoppedActions: List<FleetAction>? = null
        /**
         * The status of fleet activity updates to the location. The status
         * PENDING_UPDATE indicates that StopFleetActions or StartFleetActions
         * has been requested but the update has not yet been completed for the location.
         */
        var updateStatus: aws.sdk.kotlin.services.gamelift.model.LocationUpdateStatus? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.gamelift.model.LocationAttributes) : this() {
            this.locationState = x.locationState
            this.stoppedActions = x.stoppedActions
            this.updateStatus = x.updateStatus
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.gamelift.model.LocationAttributes = LocationAttributes(this)

        /**
         * construct an [aws.sdk.kotlin.services.gamelift.model.LocationState] inside the given [block]
         */
        fun locationState(block: aws.sdk.kotlin.services.gamelift.model.LocationState.Builder.() -> kotlin.Unit) {
            this.locationState = aws.sdk.kotlin.services.gamelift.model.LocationState.invoke(block)
        }
    }
}
