// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.gamelift.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Guidelines for use with FlexMatch to match players into games. All matchmaking
 * requests must specify a matchmaking configuration.
 */
class MatchmakingConfiguration private constructor(builder: Builder) {
    /**
     * A flag that indicates whether a match that was created with this configuration must be
     * accepted by the matched players. To require acceptance, set to TRUE. When this option is
     * enabled, matchmaking tickets use the status REQUIRES_ACCEPTANCE to indicate
     * when a completed potential match is waiting for player acceptance.
     */
    val acceptanceRequired: kotlin.Boolean? = builder.acceptanceRequired
    /**
     * The length of time (in seconds) to wait for players to accept a proposed match, if
     * acceptance is required. If any player rejects the match or fails to accept before the
     * timeout, the ticket continues to look for an acceptable match.
     */
    val acceptanceTimeoutSeconds: kotlin.Int? = builder.acceptanceTimeoutSeconds
    /**
     * The number of player slots in a match to keep open for future players. For example, if the configuration's rule set specifies
     * a match for a single 12-person team, and the additional player count is set to 2, only 10 players are selected for the match. This parameter is not used when FlexMatchMode is set to
     * STANDALONE.
     */
    val additionalPlayerCount: kotlin.Int? = builder.additionalPlayerCount
    /**
     * The method used to backfill game sessions created with this matchmaking configuration.
     * MANUAL indicates that the game makes backfill requests or does not use the match
     * backfill feature. AUTOMATIC indicates that GameLift creates StartMatchBackfill requests whenever a game session has one or more open
     * slots. Learn more about manual and automatic backfill in <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-backfill.html">Backfill existing games
     * with FlexMatch. Automatic backfill is not available when
     * FlexMatchMode is set to STANDALONE.
     */
    val backfillMode: aws.sdk.kotlin.services.gamelift.model.BackfillMode? = builder.backfillMode
    /**
     * The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN) that is assigned to a GameLift matchmaking configuration resource and uniquely identifies it. ARNs are unique across all Regions. Format is arn:aws:gamelift:<region>::matchmakingconfiguration/<matchmaking configuration name>. In a GameLift configuration ARN, the resource ID matches the
     * Name value.
     */
    val configurationArn: kotlin.String? = builder.configurationArn
    /**
     * A time stamp indicating when this data object was created. Format is a number expressed in Unix time as milliseconds (for example "1469498468.057").
     */
    val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * Information to attach to all events related to the matchmaking configuration.
     */
    val customEventData: kotlin.String? = builder.customEventData
    /**
     * A descriptive label that is associated with matchmaking configuration.
     */
    val description: kotlin.String? = builder.description
    /**
     * Indicates whether this matchmaking configuration is being used with GameLift hosting or
     * as a standalone matchmaking solution.
     *
     *
     *
     * STANDALONE - FlexMatch forms matches and returns
     * match information, including players and team assignments, in a
     * <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-events.html#match-events-matchmakingsucceeded">
     * MatchmakingSucceeded event.
     *
     *
     * WITH_QUEUE - FlexMatch forms matches and uses the specified GameLift queue to
     * start a game session for the match.
     */
    val flexMatchMode: aws.sdk.kotlin.services.gamelift.model.FlexMatchMode? = builder.flexMatchMode
    /**
     * A set of custom properties for a game session, formatted as key:value pairs. These properties are passed to a game server process in the
     * GameSession object with a request to start a new game session (see <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession">Start a Game Session). This information is added to the new GameSession
     * object that is created for a successful match. This parameter is not used when
     * FlexMatchMode is set to STANDALONE.
     */
    val gameProperties: List<GameProperty>? = builder.gameProperties
    /**
     * A set of custom game session properties, formatted as a single string value. This data is passed to a game server process in the
     * GameSession object with a request to start a new game session (see <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession">Start a Game Session). This information is added to the new GameSession object
     * that is created for a successful match. This parameter is not used when
     * FlexMatchMode is set to STANDALONE.
     */
    val gameSessionData: kotlin.String? = builder.gameSessionData
    /**
     * The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN) that is assigned to a GameLift game session queue resource and uniquely identifies it. ARNs are unique across all Regions. Format is arn:aws:gamelift:<region>::gamesessionqueue/<queue name>. Queues can be located in any Region. Queues are used to start new
     * GameLift-hosted game sessions for matches that are created with this matchmaking
     * configuration. This property is not set when FlexMatchMode is set to
     * STANDALONE.
     */
    val gameSessionQueueArns: List<String>? = builder.gameSessionQueueArns
    /**
     * A unique identifier for the matchmaking configuration. This name is used to identify the configuration associated with a
     * matchmaking request or ticket.
     */
    val name: kotlin.String? = builder.name
    /**
     * An SNS topic ARN that is set up to receive matchmaking notifications.
     */
    val notificationTarget: kotlin.String? = builder.notificationTarget
    /**
     * The maximum duration, in seconds, that a matchmaking ticket can remain in process
     * before timing out. Requests that fail due to timing out can be resubmitted as
     * needed.
     */
    val requestTimeoutSeconds: kotlin.Int? = builder.requestTimeoutSeconds
    /**
     * The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN) associated with the GameLift matchmaking rule set resource that this configuration uses.
     */
    val ruleSetArn: kotlin.String? = builder.ruleSetArn
    /**
     * A unique identifier for the matchmaking rule set to use with this configuration. A matchmaking configuration can only use
     * rule sets that are defined in the same Region.
     */
    val ruleSetName: kotlin.String? = builder.ruleSetName

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.gamelift.model.MatchmakingConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("MatchmakingConfiguration(")
        append("acceptanceRequired=$acceptanceRequired,")
        append("acceptanceTimeoutSeconds=$acceptanceTimeoutSeconds,")
        append("additionalPlayerCount=$additionalPlayerCount,")
        append("backfillMode=$backfillMode,")
        append("configurationArn=$configurationArn,")
        append("creationTime=$creationTime,")
        append("customEventData=$customEventData,")
        append("description=$description,")
        append("flexMatchMode=$flexMatchMode,")
        append("gameProperties=$gameProperties,")
        append("gameSessionData=$gameSessionData,")
        append("gameSessionQueueArns=$gameSessionQueueArns,")
        append("name=$name,")
        append("notificationTarget=$notificationTarget,")
        append("requestTimeoutSeconds=$requestTimeoutSeconds,")
        append("ruleSetArn=$ruleSetArn,")
        append("ruleSetName=$ruleSetName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = acceptanceRequired?.hashCode() ?: 0
        result = 31 * result + (acceptanceTimeoutSeconds ?: 0)
        result = 31 * result + (additionalPlayerCount ?: 0)
        result = 31 * result + (backfillMode?.hashCode() ?: 0)
        result = 31 * result + (configurationArn?.hashCode() ?: 0)
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (customEventData?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (flexMatchMode?.hashCode() ?: 0)
        result = 31 * result + (gameProperties?.hashCode() ?: 0)
        result = 31 * result + (gameSessionData?.hashCode() ?: 0)
        result = 31 * result + (gameSessionQueueArns?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (notificationTarget?.hashCode() ?: 0)
        result = 31 * result + (requestTimeoutSeconds ?: 0)
        result = 31 * result + (ruleSetArn?.hashCode() ?: 0)
        result = 31 * result + (ruleSetName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as MatchmakingConfiguration

        if (acceptanceRequired != other.acceptanceRequired) return false
        if (acceptanceTimeoutSeconds != other.acceptanceTimeoutSeconds) return false
        if (additionalPlayerCount != other.additionalPlayerCount) return false
        if (backfillMode != other.backfillMode) return false
        if (configurationArn != other.configurationArn) return false
        if (creationTime != other.creationTime) return false
        if (customEventData != other.customEventData) return false
        if (description != other.description) return false
        if (flexMatchMode != other.flexMatchMode) return false
        if (gameProperties != other.gameProperties) return false
        if (gameSessionData != other.gameSessionData) return false
        if (gameSessionQueueArns != other.gameSessionQueueArns) return false
        if (name != other.name) return false
        if (notificationTarget != other.notificationTarget) return false
        if (requestTimeoutSeconds != other.requestTimeoutSeconds) return false
        if (ruleSetArn != other.ruleSetArn) return false
        if (ruleSetName != other.ruleSetName) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.gamelift.model.MatchmakingConfiguration = Builder(this).apply(block).build()

    class Builder {
        /**
         * A flag that indicates whether a match that was created with this configuration must be
         * accepted by the matched players. To require acceptance, set to TRUE. When this option is
         * enabled, matchmaking tickets use the status REQUIRES_ACCEPTANCE to indicate
         * when a completed potential match is waiting for player acceptance.
         */
        var acceptanceRequired: kotlin.Boolean? = null
        /**
         * The length of time (in seconds) to wait for players to accept a proposed match, if
         * acceptance is required. If any player rejects the match or fails to accept before the
         * timeout, the ticket continues to look for an acceptable match.
         */
        var acceptanceTimeoutSeconds: kotlin.Int? = null
        /**
         * The number of player slots in a match to keep open for future players. For example, if the configuration's rule set specifies
         * a match for a single 12-person team, and the additional player count is set to 2, only 10 players are selected for the match. This parameter is not used when FlexMatchMode is set to
         * STANDALONE.
         */
        var additionalPlayerCount: kotlin.Int? = null
        /**
         * The method used to backfill game sessions created with this matchmaking configuration.
         * MANUAL indicates that the game makes backfill requests or does not use the match
         * backfill feature. AUTOMATIC indicates that GameLift creates StartMatchBackfill requests whenever a game session has one or more open
         * slots. Learn more about manual and automatic backfill in <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-backfill.html">Backfill existing games
         * with FlexMatch. Automatic backfill is not available when
         * FlexMatchMode is set to STANDALONE.
         */
        var backfillMode: aws.sdk.kotlin.services.gamelift.model.BackfillMode? = null
        /**
         * The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN) that is assigned to a GameLift matchmaking configuration resource and uniquely identifies it. ARNs are unique across all Regions. Format is arn:aws:gamelift:<region>::matchmakingconfiguration/<matchmaking configuration name>. In a GameLift configuration ARN, the resource ID matches the
         * Name value.
         */
        var configurationArn: kotlin.String? = null
        /**
         * A time stamp indicating when this data object was created. Format is a number expressed in Unix time as milliseconds (for example "1469498468.057").
         */
        var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Information to attach to all events related to the matchmaking configuration.
         */
        var customEventData: kotlin.String? = null
        /**
         * A descriptive label that is associated with matchmaking configuration.
         */
        var description: kotlin.String? = null
        /**
         * Indicates whether this matchmaking configuration is being used with GameLift hosting or
         * as a standalone matchmaking solution.
         *
         *
         *
         * STANDALONE - FlexMatch forms matches and returns
         * match information, including players and team assignments, in a
         * <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-events.html#match-events-matchmakingsucceeded">
         * MatchmakingSucceeded event.
         *
         *
         * WITH_QUEUE - FlexMatch forms matches and uses the specified GameLift queue to
         * start a game session for the match.
         */
        var flexMatchMode: aws.sdk.kotlin.services.gamelift.model.FlexMatchMode? = null
        /**
         * A set of custom properties for a game session, formatted as key:value pairs. These properties are passed to a game server process in the
         * GameSession object with a request to start a new game session (see <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession">Start a Game Session). This information is added to the new GameSession
         * object that is created for a successful match. This parameter is not used when
         * FlexMatchMode is set to STANDALONE.
         */
        var gameProperties: List<GameProperty>? = null
        /**
         * A set of custom game session properties, formatted as a single string value. This data is passed to a game server process in the
         * GameSession object with a request to start a new game session (see <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession">Start a Game Session). This information is added to the new GameSession object
         * that is created for a successful match. This parameter is not used when
         * FlexMatchMode is set to STANDALONE.
         */
        var gameSessionData: kotlin.String? = null
        /**
         * The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN) that is assigned to a GameLift game session queue resource and uniquely identifies it. ARNs are unique across all Regions. Format is arn:aws:gamelift:<region>::gamesessionqueue/<queue name>. Queues can be located in any Region. Queues are used to start new
         * GameLift-hosted game sessions for matches that are created with this matchmaking
         * configuration. This property is not set when FlexMatchMode is set to
         * STANDALONE.
         */
        var gameSessionQueueArns: List<String>? = null
        /**
         * A unique identifier for the matchmaking configuration. This name is used to identify the configuration associated with a
         * matchmaking request or ticket.
         */
        var name: kotlin.String? = null
        /**
         * An SNS topic ARN that is set up to receive matchmaking notifications.
         */
        var notificationTarget: kotlin.String? = null
        /**
         * The maximum duration, in seconds, that a matchmaking ticket can remain in process
         * before timing out. Requests that fail due to timing out can be resubmitted as
         * needed.
         */
        var requestTimeoutSeconds: kotlin.Int? = null
        /**
         * The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN) associated with the GameLift matchmaking rule set resource that this configuration uses.
         */
        var ruleSetArn: kotlin.String? = null
        /**
         * A unique identifier for the matchmaking rule set to use with this configuration. A matchmaking configuration can only use
         * rule sets that are defined in the same Region.
         */
        var ruleSetName: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.gamelift.model.MatchmakingConfiguration) : this() {
            this.acceptanceRequired = x.acceptanceRequired
            this.acceptanceTimeoutSeconds = x.acceptanceTimeoutSeconds
            this.additionalPlayerCount = x.additionalPlayerCount
            this.backfillMode = x.backfillMode
            this.configurationArn = x.configurationArn
            this.creationTime = x.creationTime
            this.customEventData = x.customEventData
            this.description = x.description
            this.flexMatchMode = x.flexMatchMode
            this.gameProperties = x.gameProperties
            this.gameSessionData = x.gameSessionData
            this.gameSessionQueueArns = x.gameSessionQueueArns
            this.name = x.name
            this.notificationTarget = x.notificationTarget
            this.requestTimeoutSeconds = x.requestTimeoutSeconds
            this.ruleSetArn = x.ruleSetArn
            this.ruleSetName = x.ruleSetName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.gamelift.model.MatchmakingConfiguration = MatchmakingConfiguration(this)
    }
}
